/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collections;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.BooleanFunctionCondition;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.ListPredicate;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Predicates {
    public static Condition exists(Property property) {
        Assert.notNull(property, "The property for exists() is required.");
        return new BooleanFunctionCondition(new FunctionInvocation("exists", property));
    }

    public static Condition exists(RelationshipPattern pattern) {
        Assert.notNull(pattern, "The pattern for exists() is required.");
        return new BooleanFunctionCondition(new FunctionInvocation("exists", new Pattern(Collections.singletonList(pattern))));
    }

    public static OngoingListBasedPredicateFunction all(String variable) {
        return Predicates.all(SymbolicName.create(variable));
    }

    public static OngoingListBasedPredicateFunction all(SymbolicName variable) {
        return new Builder("all", variable);
    }

    public static OngoingListBasedPredicateFunction any(String variable) {
        return Predicates.any(SymbolicName.create(variable));
    }

    public static OngoingListBasedPredicateFunction any(SymbolicName variable) {
        return new Builder("any", variable);
    }

    public static OngoingListBasedPredicateFunction none(String variable) {
        return Predicates.none(SymbolicName.create(variable));
    }

    public static OngoingListBasedPredicateFunction none(SymbolicName variable) {
        return new Builder("none", variable);
    }

    public static OngoingListBasedPredicateFunction single(String variable) {
        return Predicates.single(SymbolicName.create(variable));
    }

    public static OngoingListBasedPredicateFunction single(SymbolicName variable) {
        return new Builder("single", variable);
    }

    private Predicates() {
    }

    private static class Builder
    implements OngoingListBasedPredicateFunction,
    OngoingListBasedPredicateFunctionWithList {
        private final String predicate;
        private final SymbolicName name;
        private Expression listExpression;

        Builder(String predicate, SymbolicName name) {
            Assert.notNull(predicate, "The predicate is required");
            Assert.notNull(name, "The name is required");
            this.predicate = predicate;
            this.name = name;
        }

        @Override
        public OngoingListBasedPredicateFunctionWithList in(Expression list) {
            Assert.notNull(list, "The list expression is required");
            this.listExpression = list;
            return this;
        }

        @Override
        public Condition where(Condition condition) {
            Assert.notNull(condition, "The condition is required");
            return new BooleanFunctionCondition(new FunctionInvocation(this.predicate, new ListPredicate(this.name, this.listExpression, new Where(condition))));
        }
    }

    public static interface OngoingListBasedPredicateFunctionWithList {
        public Condition where(Condition var1);
    }

    public static interface OngoingListBasedPredicateFunction {
        public OngoingListBasedPredicateFunctionWithList in(Expression var1);
    }
}

