/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operator;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
final class Operations {
    static Operation concat(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.CONCAT, op2);
    }

    static Operation add(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.ADDITION, op2);
    }

    static Operation subtract(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.SUBTRACTION, op2);
    }

    static Operation multiply(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.MULTIPLICATION, op2);
    }

    static Operation divide(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.DIVISION, op2);
    }

    static Operation remainder(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.MODULO_DIVISION, op2);
    }

    static Operation pow(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.EXPONENTIATION, op2);
    }

    static Operation set(Expression target, Expression value) {
        return Operation.create(target, Operator.SET, value);
    }

    static Operation set(Node target, String ... label) {
        return Operation.create(target, Operator.SET_LABEL, label);
    }

    static Operation remove(Node target, String ... label) {
        return Operation.create(target, Operator.REMOVE_LABEL, label);
    }

    private Operations() {
    }
}

