/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.NodeLabels;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Operation
implements Expression {
    private static final EnumSet<Operator> LABEL_OPERATORS = EnumSet.of(Operator.SET_LABEL, Operator.REMOVE_LABEL);
    private static final EnumSet<Operator.Type> NEEDS_GROUPING_BY_TYPE = EnumSet.complementOf(EnumSet.of(Operator.Type.PROPERTY, Operator.Type.LABEL));
    private static final EnumSet<Operator> DONT_GROUP = EnumSet.of(Operator.EXPONENTIATION, Operator.PIPE);
    private final Expression left;
    private final Operator operator;
    private final Visitable right;

    static Operation create(Expression op1, Operator operator, Expression op2) {
        Assert.notNull(op1, "The first operand must not be null.");
        Assert.notNull(operator, "Operator must not be empty.");
        Assert.notNull(op2, "The second operand must not be null.");
        return new Operation(op1, operator, op2);
    }

    static Operation create(Node op1, Operator operator, String ... nodeLabels) {
        Assert.notNull(op1, "The first operand must not be null.");
        Assert.isTrue(op1.getSymbolicName().isPresent(), "The node must have a name.");
        Assert.isTrue(LABEL_OPERATORS.contains(operator), String.format("Only operators %s can be used to modify labels", LABEL_OPERATORS));
        Assert.notEmpty(nodeLabels, "The labels cannot be empty.");
        List<NodeLabel> listOfNodeLabels = Arrays.stream(nodeLabels).map(NodeLabel::new).collect(Collectors.toList());
        return new Operation((Expression)op1.getRequiredSymbolicName(), operator, new NodeLabels(listOfNodeLabels));
    }

    Operation(Expression left, Operator operator, Expression right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    Operation(Expression left, Operator operator, NodeLabels right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Expressions.nameOrExpression(this.left).accept(visitor);
        this.operator.accept(visitor);
        this.right.accept(visitor);
        visitor.leave(this);
    }

    public boolean needsGrouping() {
        return NEEDS_GROUPING_BY_TYPE.contains((Object)this.operator.getType()) && !DONT_GROUP.contains(this.operator);
    }
}

