/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collections;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.DistinctExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Functions {
    private static final String F_ID = "id";

    public static FunctionInvocation id(Node node) {
        Assert.notNull(node, "The node parameter is required.");
        return new FunctionInvocation(F_ID, node.getRequiredSymbolicName());
    }

    public static FunctionInvocation id(Relationship relationship) {
        Assert.notNull(relationship, "The relationship parameter is required.");
        return new FunctionInvocation(F_ID, relationship.getRequiredSymbolicName());
    }

    public static FunctionInvocation labels(Node node) {
        Assert.notNull(node, "The node parameter is required.");
        return new FunctionInvocation("labels", node.getRequiredSymbolicName());
    }

    public static FunctionInvocation type(Relationship relationship) {
        Assert.notNull(relationship, "The relationship parameter is required.");
        return new FunctionInvocation("type", relationship.getRequiredSymbolicName());
    }

    public static FunctionInvocation count(Node node) {
        Assert.notNull(node, "The node parameter is required.");
        return Functions.count(node.getRequiredSymbolicName());
    }

    public static FunctionInvocation count(Expression expression) {
        Assert.notNull(expression, "The expression to count is required.");
        return new FunctionInvocation("count", expression);
    }

    public static FunctionInvocation countDistinct(Node node) {
        Assert.notNull(node, "The node parameter is required.");
        return Functions.countDistinct(node.getRequiredSymbolicName());
    }

    public static FunctionInvocation countDistinct(Expression expression) {
        Assert.notNull(expression, "The expression to count is required.");
        return new FunctionInvocation("count", new DistinctExpression(expression));
    }

    public static FunctionInvocation coalesce(Expression ... expressions) {
        Assert.notEmpty(expressions, "At least one expression is required.");
        Assert.notNull(expressions[0], "At least one expression is required.");
        return new FunctionInvocation("coalesce", expressions);
    }

    public static FunctionInvocation toLower(Expression expression) {
        Assert.notNull(expression, "The expression for toLower() is required.");
        return new FunctionInvocation("toLower", expression);
    }

    public static FunctionInvocation size(Expression expression) {
        Assert.notNull(expression, "The expression for size() is required.");
        return new FunctionInvocation("size", expression);
    }

    public static FunctionInvocation size(RelationshipPattern pattern) {
        Assert.notNull(pattern, "The pattern for size() is required.");
        return new FunctionInvocation("size", new Pattern(Collections.singletonList(pattern)));
    }

    public static FunctionInvocation exists(Expression expression) {
        Assert.notNull(expression, "The expression for exists() is required.");
        return new FunctionInvocation("exists", expression);
    }

    public static FunctionInvocation distance(Expression point1, Expression point2) {
        Assert.notNull(point1, "The distance function requires two points.");
        Assert.notNull(point2, "The distance function requires two points.");
        return new FunctionInvocation("distance", point1, point2);
    }

    public static FunctionInvocation point(MapExpression parameterMap) {
        Assert.notNull(parameterMap, "The parameter map is required.");
        return new FunctionInvocation("point", parameterMap);
    }

    public static FunctionInvocation avg(Expression expression) {
        Assert.notNull(expression, "The expression to average is required.");
        return new FunctionInvocation("avg", expression);
    }

    public static FunctionInvocation collect(Named variable) {
        Assert.notNull(variable, "The variable parameter is required.");
        return Functions.collect(variable.getRequiredSymbolicName());
    }

    public static FunctionInvocation collect(Expression expression) {
        Assert.notNull(expression, "The expression to collect is required.");
        return new FunctionInvocation("collect", expression);
    }

    public static FunctionInvocation max(Expression expression) {
        Assert.notNull(expression, "The expression for max is required.");
        return new FunctionInvocation("max", expression);
    }

    public static FunctionInvocation min(Expression expression) {
        Assert.notNull(expression, "The expression for min is required.");
        return new FunctionInvocation("min", expression);
    }

    public static FunctionInvocation percentileCont(Expression expression, Number percentile) {
        Assert.notNull(expression, "The numeric expression for percentileCont is required.");
        Assert.notNull(percentile, "The percentile for percentileCont is required.");
        double p = percentile.doubleValue();
        Assert.isTrue(p >= 0.0 && p <= 1.0, "The percentile for percentileCont must be between 0.0 and 1.0.");
        return new FunctionInvocation("percentileCont", expression, new NumberLiteral(percentile));
    }

    public static FunctionInvocation percentileDisc(Expression expression, Number percentile) {
        Assert.notNull(expression, "The numeric expression for percentileDisc is required.");
        Assert.notNull(percentile, "The percentile for percentileDisc is required.");
        double p = percentile.doubleValue();
        Assert.isTrue(p >= 0.0 && p <= 1.0, "The percentile for percentileDisc must be between 0.0 and 1.0.");
        return new FunctionInvocation("percentileDisc", expression, new NumberLiteral(percentile));
    }

    public static FunctionInvocation stDev(Expression expression) {
        Assert.notNull(expression, "The numeric expression for stDev is required.");
        return new FunctionInvocation("stDev", expression);
    }

    public static FunctionInvocation stDevP(Expression expression) {
        Assert.notNull(expression, "The numeric expression for stDevP is required.");
        return new FunctionInvocation("stDevP", expression);
    }

    public static FunctionInvocation sum(Expression expression) {
        Assert.notNull(expression, "The set of numeric expression for sum is required.");
        return new FunctionInvocation("sum", expression);
    }

    public static FunctionInvocation range(Expression start, Expression end) {
        return Functions.range(start, end, null);
    }

    public static FunctionInvocation range(Expression start, Expression end, Expression step) {
        Assert.notNull(start, "The expression for range is required.");
        Assert.notNull(end, "The expression for range is required.");
        if (step == null) {
            return new FunctionInvocation("range", start, end);
        }
        return new FunctionInvocation("range", start, end, step);
    }

    public static FunctionInvocation head(Expression expression) {
        Assert.notNull(expression, "The expression for head is required.");
        return new FunctionInvocation("head", expression);
    }

    public static FunctionInvocation last(Expression expression) {
        Assert.notNull(expression, "The expression for last is required.");
        return new FunctionInvocation("last", expression);
    }

    public static FunctionInvocation nodes(NamedPath path) {
        Assert.notNull(path, "The path for nodes is required.");
        return path.getSymbolicName().map(n -> new FunctionInvocation("nodes", (Expression)n)).orElseThrow(() -> new IllegalArgumentException("The path needs to be named!"));
    }

    public static FunctionInvocation shortestPath(Relationship relationship) {
        Assert.notNull(relationship, "The relationship for shortestPath is required.");
        return new FunctionInvocation("shortestPath", new Pattern(Collections.singletonList(relationship)));
    }

    private Functions() {
    }
}

