/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Assert;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MultiPartElement;
import org.neo4j.cypherdsl.core.MultiPartQuery;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.SinglePartQuery;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.support.Visitable;

class DefaultStatementBuilder
implements StatementBuilder,
StatementBuilder.OngoingReading,
StatementBuilder.OngoingUpdate,
StatementBuilder.OngoingReadingWithWhere,
StatementBuilder.OngoingReadingWithoutWhere,
StatementBuilder.OngoingMatchAndUpdate {
    private final List<Visitable> currentSinglePartElements = new ArrayList<Visitable>();
    private MatchBuilder currentOngoingMatch;
    private DefaultStatementWithUpdateBuilder currentOngoingUpdate;
    private final List<MultiPartElement> multiPartElements = new ArrayList<MultiPartElement>();
    private static final EnumSet<UpdateType> MERGE_OR_CREATE = EnumSet.of(UpdateType.CREATE, UpdateType.MERGE);

    DefaultStatementBuilder() {
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere optionalMatch(PatternElement ... pattern) {
        return this.match(true, pattern);
    }

    @Override
    public StatementBuilder.OngoingReadingWithoutWhere match(PatternElement ... pattern) {
        return this.match(false, pattern);
    }

    private StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        Assert.notNull(pattern, "Patterns to match are required.");
        Assert.notEmpty(pattern, "At least one pattern to match is required.");
        if (this.currentOngoingMatch != null) {
            this.currentSinglePartElements.add(this.currentOngoingMatch.buildMatch());
        }
        this.currentOngoingMatch = new MatchBuilder(optional);
        this.currentOngoingMatch.patternList.addAll(Arrays.asList(pattern));
        return this;
    }

    public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return this.update(UpdateType.CREATE, pattern);
    }

    public StatementBuilder.OngoingUpdate merge(PatternElement ... pattern) {
        return this.update(UpdateType.MERGE, pattern);
    }

    @Override
    public StatementBuilder.OngoingUnwind unwind(Expression expression) {
        if (this.currentOngoingMatch != null) {
            this.currentSinglePartElements.add(this.currentOngoingMatch.buildMatch());
            this.currentOngoingMatch = null;
        }
        return new DefaultOngoingUnwind(expression);
    }

    private <T extends StatementBuilder.OngoingUpdate & StatementBuilder.OngoingMatchAndUpdate> T update(UpdateType updateType, Object[] pattern) {
        Assert.notNull(pattern, "Patterns to create are required.");
        Assert.notEmpty(pattern, "At least one pattern to create is required.");
        if (this.currentOngoingMatch != null) {
            this.currentSinglePartElements.add(this.currentOngoingMatch.buildMatch());
        }
        this.currentOngoingMatch = null;
        if (this.currentOngoingUpdate != null) {
            this.currentSinglePartElements.add(this.currentOngoingUpdate.buildUpdatingClause());
        }
        if (pattern.getClass().getComponentType() == PatternElement.class) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (PatternElement[])pattern);
        } else if (pattern.getClass().getComponentType() == Expression.class) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (Expression[])pattern);
        }
        return (T)this;
    }

    @Override
    public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
        return this.returning(false, expressions);
    }

    @Override
    public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
        return this.returning(true, expressions);
    }

    private StatementBuilder.OngoingReadingAndReturn returning(boolean distinct, Expression ... expressions) {
        DefaultStatementWithReturnBuilder ongoingMatchAndReturn = new DefaultStatementWithReturnBuilder(distinct);
        ongoingMatchAndReturn.addExpressions(expressions);
        return ongoingMatchAndReturn;
    }

    @Override
    public StatementBuilder.OrderableOngoingReadingAndWith with(AliasedExpression ... expressions) {
        return this.with(false, (Expression[])expressions);
    }

    @Override
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
        return this.with(false, expressions);
    }

    @Override
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
        return this.with(true, expressions);
    }

    private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Expression ... expressions) {
        DefaultStatementWithWithBuilder ongoingMatchAndWith = new DefaultStatementWithWithBuilder(distinct);
        ongoingMatchAndWith.addExpressions(expressions);
        return ongoingMatchAndWith;
    }

    public StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
        return this.update(UpdateType.DELETE, expressions);
    }

    public StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
        return this.update(UpdateType.DETACH_DELETE, expressions);
    }

    public StatementBuilder.OngoingMatchAndUpdate set(Expression ... expressions) {
        if (this.currentOngoingUpdate != null) {
            this.currentSinglePartElements.add(this.currentOngoingUpdate.buildUpdatingClause());
            this.currentOngoingUpdate = null;
        }
        return new DefaultStatementWithUpdateBuilder(UpdateType.SET, expressions);
    }

    public StatementBuilder.OngoingMatchAndUpdate set(Node named, String ... label) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(named, label));
    }

    public StatementBuilder.OngoingMatchAndUpdate remove(Property ... properties) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
    }

    public StatementBuilder.OngoingMatchAndUpdate remove(Node named, String ... label) {
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.remove(named, label));
    }

    @Override
    public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
        this.currentOngoingMatch.conditionBuilder.where(newCondition);
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithWhere and(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.and(additionalCondition);
        return this;
    }

    @Override
    public StatementBuilder.OngoingReadingWithWhere or(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.or(additionalCondition);
        return this;
    }

    @Override
    public Statement build() {
        return this.buildImpl(null);
    }

    protected Statement buildImpl(Return returning) {
        SinglePartQuery singlePartQuery = SinglePartQuery.create(this.buildListOfVisitables(), returning);
        if (this.multiPartElements.isEmpty()) {
            return singlePartQuery;
        }
        return new MultiPartQuery(this.multiPartElements, singlePartQuery);
    }

    protected final List<Visitable> buildListOfVisitables() {
        ArrayList<Visitable> visitables = new ArrayList<Visitable>(this.currentSinglePartElements);
        if (this.currentOngoingMatch != null) {
            visitables.add(this.currentOngoingMatch.buildMatch());
        }
        this.currentOngoingMatch = null;
        if (this.currentOngoingUpdate != null) {
            visitables.add(this.currentOngoingUpdate.buildUpdatingClause());
        }
        this.currentOngoingUpdate = null;
        this.currentSinglePartElements.clear();
        return visitables;
    }

    protected final DefaultStatementBuilder addWith(Optional<With> optionalWith) {
        optionalWith.ifPresent(with -> this.multiPartElements.add(new MultiPartElement(this.buildListOfVisitables(), (With)with)));
        return this;
    }

    protected final DefaultStatementBuilder addUpdatingClause(UpdatingClause updatingClause) {
        if (this.currentOngoingMatch != null) {
            this.currentSinglePartElements.add(this.currentOngoingMatch.buildMatch());
            this.currentOngoingMatch = null;
        }
        this.currentSinglePartElements.add(updatingClause);
        return this;
    }

    static final class OrderBuilder {
        protected final List<SortItem> sortItemList = new ArrayList<SortItem>();
        protected SortItem lastSortItem;
        protected Skip skip;
        protected Limit limit;

        OrderBuilder() {
        }

        protected void reset() {
            this.sortItemList.clear();
            this.lastSortItem = null;
            this.skip = null;
            this.limit = null;
        }

        protected void orderBy(SortItem ... sortItem) {
            Arrays.stream(sortItem).forEach(this.sortItemList::add);
        }

        protected void orderBy(Expression expression) {
            this.lastSortItem = Cypher.sort(expression);
        }

        protected void and(Expression expression) {
            this.orderBy(expression);
        }

        protected void descending() {
            this.sortItemList.add(this.lastSortItem.descending());
            this.lastSortItem = null;
        }

        protected void ascending() {
            this.sortItemList.add(this.lastSortItem.ascending());
            this.lastSortItem = null;
        }

        protected void skip(Number number) {
            if (number != null) {
                this.skip = Skip.create(number);
            }
        }

        protected void limit(Number number) {
            if (number != null) {
                this.limit = Limit.create(number);
            }
        }

        protected Optional<Order> buildOrder() {
            if (this.lastSortItem != null) {
                this.sortItemList.add(this.lastSortItem);
            }
            return this.sortItemList.size() > 0 ? Optional.of(new Order(this.sortItemList)) : Optional.empty();
        }

        protected Skip getSkip() {
            return this.skip;
        }

        protected Limit getLimit() {
            return this.limit;
        }
    }

    static final class ConditionBuilder {
        protected Condition condition;

        ConditionBuilder() {
        }

        void where(Condition newCondition) {
            Assert.notNull(newCondition, "The new condition must not be null.");
            this.condition = newCondition;
        }

        void and(Condition additionalCondition) {
            this.condition = this.condition.and(additionalCondition);
        }

        void or(Condition additionalCondition) {
            this.condition = this.condition.or(additionalCondition);
        }

        private boolean hasCondition() {
            return this.condition != null && this.condition != CompoundCondition.EMPTY_CONDITION;
        }

        Optional<Condition> buildCondition() {
            return this.hasCondition() ? Optional.of(this.condition) : Optional.empty();
        }
    }

    final class DefaultOngoingUnwind
    implements StatementBuilder.OngoingUnwind {
        private final Expression expressionToUnwind;

        DefaultOngoingUnwind(Expression expressionToUnwind) {
            this.expressionToUnwind = expressionToUnwind;
        }

        @Override
        public StatementBuilder.OngoingReading as(String variable) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(new Unwind(this.expressionToUnwind, variable));
            return DefaultStatementBuilder.this;
        }
    }

    static final class MatchBuilder {
        private final List<PatternElement> patternList = new ArrayList<PatternElement>();
        private final ConditionBuilder conditionBuilder = new ConditionBuilder();
        private final boolean optional;

        MatchBuilder(boolean optional) {
            this.optional = optional;
        }

        Match buildMatch() {
            Pattern pattern = new Pattern(this.patternList);
            return new Match(this.optional, pattern, this.conditionBuilder.buildCondition().map(Where::new).orElse(null));
        }
    }

    protected final class DefaultStatementWithUpdateBuilder
    extends DefaultStatementWithReturnBuilder
    implements StatementBuilder.OngoingMatchAndUpdate,
    StatementBuilder.OngoingReadingAndReturn {
        private final List<? extends Visitable> expressions;
        private final UpdateType updateType;

        protected DefaultStatementWithUpdateBuilder(UpdateType updateType, PatternElement ... pattern) {
            super(false);
            this.updateType = updateType;
            Assert.notNull(pattern, "Patterns to create are required.");
            Assert.notEmpty(pattern, "At least one pattern to create is required.");
            this.expressions = Arrays.asList(pattern);
        }

        protected DefaultStatementWithUpdateBuilder(UpdateType updateType, Expression ... expressions) {
            super(false);
            this.updateType = updateType;
            Assert.notNull(expressions, "Modifying expressions are required.");
            Assert.notEmpty(expressions, "At least one expressions is required.");
            switch (this.updateType) {
                case DETACH_DELETE: 
                case DELETE: {
                    this.expressions = Arrays.asList(expressions);
                    break;
                }
                case SET: {
                    this.expressions = this.prepareSetExpressions(expressions);
                    break;
                }
                case REMOVE: {
                    this.expressions = Arrays.asList(expressions);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported update type " + (Object)((Object)updateType));
                }
            }
        }

        List<? extends Visitable> prepareSetExpressions(Expression ... possibleSetOperations) {
            ArrayList<Expression> propertyOperations = new ArrayList<Expression>();
            ArrayList<Expression> listOfExpressions = new ArrayList<Expression>();
            for (Expression possibleSetOperation : possibleSetOperations) {
                if (possibleSetOperation instanceof Operation) {
                    propertyOperations.add(possibleSetOperation);
                    continue;
                }
                listOfExpressions.add(possibleSetOperation);
            }
            if (listOfExpressions.size() % 2 != 0) {
                throw new IllegalArgumentException("The list of expression to set must be even.");
            }
            for (int i = 0; i < listOfExpressions.size(); i += 2) {
                propertyOperations.add(Operations.set((Expression)listOfExpressions.get(i), (Expression)listOfExpressions.get(i + 1)));
            }
            return propertyOperations;
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... returnedExpressions) {
            Assert.notNull(returnedExpressions, "Expressions to return are required.");
            Assert.notEmpty(returnedExpressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(returnedExpressions));
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... returnedExpressions) {
            this.returning(returnedExpressions);
            this.distinct = true;
            return this;
        }

        public StatementBuilder.OngoingUpdate delete(Expression ... deletedExpressions) {
            return this.delete(false, deletedExpressions);
        }

        public StatementBuilder.OngoingUpdate detachDelete(Expression ... deletedExpressions) {
            return this.delete(true, deletedExpressions);
        }

        @Override
        public <T extends StatementBuilder.OngoingUpdate & StatementBuilder.ExposesSet> T merge(PatternElement ... pattern) {
            throw new UnsupportedOperationException("Not supported yet");
        }

        private StatementBuilder.OngoingUpdate delete(boolean nextDetach, Expression ... deletedExpressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.buildUpdatingClause());
            return DefaultStatementBuilder.this.update(nextDetach ? UpdateType.DETACH_DELETE : UpdateType.DELETE, deletedExpressions);
        }

        public StatementBuilder.OngoingMatchAndUpdate set(Expression ... keyValuePairs) {
            DefaultStatementBuilder.this.addUpdatingClause(this.buildUpdatingClause());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, keyValuePairs);
        }

        public StatementBuilder.OngoingMatchAndUpdate set(Node node, String ... label) {
            DefaultStatementBuilder.this.addUpdatingClause(this.buildUpdatingClause());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(node, label));
        }

        public StatementBuilder.OngoingMatchAndUpdate remove(Node node, String ... label) {
            DefaultStatementBuilder.this.addUpdatingClause(this.buildUpdatingClause());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.set(node, label));
        }

        public StatementBuilder.OngoingMatchAndUpdate remove(Property ... properties) {
            DefaultStatementBuilder.this.addUpdatingClause(this.buildUpdatingClause());
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            return defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... returnedExpressions) {
            return this.with(false, returnedExpressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... returnedExpressions) {
            return this.with(true, returnedExpressions);
        }

        private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Expression ... returnedExpressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.buildUpdatingClause());
            return DefaultStatementBuilder.this.with(distinct, returnedExpressions);
        }

        @Override
        public Statement build() {
            DefaultStatementBuilder.this.addUpdatingClause(this.buildUpdatingClause());
            return super.build();
        }

        private UpdatingClause buildUpdatingClause() {
            if (MERGE_OR_CREATE.contains((Object)this.updateType)) {
                Pattern pattern = new Pattern((List<PatternElement>)this.expressions);
                switch (this.updateType) {
                    case CREATE: {
                        return new Create(pattern);
                    }
                    case MERGE: {
                        return new Merge(pattern);
                    }
                }
            } else {
                ExpressionList expressionsList = new ExpressionList((List<Expression>)this.expressions);
                switch (this.updateType) {
                    case DETACH_DELETE: {
                        return new Delete(expressionsList, true);
                    }
                    case DELETE: {
                        return new Delete(expressionsList, false);
                    }
                    case SET: {
                        return new Set(expressionsList);
                    }
                    case REMOVE: {
                        return new Remove(expressionsList);
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported update type " + (Object)((Object)this.updateType));
        }
    }

    static enum UpdateType {
        DELETE,
        DETACH_DELETE,
        SET,
        REMOVE,
        CREATE,
        MERGE;

    }

    protected final class DefaultStatementWithWithBuilder
    extends WithBuilderSupport
    implements StatementBuilder.OngoingReadingAndWith,
    StatementBuilder.OngoingOrderDefinition,
    StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere,
    StatementBuilder.OrderableOngoingReadingAndWithWithWhere,
    StatementBuilder.OngoingReadingAndWithWithWhereAndOrder {
        protected final ConditionBuilder conditionBuilder;
        protected final List<Expression> returnList;
        protected final OrderBuilder orderBuilder;
        protected boolean distinct;

        protected DefaultStatementWithWithBuilder(boolean distinct) {
            this.conditionBuilder = new ConditionBuilder();
            this.returnList = new ArrayList<Expression>();
            this.orderBuilder = new OrderBuilder();
            this.distinct = distinct;
        }

        protected Optional<With> buildWith() {
            if (this.returnList.isEmpty()) {
                return Optional.empty();
            }
            ExpressionList returnItems = new ExpressionList(this.returnList);
            Where where = this.conditionBuilder.buildCondition().map(Where::new).orElse(null);
            Optional<With> returnedWith = Optional.of(new With(this.distinct, returnItems, this.orderBuilder.buildOrder().orElse(null), this.orderBuilder.getSkip(), this.orderBuilder.getLimit(), where));
            this.returnList.clear();
            this.orderBuilder.reset();
            return returnedWith;
        }

        protected void addExpressions(Expression ... expressions) {
            Assert.notNull(expressions, "Expressions to return are required.");
            Assert.notEmpty(expressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(expressions));
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returning(expressions);
        }

        @Override
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returningDistinct(expressions);
        }

        public StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).delete(expressions);
        }

        public StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).detachDelete(expressions);
        }

        public StatementBuilder.OngoingMatchAndUpdate set(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(expressions);
        }

        public StatementBuilder.OngoingMatchAndUpdate set(Node node, String ... label) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(node, label);
        }

        public StatementBuilder.OngoingMatchAndUpdate remove(Node node, String ... label) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(node, label);
        }

        public StatementBuilder.OngoingMatchAndUpdate remove(Property ... properties) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(properties);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).with(expressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).withDistinct(expressions);
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            return this;
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere and(Condition additionalCondition) {
            this.conditionBuilder.and(additionalCondition);
            return this;
        }

        @Override
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere or(Condition additionalCondition) {
            this.conditionBuilder.or(additionalCondition);
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingWithoutWhere match(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).match(pattern);
        }

        @Override
        public StatementBuilder.OngoingReadingWithoutWhere optionalMatch(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).optionalMatch(pattern);
        }

        public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).create(pattern);
        }

        public StatementBuilder.OngoingUpdate merge(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).merge(pattern);
        }

        @Override
        public StatementBuilder.OngoingUnwind unwind(Expression expression) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).unwind(expression);
        }

        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        public StatementBuilder.OngoingOrderDefinition orderBy(Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        public StatementBuilder.OngoingOrderDefinition and(Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere descending() {
            this.orderBuilder.descending();
            return this;
        }

        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere skip(Number number) {
            this.orderBuilder.skip(number);
            return this;
        }

        @Override
        public StatementBuilder.OngoingReadingAndWith limit(Number number) {
            this.orderBuilder.limit(number);
            return this;
        }
    }

    protected abstract class WithBuilderSupport {
        protected WithBuilderSupport() {
        }
    }

    protected class DefaultStatementWithReturnBuilder
    implements StatementBuilder.OngoingReadingAndReturn,
    StatementBuilder.TerminalOngoingOrderDefinition,
    StatementBuilder.OngoingMatchAndReturnWithOrder {
        protected final List<Expression> returnList = new ArrayList<Expression>();
        protected final OrderBuilder orderBuilder = new OrderBuilder();
        protected boolean distinct;

        protected DefaultStatementWithReturnBuilder(boolean distinct) {
            this.distinct = distinct;
        }

        @Override
        public final StatementBuilder.OngoingMatchAndReturnWithOrder orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        public final StatementBuilder.TerminalOngoingOrderDefinition orderBy(Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        public final StatementBuilder.TerminalOngoingOrderDefinition and(Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        public final StatementBuilder.OngoingReadingAndReturn descending() {
            this.orderBuilder.descending();
            return this;
        }

        public final StatementBuilder.OngoingReadingAndReturn ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        public final StatementBuilder.OngoingReadingAndReturn skip(Number number) {
            this.orderBuilder.skip(number);
            return this;
        }

        @Override
        public final StatementBuilder.OngoingReadingAndReturn limit(Number number) {
            this.orderBuilder.limit(number);
            return this;
        }

        @Override
        public Statement build() {
            Return returning = null;
            if (!this.returnList.isEmpty()) {
                ExpressionList returnItems = new ExpressionList(this.returnList);
                returning = new Return(this.distinct, returnItems, this.orderBuilder.buildOrder().orElse(null), this.orderBuilder.getSkip(), this.orderBuilder.getLimit());
            }
            return DefaultStatementBuilder.this.buildImpl(returning);
        }

        protected final void addExpressions(Expression ... expressions) {
            Assert.notNull(expressions, "Expressions to return are required.");
            Assert.notEmpty(expressions, "At least one expressions to return is required.");
            this.returnList.addAll(Arrays.asList(expressions));
        }
    }
}

