/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.LFUCache$;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u000b\u0017\u0001\u0005B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011)\u0019!C\u0001_!A1\u0007\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001dI\u0005A1A\u0005\u0002)Ca\u0001\u0017\u0001!\u0002\u0013Y\u0005bB-\u0001\u0005\u0004%IA\u0017\u0005\u0007=\u0002\u0001\u000b\u0011B.\t\u000b}\u0003A\u0011\u00011\t\u000b!\u0004A\u0011A5\t\u000b9\u0004A\u0011A8\t\u000bY\u0004A\u0011A<\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!1\u0011Q\u0003\u0001\u0005\u0002]<\u0011\"a\u0006\u0017\u0003\u0003E\t!!\u0007\u0007\u0011U1\u0012\u0011!E\u0001\u00037Aa\u0001\u0011\n\u0005\u0002\u0005u\u0001\"CA\u0010%E\u0005I\u0011AA\u0011\u0005!ae)V\"bG\",'BA\f\u0019\u0003\u0015\u0019\u0017m\u00195f\u0015\tI\"$\u0001\u0005j]R,'O\\1m\u0015\tYB$\u0001\u0004dsBDWM\u001d\u0006\u0003;y\tQA\\3pi)T\u0011aH\u0001\u0004_J<7\u0001A\u000b\u0004Ei\"5C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u0006a1-Y2iK\u001a\u000b7\r^8ssB\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0015\u0007\u00064g-Z5oK\u000e\u000b7\r[3GC\u000e$xN]=\u0002\tML'0Z\u000b\u0002aA\u0011A%M\u0005\u0003e\u0015\u00121!\u00138u\u0003\u0015\u0019\u0018N_3!\u0003\u0019!(/Y2feB\u00191F\u000e\u001d\n\u0005]2\"aC\"bG\",GK]1dKJ\u0004\"!\u000f\u001e\r\u0001\u0011)1\b\u0001b\u0001y\t\t1*\u0005\u0002>GA\u0011AEP\u0005\u0003\u007f\u0015\u0012qAT8uQ&tw-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0005\u001a;\u0005\n\u0005\u0003,\u0001a\u001a\u0005CA\u001dE\t\u0015)\u0005A1\u0001=\u0005\u00051\u0006\"B\u0015\u0006\u0001\u0004Q\u0003\"\u0002\u0018\u0006\u0001\u0004\u0001\u0004b\u0002\u001b\u0006!\u0003\u0005\r!N\u0001\u0010e\u0016lwN^1m\u0019&\u001cH/\u001a8feV\t1\n\u0005\u0003M-b\u001aU\"A'\u000b\u0005]q%BA(Q\u0003!\u0019\u0017M\u001a4fS:,'BA)S\u0003!\u0011WM\\7b]\u0016\u001c(BA*U\u0003\u00199\u0017\u000e\u001e5vE*\tQ+A\u0002d_6L!aV'\u0003\u001fI+Wn\u001c<bY2K7\u000f^3oKJ\f\u0001C]3n_Z\fG\u000eT5ti\u0016tWM\u001d\u0011\u0002\u000b%tg.\u001a:\u0016\u0003m\u0003B\u0001\u0014/9\u0007&\u0011Q,\u0014\u0002\u0006\u0007\u0006\u001c\u0007.Z\u0001\u0007S:tWM\u001d\u0011\u0002\u001f\r|W\u000e];uK&3\u0017IY:f]R$2aQ1d\u0011\u0015\u0011'\u00021\u00019\u0003\rYW-\u001f\u0005\u0007I*!\t\u0019A3\u0002\u0003\u0019\u00042\u0001\n4D\u0013\t9WE\u0001\u0005=Eft\u0017-\\3?\u0003\r9W\r\u001e\u000b\u0003U6\u00042\u0001J6D\u0013\taWE\u0001\u0004PaRLwN\u001c\u0005\u0006E.\u0001\r\u0001O\u0001\u0004aV$Hc\u00019tiB\u0011A%]\u0005\u0003e\u0016\u0012A!\u00168ji\")!\r\u0004a\u0001q!)Q\u000f\u0004a\u0001\u0007\u0006)a/\u00197vK\u0006iQm\u001d;j[\u0006$X\rZ*ju\u0016$\u0012\u0001\u001f\t\u0003IeL!A_\u0013\u0003\t1{gnZ\u0001\u0006CNl\u0015\r\u001d\u000b\u0002{B)a0a\u00039\u00076\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AC2p]\u000e,(O]3oi*!\u0011QAA\u0004\u0003\u0011)H/\u001b7\u000b\u0005\u0005%\u0011\u0001\u00026bm\u0006L1!!\u0004\u0000\u00055\u0019uN\\2veJ,g\u000e^'ba\u0006Q\u0011N\u001c<bY&$\u0017\r^3\u0015\u0007A\f\u0019\u0002C\u0003c\u001f\u0001\u0007\u0001(A\u0003dY\u0016\f'/\u0001\u0005M\rV\u001b\u0015m\u00195f!\tY#c\u0005\u0002\u0013GQ\u0011\u0011\u0011D\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\r\u0005\r\u0012\u0011GA#+\t\t)C\u000b\u0003\u0002(\u0005M\"#BA\u0015G\u00055bABA\u0016)\u0001\t9C\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003,m\u0005=\u0002cA\u001d\u00022\u0011)1\b\u0006b\u0001y-\u0012\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003%)hn\u00195fG.,GMC\u0002\u0002@\u0015\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019%!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003F)\t\u0007A\b")
public class LFUCache<K, V> {
    private final int size;
    private final CacheTracer<K> tracer;
    private final RemovalListener<K, V> removalListener;
    private final Cache<K, V> inner;

    public static <K, V> CacheTracer<K> $lessinit$greater$default$3() {
        return LFUCache$.MODULE$.$lessinit$greater$default$3();
    }

    public int size() {
        return this.size;
    }

    public RemovalListener<K, V> removalListener() {
        return this.removalListener;
    }

    private Cache<K, V> inner() {
        return this.inner;
    }

    public V computeIfAbsent(K key, Function0<V> f) {
        BooleanRef hit = BooleanRef.create((boolean)true);
        Object result = this.inner().get(key, x$1 -> {
            hit$1.elem = false;
            return f.apply();
        });
        if (hit.elem) {
            this.tracer.cacheHit(key, "");
        } else {
            this.tracer.cacheMiss(key, "");
        }
        return (V)result;
    }

    public Option<V> get(K key) {
        Option res = Option$.MODULE$.apply(this.inner().getIfPresent(key));
        if (res.isEmpty()) {
            this.tracer.cacheMiss(key, "");
        } else {
            this.tracer.cacheHit(key, "");
        }
        return res;
    }

    public void put(K key, V value) {
        this.inner().put(key, value);
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.inner().asMap();
    }

    public void invalidate(K key) {
        this.inner().invalidate(key);
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer.cacheFlush(priorSize);
        return priorSize;
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, int size, CacheTracer<K> tracer) {
        this.size = size;
        this.tracer = tracer;
        this.removalListener = (key, value, cause) -> $this.tracer.discard(key, "");
        this.inner = cacheFactory.createCache(size, this.removalListener());
    }
}

