/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

class ConsistencyCheckMemoryCalculation {
    ConsistencyCheckMemoryCalculation() {
    }

    static MemoryDistribution calculate(long maxOffHeapMemory, long desiredPageCacheMemory, long desiredOffHeapCachingMemory) {
        long pageCacheMemory = desiredPageCacheMemory;
        long offHeapCachingMemory = desiredOffHeapCachingMemory;
        if (desiredPageCacheMemory + desiredOffHeapCachingMemory > maxOffHeapMemory) {
            pageCacheMemory = Long.max(maxOffHeapMemory - offHeapCachingMemory, (long)((double)maxOffHeapMemory * 0.75));
        }
        offHeapCachingMemory = maxOffHeapMemory - pageCacheMemory;
        assert (pageCacheMemory + offHeapCachingMemory <= maxOffHeapMemory) : "Too much memory being used pageCacheMemory:" + pageCacheMemory + " offHeapCachingMemory:" + offHeapCachingMemory;
        return new MemoryDistribution(pageCacheMemory, offHeapCachingMemory);
    }

    record MemoryDistribution(long pageCacheMemory, long offHeapCachingMemory) {
    }
}

