/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

class ConsistencyCheckMemoryCalculation {
    ConsistencyCheckMemoryCalculation() {
    }

    static MemoryDistribution calculate(long maxOffHeapMemory, long desiredPageCacheMemory, long desiredOffHeapCachingMemory) {
        long pageCacheMemory = desiredPageCacheMemory;
        if (desiredPageCacheMemory + desiredOffHeapCachingMemory > maxOffHeapMemory) {
            long maxPageCacheSizeForOptimalCachingSize = Math.max(maxOffHeapMemory - desiredOffHeapCachingMemory, 0L);
            pageCacheMemory = Long.min(Long.max(maxPageCacheSizeForOptimalCachingSize, (long)((double)maxOffHeapMemory * 0.75)), desiredPageCacheMemory);
        }
        long offHeapCachingMemory = Math.min(maxOffHeapMemory - pageCacheMemory, desiredOffHeapCachingMemory);
        assert (pageCacheMemory + offHeapCachingMemory <= maxOffHeapMemory) : "Too much memory being used pageCacheMemory:" + pageCacheMemory + " offHeapCachingMemory:" + offHeapCachingMemory;
        return new MemoryDistribution(pageCacheMemory, offHeapCachingMemory);
    }

    record MemoryDistribution(long pageCacheMemory, long offHeapCachingMemory) {
    }
}

