/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckMemoryCalculation;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.logging.LoggingReporterFactoryInvocationHandler;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.SchemaIndexExtensionLoader;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLog;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.LogUtils;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.time.Clocks;
import org.neo4j.token.TokenHolders;

public class ConsistencyCheckService {
    private static final long DEFAULT_SMALL_MAX_OFF_HEAP_MEMORY = ByteUnit.mebiBytes((long)80L);
    private static final long MIN_OFF_HEAP_CACHING_MEMORY = ByteUnit.mebiBytes((long)8L);
    private final Date timestamp;
    private final DatabaseLayout layout;
    private final Config config;
    private final OutputStream progressOutput;
    private final InternalLogProvider logProvider;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final boolean verbose;
    private final Path reportPath;
    private final ConsistencyFlags consistencyFlags;
    private final PageCacheTracer pageCacheTracer;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final long maxOffHeapMemory;
    private final int numberOfThreads;

    public ConsistencyCheckService(DatabaseLayout layout) {
        this(new Date(), layout, Config.defaults(), null, (InternalLogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), null, false, null, ConsistencyFlags.ALL, PageCacheTracer.NULL, new CursorContextFactory(PageCacheTracer.NULL, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER), (MemoryTracker)EmptyMemoryTracker.INSTANCE, DEFAULT_SMALL_MAX_OFF_HEAP_MEMORY, Runtime.getRuntime().availableProcessors());
    }

    private ConsistencyCheckService(Date timestamp, DatabaseLayout layout, Config config, OutputStream progressOutput, InternalLogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, Path reportPath, ConsistencyFlags consistencyFlags, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory, MemoryTracker memoryTracker, long maxOffHeapMemory, int numberOfThreads) {
        this.timestamp = timestamp;
        this.layout = layout;
        this.config = config;
        this.progressOutput = progressOutput;
        this.logProvider = logProvider;
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.verbose = verbose;
        this.reportPath = reportPath;
        this.consistencyFlags = consistencyFlags;
        this.pageCacheTracer = pageCacheTracer;
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
        this.maxOffHeapMemory = maxOffHeapMemory;
        this.numberOfThreads = numberOfThreads;
    }

    public ConsistencyCheckService with(CursorContextFactory contextFactory) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(Date timestamp) {
        return new ConsistencyCheckService(timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(DatabaseLayout layout) {
        return new ConsistencyCheckService(this.timestamp, layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(Config config) {
        return new ConsistencyCheckService(this.timestamp, this.layout, config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(OutputStream progressOutput) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(InternalLogProvider logProvider) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(FileSystemAbstraction fileSystem) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(PageCache pageCache) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService verbose(boolean verbose) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(Path reportPath) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(ConsistencyFlags consistencyFlags) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(PageCacheTracer pageCacheTracer) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService with(MemoryTracker memoryTracker) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, memoryTracker, this.maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService withMaxOffHeapMemory(long maxOffHeapMemory) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, maxOffHeapMemory, this.numberOfThreads);
    }

    public ConsistencyCheckService withNumberOfThreads(int numberOfThreads) {
        return new ConsistencyCheckService(this.timestamp, this.layout, this.config, this.progressOutput, this.logProvider, this.fileSystem, this.pageCache, this.verbose, this.reportPath, this.consistencyFlags, this.pageCacheTracer, this.contextFactory, this.memoryTracker, this.maxOffHeapMemory, numberOfThreads);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result runFullConsistencyCheck() throws ConsistencyCheckIncompleteException {
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            Result result;
            long offHeapCachingMemory;
            Config config = this.config;
            PageCache pageCache = this.pageCache;
            StorageEngineFactory storageEngineFactory = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.layout).orElseThrow();
            long storeSize = this.storeSize(storageEngineFactory);
            if (pageCache == null) {
                ConsistencyCheckMemoryCalculation.MemoryDistribution distribution = ConsistencyCheckMemoryCalculation.calculate(this.maxOffHeapMemory, storeSize, this.calculateOptimalOffHeapMemoryForChecker());
                long pageCacheMemory = distribution.pageCacheMemory();
                offHeapCachingMemory = distribution.offHeapCachingMemory();
                config = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.pagecache_memory, (Object)pageCacheMemory).build();
                pageCache = this.createPageCache(life, config);
                this.printMemoryConfiguration(false, storeSize, pageCacheMemory, offHeapCachingMemory);
            } else {
                long pageCacheMemory = pageCache.maxCachedPages() * (long)pageCache.pageSize();
                offHeapCachingMemory = Long.max(this.maxOffHeapMemory - pageCacheMemory, MIN_OFF_HEAP_CACHING_MEMORY);
                this.printMemoryConfiguration(true, storeSize, pageCacheMemory, offHeapCachingMemory);
            }
            config.set(GraphDatabaseSettings.pagecache_warmup_enabled, (Object)false);
            DatabaseLayout databaseLayout = storageEngineFactory.formatSpecificDatabaseLayout(this.layout);
            ConsistencyCheckService.assertRecovered(databaseLayout, pageCache, config, this.fileSystem, this.memoryTracker);
            ConsistencyCheckService.assertSupportedFormat(databaseLayout, config, this.fileSystem, pageCache, storageEngineFactory, this.logProvider, this.contextFactory);
            InternalLog outLog = this.logProvider.getLog(this.getClass());
            Path reportFile = this.chooseReportFile(config);
            Log4jLogProvider reportLogProvider = new Log4jLogProvider(LogConfig.createLoggerFromXmlConfig((FileSystemAbstraction)this.fileSystem, (Path)LogUtils.newTemporaryXmlConfigBuilder((FileSystemAbstraction)this.fileSystem).withLogger(LogUtils.newLoggerBuilder((LoggerTarget)LoggerTarget.ROOT_LOGGER, (Path)reportFile).withLevel(Level.INFO).createOnDemand().withCategory(false).build()).create(), (boolean)false, arg_0 -> ((Config)config).configStringLookup(arg_0)));
            life.add(LifecycleAdapter.onShutdown(() -> ((Log4jLogProvider)reportLogProvider).close()));
            Log4jLog reportFileLog = reportLogProvider.getLog(this.getClass());
            DuplicatingLog reportLog = new DuplicatingLog(outLog, (InternalLog)reportFileLog);
            JobScheduler jobScheduler = (JobScheduler)life.add((Lifecycle)JobSchedulerFactory.createInitialisedScheduler());
            RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.ignore();
            Monitors monitors = new Monitors();
            TokenHolders tokenHolders = storageEngineFactory.loadReadOnlyTokens(this.fileSystem, databaseLayout, config, pageCache, this.pageCacheTracer, true, this.contextFactory);
            DatabaseExtensions extensions = (DatabaseExtensions)life.add((Lifecycle)SchemaIndexExtensionLoader.instantiateExtensions((DatabaseLayout)databaseLayout, (FileSystemAbstraction)this.fileSystem, (Config)config, (LogService)new SimpleLogService(this.logProvider), (PageCache)pageCache, (JobScheduler)jobScheduler, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector, (DbmsInfo)DbmsInfo.TOOL, (Monitors)monitors, (TokenHolders)tokenHolders, (PageCacheTracer)this.pageCacheTracer, (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.readOnly()));
            Dependencies dependencies = new Dependencies((DependencyResolver)extensions);
            dependencies.satisfyDependency((Object)VersionStorage.EMPTY_STORAGE);
            StaticIndexProviderMap indexProviders = (StaticIndexProviderMap)life.add((Lifecycle)StaticIndexProviderMapFactory.create((LifeSupport)life, (Config)config, (PageCache)pageCache, (FileSystemAbstraction)this.fileSystem, (LogService)new SimpleLogService(this.logProvider), (Monitors)monitors, (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.readOnly(), (TopologyGraphDbmsModel.HostedOnMode)TopologyGraphDbmsModel.HostedOnMode.SINGLE, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector, (DatabaseLayout)databaseLayout, (TokenHolders)tokenHolders, (JobScheduler)jobScheduler, (CursorContextFactory)this.contextFactory, (PageCacheTracer)this.pageCacheTracer, (DependencyResolver)dependencies));
            life.start();
            ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
            if (this.consistencyFlags.checkIndexes() && this.consistencyFlags.checkStructure() && this.fileSystem.fileExists(databaseLayout.pathForStore(CommonDatabaseStores.INDEX_STATISTICS))) {
                ImmutableSet openOptions = storageEngineFactory.getStoreOpenOptions(this.fileSystem, pageCache, databaseLayout, this.contextFactory);
                IndexStatisticsStore statisticsStore = new IndexStatisticsStore(pageCache, this.fileSystem, databaseLayout, recoveryCleanupWorkCollector, true, this.contextFactory, this.pageCacheTracer, openOptions);
                life.add((Lifecycle)statisticsStore);
                this.consistencyCheckOnStatisticsStore((InternalLog)reportLog, summary, (ConsistencyCheckable)statisticsStore);
            }
            LogTailExtractor logTailExtractor = new LogTailExtractor(this.fileSystem, pageCache, config, storageEngineFactory, DatabaseTracers.EMPTY);
            storageEngineFactory.consistencyCheck(this.fileSystem, databaseLayout, config, pageCache, (IndexProviderMap)indexProviders, (InternalLog)reportLog, outLog, summary, this.numberOfThreads, offHeapCachingMemory, this.progressOutput, this.verbose, this.consistencyFlags, this.contextFactory, this.pageCacheTracer, logTailExtractor.getTailMetadata(databaseLayout, this.memoryTracker));
            if (!summary.isConsistent()) {
                reportLog.warn("Inconsistencies found: " + summary);
                outLog.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile});
                result = Result.failure(reportFile, summary);
                return result;
            }
            result = Result.success(reportFile, summary);
            return result;
        }
        catch (IOException | RuntimeException e) {
            throw new ConsistencyCheckIncompleteException((Throwable)e);
        }
    }

    private void printMemoryConfiguration(boolean providedPageCache, long storeSize, long pageCacheMemory, long offHeapCachingMemory) {
        if (this.progressOutput != null) {
            new PrintStream(this.progressOutput, true).printf("Running consistency check with max off-heap:%s%n  Store size:%s%n  %s page cache:%s%n  Off-heap memory for caching:%s%n", ByteUnit.bytesToString((long)this.maxOffHeapMemory), ByteUnit.bytesToString((long)storeSize), providedPageCache ? "Provided" : "Allocated", ByteUnit.bytesToString((long)pageCacheMemory), ByteUnit.bytesToString((long)offHeapCachingMemory));
        }
    }

    private long storeSize(StorageEngineFactory storageEngineFactory) throws ConsistencyCheckIncompleteException {
        try {
            long size = 0L;
            for (Path storageFile : storageEngineFactory.listStorageFiles(this.fileSystem, this.layout)) {
                try {
                    size += this.fileSystem.getFileSize(storageFile);
                }
                catch (IOException iOException) {}
            }
            return size;
        }
        catch (IOException e) {
            throw new ConsistencyCheckIncompleteException((Throwable)e);
        }
    }

    private PageCache createPageCache(Lifespan life, Config config) {
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        life.add(LifecycleAdapter.onShutdown(() -> ((JobScheduler)jobScheduler).close()));
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(this.fileSystem, config, this.pageCacheTracer, this.logProvider.getLog(PageCache.class), jobScheduler, Clocks.nanoClock(), new MemoryPools(((Boolean)config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()), pageCacheConfig -> pageCacheConfig.faultLockStriping(2048));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        life.add(LifecycleAdapter.onShutdown(() -> ((PageCache)pageCache).close()));
        return pageCache;
    }

    private long calculateOptimalOffHeapMemoryForChecker() {
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();){
            long l;
            block12: {
                PageCache tempPageCache = new ConfiguringPageCacheFactory(this.fileSystem, Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L)), PageCacheTracer.NULL, (InternalLog)NullLog.getInstance(), jobScheduler, Clocks.nanoClock(), new MemoryPools()).getOrCreatePageCache();
                try {
                    StorageEngineFactory storageEngineFactory = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.layout).orElseThrow();
                    l = Long.max(MIN_OFF_HEAP_CACHING_MEMORY, storageEngineFactory.optimalAvailableConsistencyCheckerMemory(this.fileSystem, this.layout, this.config, tempPageCache));
                    if (tempPageCache == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tempPageCache != null) {
                        try {
                            tempPageCache.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tempPageCache.close();
            }
            return l;
        }
    }

    private static void assertSupportedFormat(DatabaseLayout databaseLayout, Config config, FileSystemAbstraction fileSystem, PageCache pageCache, StorageEngineFactory storageEngineFactory, InternalLogProvider logProvider, CursorContextFactory contextFactory) {
        StoreVersionCheck storeVersionCheck = storageEngineFactory.versionCheck(fileSystem, databaseLayout, config, pageCache, (LogService)new SimpleLogService(logProvider), contextFactory);
        try (CursorContext cursorContext = contextFactory.create("consistencyCheck");){
            if (!storeVersionCheck.isCurrentStoreVersionFullySupported(cursorContext)) {
                throw new IllegalStateException("The store must be upgraded or migrated to a supported version before it is possible to check consistency");
            }
        }
    }

    private void consistencyCheckOnStatisticsStore(InternalLog log, ConsistencySummaryStatistics summary, ConsistencyCheckable checkable) {
        LoggingReporterFactoryInvocationHandler handler = new LoggingReporterFactoryInvocationHandler(log, true);
        ReporterFactory proxyFactory = new ReporterFactory((InvocationHandler)handler);
        checkable.consistencyCheck(proxyFactory, CursorContextFactory.NULL_CONTEXT_FACTORY, this.numberOfThreads);
        summary.update("INDEX_STATISTICS", handler.errors(), handler.warnings());
    }

    private static void assertRecovered(DatabaseLayout databaseLayout, PageCache pageCache, Config config, FileSystemAbstraction fileSystem, MemoryTracker memoryTracker) throws IOException {
        if (Recovery.isRecoveryRequired((FileSystemAbstraction)fileSystem, (PageCache)pageCache, (DatabaseLayout)databaseLayout, (Config)config, Optional.empty(), (MemoryTracker)memoryTracker, (DatabaseTracers)DatabaseTracers.EMPTY)) {
            throw new IllegalStateException("Active logical log detected, this might be a source of inconsistencies.\nPlease recover database.\nTo perform recovery please start database in single mode and perform clean shutdown.");
        }
    }

    private Path chooseReportFile(Config config) {
        Path path = Objects.requireNonNullElse(this.reportPath, ConsistencyCheckService.defaultReportDir(config)).toAbsolutePath().normalize();
        return FilenameUtils.isExtension((String)path.toString(), (String)"report") ? path : path.resolve(ConsistencyCheckService.defaultLogFileName(this.timestamp));
    }

    private static Path defaultReportDir(Config config) {
        return (Path)config.get(GraphDatabaseSettings.logs_directory);
    }

    private static String defaultLogFileName(Date date) {
        return "inconsistencies-%s.report".formatted(new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date));
    }

    public static class Result {
        private final boolean successful;
        private final Path reportFile;
        private final ConsistencySummaryStatistics summary;

        public static Result failure(Path reportFile, ConsistencySummaryStatistics summary) {
            return new Result(false, reportFile, summary);
        }

        public static Result success(Path reportFile, ConsistencySummaryStatistics summary) {
            return new Result(true, reportFile, summary);
        }

        private Result(boolean successful, Path reportFile, ConsistencySummaryStatistics summary) {
            this.successful = successful;
            this.reportFile = reportFile;
            this.summary = summary;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public Path reportFile() {
            return this.reportFile;
        }

        public ConsistencySummaryStatistics summary() {
            return this.summary;
        }
    }
}

