/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.Iterator;
import java.util.List;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.newchecker.Checker;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.CountsState;
import org.neo4j.consistency.newchecker.EntityTokenIndexCheckState;
import org.neo4j.consistency.newchecker.ParallelExecution;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.newchecker.RecordReader;
import org.neo4j.consistency.newchecker.SafePropertyChainReader;
import org.neo4j.consistency.newchecker.SchemaComplianceChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.consistency.store.synthetic.TokenScanDocument;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.EntityTokenRange;
import org.neo4j.internal.recordstorage.RecordNodeCursor;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.RelationshipCounter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;

class NodeChecker
implements Checker {
    private static final String NODE_INDEXES_CHECKER_TAG = "nodeIndexesChecker";
    private static final String NODE_RANGE_CHECKER_TAG = "nodeRangeChecker";
    private final MutableIntObjectMap<MutableIntSet> mandatoryProperties;
    private final ProgressListener nodeProgress;
    private final CheckerContext context;
    private final ConsistencyReport.Reporter reporter;
    private final CountsState observedCounts;
    private final RecordLoading recordLoader;
    private final TokenHolders tokenHolders;
    private final NeoStores neoStores;
    private final List<IndexDescriptor> smallIndexes;

    NodeChecker(CheckerContext context, MutableIntObjectMap<MutableIntSet> mandatoryProperties) {
        this.context = context;
        this.reporter = context.reporter;
        this.observedCounts = context.observedCounts;
        this.recordLoader = context.recordLoader;
        this.tokenHolders = context.tokenHolders;
        this.neoStores = context.neoStores;
        this.mandatoryProperties = mandatoryProperties;
        this.nodeProgress = context.roundInsensitiveProgressReporter(this, "Nodes", this.neoStores.getNodeStore().getHighId());
        this.smallIndexes = context.indexSizes.smallIndexes(EntityType.NODE);
    }

    @Override
    public void check(LongRange nodeIdRange, boolean firstRange, boolean lastRange) throws Exception {
        ParallelExecution execution = this.context.execution;
        execution.run(this.getClass().getSimpleName() + "-checkNodes", execution.partition(nodeIdRange, (from, to, last) -> () -> this.check(from, to, lastRange && last)));
        if (this.context.consistencyFlags.isCheckIndexes()) {
            execution.run(this.getClass().getSimpleName() + "-checkIndexesVsNodes", (ParallelExecution.ThrowingRunnable[])this.smallIndexes.stream().map(indexDescriptor -> () -> this.checkIndexVsNodes(nodeIdRange, (IndexDescriptor)indexDescriptor, lastRange)).toArray(ParallelExecution.ThrowingRunnable[]::new));
        }
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.isCheckGraph() || flags.isCheckIndexes() && !this.smallIndexes.isEmpty();
    }

    private void check(long fromNodeId, long toNodeId, boolean last) throws Exception {
        long usedNodes = 0L;
        try (RecordStorageReader reader = new RecordStorageReader(this.context.neoStores);
             PageCursorTracer cursorTracer = this.context.pageCacheTracer.createPageCursorTracer(NODE_RANGE_CHECKER_TAG);
             RecordNodeCursor nodeCursor = reader.allocateNodeCursor(cursorTracer);
             RecordReader<DynamicRecord> labelReader = new RecordReader<DynamicRecord>((CommonAbstractStore<DynamicRecord, ?>)this.context.neoStores.getNodeStore().getDynamicLabelStore(), cursorTracer);
             AllEntriesTokenScanReader labelIndexReader = this.context.labelScanStore.allEntityTokenRanges(fromNodeId, last ? Long.MAX_VALUE : toNodeId, cursorTracer);
             SafePropertyChainReader property = new SafePropertyChainReader(this.context, cursorTracer);
             SchemaComplianceChecker schemaComplianceChecker = new SchemaComplianceChecker(this.context, this.mandatoryProperties, this.smallIndexes, cursorTracer, this.context.memoryTracker);){
            ProgressListener localProgress = this.nodeProgress.threadLocalReporter();
            IntObjectHashMap propertyValues = new IntObjectHashMap();
            CacheAccess.Client client = this.context.cacheAccess.client();
            long[] nextRelCacheFields = new long[]{-1L, -1L, 1L, 0L, 0L, 1L, 0L};
            Iterator nodeLabelRangeIterator = labelIndexReader.iterator();
            EntityTokenIndexCheckState labelIndexState = new EntityTokenIndexCheckState(null, fromNodeId - 1L);
            for (long nodeId = fromNodeId; nodeId < toNodeId && !this.context.isCancelled(); ++nodeId) {
                boolean hasInlinedLabels;
                localProgress.add(1L);
                nodeCursor.single(nodeId);
                nodeCursor.setForceLoad();
                if (!nodeCursor.next()) continue;
                long nextRel = nodeCursor.getNextRel();
                if (nextRel < Record.NULL_REFERENCE.longValue()) {
                    this.reporter.forNode((NodeRecord)nodeCursor).relationshipNotInUse(new RelationshipRecord(nextRel));
                    nextRel = Record.NULL_REFERENCE.longValue();
                }
                nextRelCacheFields[0] = nextRel;
                nextRelCacheFields[3] = CacheSlots.longOf(nodeCursor.isDense());
                ++usedNodes;
                long[] unverifiedLabels = RecordLoading.safeGetNodeLabels(this.context, nodeCursor.getId(), nodeCursor.getLabelField(), labelReader, cursorTracer);
                long[] labels = this.checkNodeLabels(nodeCursor, unverifiedLabels, cursorTracer);
                long labelField = nodeCursor.getLabelField();
                boolean bl = hasInlinedLabels = !NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)nodeCursor.getLabelField());
                if (labels == null) {
                    hasInlinedLabels = true;
                    labelField = Record.NO_LABELS_FIELD.longValue();
                }
                boolean hasSingleLabel = labels != null && labels.length == 1;
                nextRelCacheFields[4] = CacheSlots.longOf(hasInlinedLabels);
                nextRelCacheFields[1] = hasSingleLabel ? labels[0] : (hasInlinedLabels ? labelField : this.observedCounts.cacheDynamicNodeLabels(labels));
                nextRelCacheFields[6] = CacheSlots.longOf(hasSingleLabel);
                RecordLoading.lightClear(propertyValues);
                boolean propertyChainIsOk = property.read((MutableIntObjectMap<Value>)propertyValues, nodeCursor, this.reporter::forNode, cursorTracer);
                this.checkNodeVsLabelIndex(nodeCursor, nodeLabelRangeIterator, labelIndexState, nodeId, labels, fromNodeId, cursorTracer);
                client.putToCache(nodeId, nextRelCacheFields);
                if (labels == null || !propertyChainIsOk) continue;
                schemaComplianceChecker.checkContainsMandatoryProperties(nodeCursor, labels, (IntObjectMap<Value>)propertyValues, this.reporter::forNode);
                if (!this.context.consistencyFlags.isCheckIndexes()) continue;
                schemaComplianceChecker.checkCorrectlyIndexed(nodeCursor, labels, (IntObjectMap<Value>)propertyValues, this.reporter::forNode);
            }
            if (!this.context.isCancelled()) {
                this.reportRemainingLabelIndexEntries(nodeLabelRangeIterator, labelIndexState, last ? Long.MAX_VALUE : toNodeId, cursorTracer);
            }
            localProgress.done();
        }
        this.observedCounts.incrementNodeLabel(-1, usedNodes);
    }

    private long[] checkNodeLabels(RecordNodeCursor nodeCursor, long[] labels, PageCursorTracer cursorTracer) {
        if (labels == null) {
            return null;
        }
        boolean allGood = true;
        boolean valid = true;
        int prevLabel = -1;
        for (int i = 0; i < labels.length; ++i) {
            long longLabel = labels[i];
            if (longLabel > Integer.MAX_VALUE) {
                this.reporter.forNode(this.recordLoader.node(nodeCursor.getId(), cursorTracer)).illegalLabel();
                allGood = false;
                valid = false;
                break;
            }
            int label = Math.toIntExact(longLabel);
            RecordLoading.checkValidToken(nodeCursor, label, this.tokenHolders.labelTokens(), this.neoStores.getLabelTokenStore(), (node, token) -> this.reporter.forNode(this.recordLoader.node(node.getId(), cursorTracer)).illegalLabel(), (node, token) -> this.reporter.forNode(this.recordLoader.node(node.getId(), cursorTracer)).labelNotInUse((LabelTokenRecord)token), cursorTracer);
            if (prevLabel != label) {
                this.observedCounts.incrementNodeLabel(label, 1L);
                prevLabel = label;
            }
            if (i <= 0) continue;
            if (labels[i] == labels[i - 1]) {
                this.reporter.forNode((NodeRecord)nodeCursor).labelDuplicate(labels[i]);
                allGood = false;
                break;
            }
            if (labels[i] >= labels[i - 1]) continue;
            this.reporter.forNode((NodeRecord)nodeCursor).labelsOutOfOrder(NumberUtils.max((long[])labels), NumberUtils.min((long[])labels));
            allGood = false;
            break;
        }
        if (!valid) {
            return null;
        }
        return allGood ? labels : NodeInUseWithCorrectLabelsCheck.sortAndDeduplicate(labels);
    }

    private void checkNodeVsLabelIndex(RecordNodeCursor nodeCursor, Iterator<EntityTokenRange> nodeLabelRangeIterator, EntityTokenIndexCheckState labelIndexState, long nodeId, long[] labels, long fromNodeId, PageCursorTracer cursorTracer) {
        long nodeIdMissingFromStore;
        while (labelIndexState.needToMoveRangeForwardToReachEntity(nodeId) && !this.context.isCancelled() && nodeLabelRangeIterator.hasNext()) {
            if (labelIndexState.currentRange != null) {
                nodeIdMissingFromStore = labelIndexState.lastCheckedEntityId + 1L;
                while (nodeIdMissingFromStore < nodeId & labelIndexState.currentRange.covers(nodeIdMissingFromStore)) {
                    if (labelIndexState.currentRange.tokens(nodeIdMissingFromStore).length > 0) {
                        this.reporter.forNodeLabelScan(new TokenScanDocument(labelIndexState.currentRange)).nodeNotInUse(this.recordLoader.node(nodeIdMissingFromStore, cursorTracer));
                    }
                    ++nodeIdMissingFromStore;
                }
            }
            labelIndexState.currentRange = nodeLabelRangeIterator.next();
            labelIndexState.lastCheckedEntityId = NumberUtils.max((long[])new long[]{fromNodeId, labelIndexState.currentRange.entities()[0]}) - 1L;
        }
        if (labelIndexState.currentRange != null && labelIndexState.currentRange.covers(nodeId)) {
            for (nodeIdMissingFromStore = labelIndexState.lastCheckedEntityId + 1L; nodeIdMissingFromStore < nodeId; ++nodeIdMissingFromStore) {
                if (labelIndexState.currentRange.tokens(nodeIdMissingFromStore).length <= 0) continue;
                this.reporter.forNodeLabelScan(new TokenScanDocument(labelIndexState.currentRange)).nodeNotInUse(this.recordLoader.node(nodeIdMissingFromStore, cursorTracer));
            }
            long[] labelsInLabelIndex = labelIndexState.currentRange.tokens(nodeId);
            if (labels != null) {
                this.validateLabelIds((NodeRecord)nodeCursor, labels, NodeInUseWithCorrectLabelsCheck.sortAndDeduplicate(labelsInLabelIndex), labelIndexState.currentRange, cursorTracer);
            }
            labelIndexState.lastCheckedEntityId = nodeId;
        } else if (labels != null) {
            for (long label : labels) {
                this.reporter.forNodeLabelScan(new TokenScanDocument(new EntityTokenRange(nodeId / 64L, EntityTokenRange.NO_TOKENS, EntityType.NODE))).nodeLabelNotInIndex(this.recordLoader.node(nodeId, cursorTracer), label);
            }
        }
    }

    private void reportRemainingLabelIndexEntries(Iterator<EntityTokenRange> nodeLabelRangeIterator, EntityTokenIndexCheckState labelIndexState, long toNodeId, PageCursorTracer cursorTracer) {
        if (labelIndexState.currentRange == null && nodeLabelRangeIterator.hasNext()) {
            labelIndexState.currentRange = nodeLabelRangeIterator.next();
        }
        while (labelIndexState.currentRange != null && !this.context.isCancelled()) {
            long nodeIdMissingFromStore = labelIndexState.lastCheckedEntityId + 1L;
            while (nodeIdMissingFromStore < toNodeId && !labelIndexState.needToMoveRangeForwardToReachEntity(nodeIdMissingFromStore)) {
                if (labelIndexState.currentRange.covers(nodeIdMissingFromStore) && labelIndexState.currentRange.tokens(nodeIdMissingFromStore).length > 0) {
                    this.reporter.forNodeLabelScan(new TokenScanDocument(labelIndexState.currentRange)).nodeNotInUse(this.recordLoader.node(nodeIdMissingFromStore, cursorTracer));
                }
                labelIndexState.lastCheckedEntityId = nodeIdMissingFromStore++;
            }
            labelIndexState.currentRange = nodeLabelRangeIterator.hasNext() ? nodeLabelRangeIterator.next() : null;
        }
    }

    private void validateLabelIds(NodeRecord node, long[] labelsInStore, long[] labelsInIndex, EntityTokenRange entityTokenRange, PageCursorTracer cursorTracer) {
        NodeChecker.compareTwoSortedLongArrays(PropertySchemaType.COMPLETE_ALL_TOKENS, labelsInStore, labelsInIndex, indexLabel -> this.reporter.forNodeLabelScan(new TokenScanDocument(entityTokenRange)).nodeDoesNotHaveExpectedLabel(this.recordLoader.node(node.getId(), cursorTracer), indexLabel), storeLabel -> this.reporter.forNodeLabelScan(new TokenScanDocument(entityTokenRange)).nodeLabelNotInIndex(this.recordLoader.node(node.getId(), cursorTracer), storeLabel));
    }

    static void compareTwoSortedLongArrays(PropertySchemaType propertySchemaType, long[] a, long[] b, LongConsumer bHasSomethingThatAIsMissingReport, LongConsumer aHasSomethingThatBIsMissingReport) {
        block9: {
            boolean anyFound;
            int bCursor;
            block8: {
                bCursor = 0;
                int aCursor = 0;
                anyFound = false;
                while (aCursor < a.length && bCursor < b.length && a[aCursor] != -1L && b[bCursor] != -1L) {
                    long bValue = b[bCursor];
                    long aValue = a[aCursor];
                    if (bValue < aValue) {
                        if (propertySchemaType == PropertySchemaType.COMPLETE_ALL_TOKENS) {
                            bHasSomethingThatAIsMissingReport.accept(bValue);
                        }
                        ++bCursor;
                        continue;
                    }
                    if (bValue > aValue) {
                        if (propertySchemaType == PropertySchemaType.COMPLETE_ALL_TOKENS) {
                            aHasSomethingThatBIsMissingReport.accept(aValue);
                        }
                        ++aCursor;
                        continue;
                    }
                    ++bCursor;
                    ++aCursor;
                    anyFound = true;
                }
                if (propertySchemaType != PropertySchemaType.COMPLETE_ALL_TOKENS) break block8;
                while (bCursor < b.length && b[bCursor] != -1L) {
                    bHasSomethingThatAIsMissingReport.accept(b[bCursor++]);
                }
                while (aCursor < a.length && a[aCursor] != -1L) {
                    aHasSomethingThatBIsMissingReport.accept(a[aCursor++]);
                }
                break block9;
            }
            if (propertySchemaType != PropertySchemaType.PARTIAL_ANY_TOKEN || anyFound) break block9;
            while (bCursor < b.length) {
                bHasSomethingThatAIsMissingReport.accept(b[bCursor++]);
            }
        }
    }

    private void checkIndexVsNodes(LongRange range, IndexDescriptor descriptor, boolean lastRange) throws Exception {
        CacheAccess.Client client = this.context.cacheAccess.client();
        IndexAccessor accessor = this.context.indexAccessors.accessorFor(descriptor);
        RelationshipCounter.NodeLabelsLookup nodeLabelsLookup = this.observedCounts.nodeLabelsLookup();
        SchemaDescriptor schema = descriptor.schema();
        PropertySchemaType propertySchemaType = schema.propertySchemaType();
        long[] indexEntityTokenIds = NodeChecker.toLongArray(schema.getEntityTokenIds());
        indexEntityTokenIds = NodeInUseWithCorrectLabelsCheck.sortAndDeduplicate(indexEntityTokenIds);
        try (PageCursorTracer cursorTracer = this.context.pageCacheTracer.createPageCursorTracer(NODE_INDEXES_CHECKER_TAG);
             BoundedIterable allEntriesReader = accessor.newAllEntriesReader(range.from(), lastRange ? Long.MAX_VALUE : range.to(), cursorTracer);){
            Iterator iterator = allEntriesReader.iterator();
            while (iterator.hasNext()) {
                long entityId = (Long)iterator.next();
                try {
                    boolean entityExists = client.getBooleanFromCache(entityId, 2);
                    if (!entityExists) {
                        this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeNotInUse(this.recordLoader.node(entityId, cursorTracer));
                        continue;
                    }
                    long[] entityTokenIds = nodeLabelsLookup.nodeLabels(entityId);
                    NodeChecker.compareTwoSortedLongArrays(propertySchemaType, entityTokenIds, indexEntityTokenIds, indexLabel -> this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeDoesNotHaveExpectedLabel(this.recordLoader.node(entityId, cursorTracer), indexLabel), storeLabel -> {});
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeNotInUse(this.recordLoader.node(entityId, cursorTracer));
                }
            }
        }
    }

    private static long[] toLongArray(int[] intArray) {
        long[] result = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            result[i] = intArray[i];
        }
        return result;
    }

    public String toString() {
        return String.format("%s[highId:%d,indexesToCheck:%d]", this.getClass().getSimpleName(), this.neoStores.getNodeStore().getHighId(), this.smallIndexes.size());
    }
}

