/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.List;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.RelationshipToIndexCheck;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipIndexProcessor
extends RecordProcessor.Adapter<RelationshipRecord> {
    private final ConsistencyReporter reporter;
    private final RelationshipToIndexCheck checker;

    RelationshipIndexProcessor(ConsistencyReporter reporter, IndexAccessors indexes, PropertyReader propertyReader, List<IndexDescriptor> relationshipIndexes) {
        this.reporter = reporter;
        this.checker = new RelationshipToIndexCheck(relationshipIndexes, indexes, propertyReader);
    }

    @Override
    public void process(RelationshipRecord relationshipRecord, PageCursorTracer cursorTracer) {
        this.reporter.forRelationship(relationshipRecord, this.checker, cursorTracer);
    }
}

