/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.full.MandatoryProperties;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class PropertyChain<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
implements RecordField<RECORD, REPORT>,
ComparativeRecordChecker<RECORD, PropertyRecord, REPORT> {
    private final Function<RECORD, MandatoryProperties.Check<RECORD, REPORT>> mandatoryProperties;

    public PropertyChain(Function<RECORD, MandatoryProperties.Check<RECORD, REPORT>> mandatoryProperties) {
        this.mandatoryProperties = mandatoryProperties;
    }

    @Override
    public void checkConsistency(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (!Record.NO_NEXT_PROPERTY.is(record.getNextProp())) {
            Iterator<PropertyRecord> props = records.rawPropertyChain(record.getNextProp(), cursorTracer);
            PropertyRecord firstProp = props.next();
            if (!Record.NO_PREVIOUS_PROPERTY.is(firstProp.getPrevProp())) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotFirstInChain(firstProp);
            }
            IntHashSet keys = new IntHashSet();
            LongHashSet propertyRecordIds = new LongHashSet(8);
            propertyRecordIds.add(firstProp.getId());
            try (MandatoryProperties.Check<RECORD, REPORT> mandatory = this.mandatoryProperties.apply(record);){
                this.checkChainItem(firstProp, engine, (MutableIntSet)keys, mandatory);
                PropertyRecord prop = firstProp;
                while (props.hasNext()) {
                    PropertyRecord nextProp = props.next();
                    if (!propertyRecordIds.add(nextProp.getId())) {
                        ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyChainContainsCircularReference(prop);
                        break;
                    }
                    this.checkChainItem(nextProp, engine, (MutableIntSet)keys, mandatory);
                    prop = nextProp;
                }
            }
        }
    }

    private void checkChainItem(PropertyRecord property, CheckerEngine<RECORD, REPORT> engine, MutableIntSet keys, MandatoryProperties.Check<RECORD, REPORT> mandatory) {
        if (!property.inUse()) {
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotInUse(property);
        } else {
            int[] keysInRecord = ChainCheck.keys(property);
            if (mandatory != null) {
                mandatory.receive(keysInRecord);
            }
            for (int key : keysInRecord) {
                if (keys.add(key)) continue;
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyKeyNotUniqueInChain();
            }
        }
    }

    @Override
    public long valueFrom(RECORD record) {
        return record.getNextProp();
    }

    @Override
    public void checkReference(RECORD record, PropertyRecord property, CheckerEngine<RECORD, REPORT> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (!property.inUse()) {
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotInUse(property);
        } else {
            if (!Record.NO_PREVIOUS_PROPERTY.is(property.getPrevProp())) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotFirstInChain(property);
            }
            new ChainCheck<RECORD, REPORT>().checkReference(record, property, engine, records, cursorTracer);
        }
    }
}

