/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

abstract class RecordScanner<RECORD>
extends ConsistencyCheckerTask {
    protected final ProgressListener progress;
    protected final BoundedIterable<RECORD> store;
    protected final RecordProcessor<RECORD> processor;
    private final IterableStore[] warmUpStores;

    RecordScanner(String name, Statistics statistics, int threads, BoundedIterable<RECORD> store, ProgressMonitorFactory.MultiPartBuilder builder, RecordProcessor<RECORD> processor, IterableStore ... warmUpStores) {
        super(name, statistics, threads);
        this.store = store;
        this.processor = processor;
        long maxCount = store.maxCount();
        this.progress = maxCount == -1L ? builder.progressForUnknownPart(name) : builder.progressForPart(name, maxCount);
        this.warmUpStores = warmUpStores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.statistics.reset();
        if (this.warmUpStores != null) {
            for (IterableStore store : this.warmUpStores) {
                store.warmUpCache();
            }
        }
        try {
            this.scan();
        }
        finally {
            try {
                this.store.close();
            }
            catch (Exception e) {
                this.progress.failed((Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.processor.close();
                this.progress.done();
            }
        }
        this.statistics.print(this.name);
    }

    protected abstract void scan();
}

