/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.store.DelegatingRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.internal.helpers.collection.FilteringIterator;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class FilteringRecordAccess
extends DelegatingRecordAccess {
    private final Set<MultiPassStore> potentiallySkippableStores = EnumSet.noneOf(MultiPassStore.class);
    private final MultiPassStore currentStore;

    public FilteringRecordAccess(RecordAccess delegate, MultiPassStore currentStore, MultiPassStore ... potentiallySkippableStores) {
        super(delegate);
        this.currentStore = currentStore;
        this.potentiallySkippableStores.addAll(Arrays.asList(potentiallySkippableStores));
    }

    @Override
    public RecordReference<NodeRecord> node(long id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.NODES)) {
            return super.node(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public RecordReference<RelationshipRecord> relationship(long id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.RELATIONSHIPS)) {
            return super.relationship(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public RecordReference<RelationshipGroupRecord> relationshipGroup(long id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.RELATIONSHIP_GROUPS)) {
            return super.relationshipGroup(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public RecordReference<PropertyRecord> property(long id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.PROPERTIES)) {
            return super.property(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public Iterator<PropertyRecord> rawPropertyChain(long firstId, PageCursorTracer cursorTracer) {
        return new FilteringIterator(super.rawPropertyChain(firstId, cursorTracer), item -> this.shouldCheck(item.getId(), MultiPassStore.PROPERTIES));
    }

    @Override
    public RecordReference<PropertyKeyTokenRecord> propertyKey(int id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.PROPERTY_KEYS)) {
            return super.propertyKey(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public RecordReference<DynamicRecord> string(long id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.STRINGS)) {
            return super.string(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public RecordReference<DynamicRecord> array(long id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.ARRAYS)) {
            return super.array(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public RecordReference<LabelTokenRecord> label(int id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.LABELS)) {
            return super.label(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public RecordReference<DynamicRecord> nodeLabels(long id, PageCursorTracer cursorTracer) {
        if (this.shouldCheck(id, MultiPassStore.LABELS)) {
            return super.nodeLabels(id, cursorTracer);
        }
        return RecordReference.SkippingReference.skipReference();
    }

    @Override
    public boolean shouldCheck(long id, MultiPassStore store) {
        return !this.potentiallySkippableStores.contains((Object)store) || this.currentStore == store;
    }

    static enum Mode {
        SKIP,
        FILTER;

    }
}

