/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.util.concurrent.Futures;

class ParallelExecution {
    static final Consumer<Throwable> NOOP_EXCEPTION_HANDLER = t -> {};
    static final int DEFAULT_IDS_PER_CHUNK = 1000000;
    private final int numberOfThreads;
    private final Consumer<Throwable> exceptionHandler;
    private int idsPerChunk;

    ParallelExecution(int numberOfThreads, Consumer<Throwable> exceptionHandler, int idsPerChunk) {
        this.numberOfThreads = numberOfThreads;
        this.exceptionHandler = exceptionHandler;
        this.idsPerChunk = idsPerChunk;
    }

    void run(String taskName, ThrowingRunnable ... runnables) throws Exception {
        this.run(taskName, this.numberOfThreads, runnables);
    }

    void runAll(String taskName, ThrowingRunnable ... runnables) throws Exception {
        this.run(taskName, runnables.length, runnables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String taskName, int numberOfThreads, ThrowingRunnable ... runnables) throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(numberOfThreads, (ThreadFactory)new NamedThreadFactory(this.getClass().getSimpleName() + "-" + taskName));
        try {
            List tasks = Arrays.stream(runnables).map(x$0 -> new InternalTask((ThrowingRunnable)x$0)).collect(Collectors.toList());
            Futures.getAllResults(pool.invokeAll(tasks));
        }
        finally {
            pool.shutdown();
        }
    }

    ThrowingRunnable[] partition(RecordStore<?> store, RangeOperation rangeOperation) {
        LongRange range = LongRange.range((long)store.getNumberOfReservedLowIds(), (long)store.getHighId());
        return this.partition(range, rangeOperation);
    }

    ThrowingRunnable[] partition(LongRange range, RangeOperation rangeOperation) {
        ArrayList<ThrowingRunnable> partitions = new ArrayList<ThrowingRunnable>();
        for (long id = range.from(); id < range.to(); id += (long)this.idsPerChunk) {
            long to = Long.min(id + (long)this.idsPerChunk, range.to());
            boolean last = to == range.to();
            partitions.add(rangeOperation.operation(id, to, last));
        }
        return partitions.toArray(new ThrowingRunnable[0]);
    }

    int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    static interface RangeOperation {
        public ThrowingRunnable operation(long var1, long var3, boolean var5);
    }

    private class InternalTask
    implements Callable<Void> {
        private final ThrowingRunnable runnable;

        InternalTask(ThrowingRunnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public Void call() throws Exception {
            try {
                this.runnable.call();
            }
            catch (Throwable t) {
                ParallelExecution.this.exceptionHandler.accept(t);
                throw t;
            }
            return null;
        }
    }

    static interface ThrowingRunnable
    extends Callable<Void> {
        @Override
        default public Void call() throws Exception {
            this.doRun();
            return null;
        }

        public void doRun() throws Exception;
    }
}

