/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

enum NodeField implements RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>,
ComparativeRecordChecker<RelationshipRecord, NodeRecord, ConsistencyReport.RelationshipConsistencyReport>
{
    SOURCE{

        @Override
        public long valueFrom(RelationshipRecord relationship) {
            return relationship.getFirstNode();
        }

        @Override
        public long prev(RelationshipRecord relationship) {
            return relationship.getFirstPrevRel();
        }

        @Override
        public long next(RelationshipRecord relationship) {
            return relationship.getFirstNextRel();
        }

        @Override
        public boolean isFirst(RelationshipRecord relationship) {
            return relationship.isFirstInFirstChain();
        }

        @Override
        void illegalNode(ConsistencyReport.RelationshipConsistencyReport report) {
            report.illegalSourceNode();
        }

        @Override
        void nodeNotInUse(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.sourceNodeNotInUse(node);
        }

        @Override
        void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.sourceNodeDoesNotReferenceBack(node);
        }

        @Override
        void noChain(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.sourceNodeHasNoRelationships(node);
        }

        @Override
        void notFirstInChain(ConsistencyReport.NodeConsistencyReport report, RelationshipRecord relationship) {
            report.relationshipNotFirstInSourceChain(relationship);
        }
    }
    ,
    TARGET{

        @Override
        public long valueFrom(RelationshipRecord relationship) {
            return relationship.getSecondNode();
        }

        @Override
        public long prev(RelationshipRecord relationship) {
            return relationship.getSecondPrevRel();
        }

        @Override
        public long next(RelationshipRecord relationship) {
            return relationship.getSecondNextRel();
        }

        @Override
        public boolean isFirst(RelationshipRecord relationship) {
            return relationship.isFirstInSecondChain();
        }

        @Override
        void illegalNode(ConsistencyReport.RelationshipConsistencyReport report) {
            report.illegalTargetNode();
        }

        @Override
        void nodeNotInUse(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.targetNodeNotInUse(node);
        }

        @Override
        void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.targetNodeDoesNotReferenceBack(node);
        }

        @Override
        void noChain(ConsistencyReport.RelationshipConsistencyReport report, NodeRecord node) {
            report.targetNodeHasNoRelationships(node);
        }

        @Override
        void notFirstInChain(ConsistencyReport.NodeConsistencyReport report, RelationshipRecord relationship) {
            report.relationshipNotFirstInTargetChain(relationship);
        }
    };


    @Override
    public abstract long valueFrom(RelationshipRecord var1);

    public static NodeField select(RelationshipRecord relationship, NodeRecord node) {
        return NodeField.select(relationship, node.getId());
    }

    public static NodeField select(RelationshipRecord relationship, long nodeId) {
        if (relationship.getFirstNode() == nodeId) {
            return SOURCE;
        }
        if (relationship.getSecondNode() == nodeId) {
            return TARGET;
        }
        return null;
    }

    public abstract long prev(RelationshipRecord var1);

    public abstract long next(RelationshipRecord var1);

    public abstract boolean isFirst(RelationshipRecord var1);

    public boolean hasRelationship(NodeRecord node) {
        return node.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    @Override
    public void checkConsistency(RelationshipRecord relationship, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (this.valueFrom(relationship) < 0L) {
            this.illegalNode(engine.report());
        } else {
            NodeRecord node = new NodeRecord(this.valueFrom(relationship));
            CacheAccess.Client client = records.cacheAccess().client();
            node.setInUse(client.getBooleanFromCache(node.getId(), 1));
            node.setNextRel(client.getFromCache(node.getId(), 0));
            node.setCreated();
            if (records.shouldCheck(node.getId(), MultiPassStore.NODES)) {
                engine.comparativeCheck(new DirectRecordReference<NodeRecord>(node, records, cursorTracer), this);
            }
        }
    }

    @Override
    public void checkReference(RelationshipRecord relationship, NodeRecord node, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (!node.inUse()) {
            this.nodeNotInUse(engine.report(), node);
        } else if (this.isFirst(relationship)) {
            CacheAccess.Client cacheAccess = records.cacheAccess().client();
            if (node.getNextRel() != relationship.getId()) {
                if (!(node = (NodeRecord)((DirectRecordReference)records.node(node.getId(), cursorTracer)).record()).isDense()) {
                    this.noBackReference(engine.report(), node);
                }
            } else if (relationship.getFirstNode() != relationship.getSecondNode()) {
                cacheAccess.putToCacheSingle(node.getId(), 2, -1L);
            }
        } else if (!this.hasRelationship(node)) {
            this.noChain(engine.report(), node);
        }
    }

    abstract void illegalNode(ConsistencyReport.RelationshipConsistencyReport var1);

    abstract void nodeNotInUse(ConsistencyReport.RelationshipConsistencyReport var1, NodeRecord var2);

    abstract void noBackReference(ConsistencyReport.RelationshipConsistencyReport var1, NodeRecord var2);

    abstract void noChain(ConsistencyReport.RelationshipConsistencyReport var1, NodeRecord var2);

    abstract void notFirstInChain(ConsistencyReport.NodeConsistencyReport var1, RelationshipRecord var2);
}

