/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.consistency.ConsistencyCheckOptions;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="check-consistency", header={"Check the consistency of a database."}, description={"This command allows for checking the consistency of a database or a backup thereof. It cannot be used with a database which is currently in use.%n%nAll checks except 'check-graph' can be quite expensive so it may be useful to turn them off for very large databases. Increasing the heap size can also be a good idea. See 'neo4j-admin help' for details."})
public class CheckConsistencyCommand
extends AbstractCommand {
    @CommandLine.ArgGroup(multiplicity="1")
    private TargetOption target = new TargetOption();
    @CommandLine.Option(names={"--additional-config"}, paramLabel="<path>", description={"Configuration file to supply additional configuration in."})
    private Path additionalConfig;
    @CommandLine.Mixin
    private ConsistencyCheckOptions options;
    private final ConsistencyCheckService consistencyCheckService;

    public CheckConsistencyCommand(ExecutionContext ctx) {
        this(ctx, new ConsistencyCheckService());
    }

    @VisibleForTesting
    public CheckConsistencyCommand(ExecutionContext ctx, ConsistencyCheckService consistencyCheckService) {
        super(ctx);
        this.consistencyCheckService = consistencyCheckService;
    }

    public void execute() {
        if (this.target.backup != null) {
            this.target.backup = this.target.backup.toAbsolutePath();
            if (!Files.isDirectory(this.target.backup, new LinkOption[0])) {
                throw new CommandFailedException("Report directory path doesn't exist or not a directory: " + this.target.backup);
            }
        }
        Config config = this.loadNeo4jConfig(this.ctx.homeDir(), this.ctx.confDir(), this.additionalConfig);
        EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            DatabaseLayout databaseLayout = Optional.ofNullable(this.target.backup).map(DatabaseLayout::ofFlat).orElseGet(() -> Neo4jLayout.of((Config)config).databaseLayout(this.target.database.name()));
            this.checkDatabaseExistence(databaseLayout);
            try (Closeable ignored = LockChecker.checkDatabaseLock((DatabaseLayout)databaseLayout);){
                ConsistencyCheckService.Result consistencyCheckResult;
                CheckConsistencyCommand.checkDbState(databaseLayout, config, (MemoryTracker)memoryTracker);
                ProgressMonitorFactory progressMonitorFactory = ProgressMonitorFactory.NONE;
                if (System.console() != null) {
                    progressMonitorFactory = ProgressMonitorFactory.textual((OutputStream)System.out);
                }
                try (Log4jLogProvider logProvider = Util.configuredLogProvider((Config)config, (OutputStream)System.out);){
                    consistencyCheckResult = this.consistencyCheckService.runFullConsistencyCheck(databaseLayout, config, progressMonitorFactory, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem, this.verbose, this.options.getReportDir().normalize(), new ConsistencyFlags(this.options.isCheckGraph(), this.options.isCheckIndexes(), this.options.isCheckIndexStructure(), this.options.isCheckLabelScanStore(), this.options.isCheckRelationshipTypeScanStore(), this.options.isCheckPropertyOwners()));
                }
                if (!consistencyCheckResult.isSuccessful()) {
                    throw new CommandFailedException(String.format("Inconsistencies found. See '%s' for details.", consistencyCheckResult.reportFile()));
                }
            }
            catch (FileLockException e) {
                throw new CommandFailedException("The database is in use. Stop database '" + databaseLayout.getDatabaseName() + "' and try again.", (Throwable)e);
            }
            catch (CannotWriteException e) {
                throw new CommandFailedException("You do not have permission to check database consistency.", (Throwable)e);
            }
        }
        catch (IOException | ConsistencyCheckIncompleteException e) {
            throw new CommandFailedException("Consistency checking failed." + e.getMessage(), (Throwable)e);
        }
    }

    private void checkDatabaseExistence(DatabaseLayout databaseLayout) {
        try {
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)databaseLayout.databaseDirectory());
        }
        catch (IllegalArgumentException e) {
            throw new CommandFailedException("Database does not exist: " + databaseLayout.getDatabaseName(), (Throwable)e);
        }
    }

    private static void checkDbState(DatabaseLayout databaseLayout, Config additionalConfiguration, MemoryTracker memoryTracker) {
        if (CheckConsistencyCommand.checkRecoveryState(databaseLayout, additionalConfiguration, memoryTracker)) {
            throw new CommandFailedException(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database before running the consistency check.", "To perform recovery please start database and perform clean shutdown."}));
        }
    }

    private static boolean checkRecoveryState(DatabaseLayout databaseLayout, Config additionalConfiguration, MemoryTracker memoryTracker) {
        try {
            return Recovery.isRecoveryRequired((DatabaseLayout)databaseLayout, (Config)additionalConfiguration, (MemoryTracker)memoryTracker);
        }
        catch (Exception e) {
            throw new CommandFailedException("Failure when checking for recovery state: " + e.getMessage(), (Throwable)e);
        }
    }

    private Config loadNeo4jConfig(Path homeDir, Path configDir, Path additionalConfig) {
        Config cfg = Config.newBuilder().fromFileNoThrow(configDir.resolve("neo4j.conf")).fromFileNoThrow(additionalConfig).commandExpansion(this.allowCommandExpansion).set(GraphDatabaseSettings.neo4j_home, (Object)homeDir).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }

    private static class TargetOption {
        @CommandLine.Option(names={"--database"}, description={"Name of the database to check."}, converter={Converters.DatabaseNameConverter.class})
        private NormalizedDatabaseName database;
        @CommandLine.Option(names={"--backup"}, paramLabel="<path>", description={"Path to backup to check consistency of. Cannot be used together with --database."})
        private Path backup;

        private TargetOption() {
        }
    }
}

