/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.Iterator;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public class DirectRecordAccess
implements RecordAccess {
    final StoreAccess access;
    final CacheAccess cacheAccess;

    public DirectRecordAccess(StoreAccess access, CacheAccess cacheAccess) {
        this.access = access;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public RecordReference<SchemaRecord> schema(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo((RecordStore)this.access.getSchemaStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<NodeRecord> node(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getNodeStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<RelationshipRecord> relationship(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getRelationshipStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<RelationshipGroupRecord> relationshipGroup(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getRelationshipGroupStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<PropertyRecord> property(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getPropertyStore(), id, cursorTracer);
    }

    @Override
    public Iterator<PropertyRecord> rawPropertyChain(final long firstId, final PageCursorTracer cursorTracer) {
        return new PrefetchingIterator<PropertyRecord>(){
            private long next;
            {
                this.next = firstId;
            }

            protected PropertyRecord fetchNextOrNull() {
                if (Record.NO_NEXT_PROPERTY.is(this.next)) {
                    return null;
                }
                PropertyRecord record = (PropertyRecord)DirectRecordAccess.this.referenceTo(DirectRecordAccess.this.access.getPropertyStore(), this.next, cursorTracer).record();
                this.next = record.getNextProp();
                return record;
            }
        };
    }

    @Override
    public RecordReference<RelationshipTypeTokenRecord> relationshipType(int id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getRelationshipTypeTokenStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<PropertyKeyTokenRecord> propertyKey(int id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getPropertyKeyTokenStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<DynamicRecord> string(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getStringStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<DynamicRecord> array(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getArrayStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<DynamicRecord> relationshipTypeName(int id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getRelationshipTypeNameStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<DynamicRecord> nodeLabels(long id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getNodeDynamicLabelStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<LabelTokenRecord> label(int id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getLabelTokenStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<DynamicRecord> labelName(int id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getLabelNameStore(), id, cursorTracer);
    }

    @Override
    public RecordReference<DynamicRecord> propertyKeyName(int id, PageCursorTracer cursorTracer) {
        return this.referenceTo(this.access.getPropertyKeyNameStore(), id, cursorTracer);
    }

    @Override
    public boolean shouldCheck(long id, MultiPassStore store) {
        return true;
    }

    <RECORD extends AbstractBaseRecord> DirectRecordReference<RECORD> referenceTo(RecordStore<RECORD> store, long id, PageCursorTracer cursorTracer) {
        return new DirectRecordReference<AbstractBaseRecord>(store.getRecord(id, store.newRecord(), RecordLoad.FORCE, cursorTracer), this, cursorTracer);
    }

    @Override
    public CacheAccess cacheAccess() {
        return this.cacheAccess;
    }
}

