/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.CountsState;
import org.neo4j.consistency.newchecker.IndexChecker;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.newchecker.NodeChecker;
import org.neo4j.consistency.newchecker.ParallelExecution;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.newchecker.RelationshipChainChecker;
import org.neo4j.consistency.newchecker.RelationshipChecker;
import org.neo4j.consistency.newchecker.RelationshipGroupChecker;
import org.neo4j.consistency.newchecker.SchemaChecker;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class RecordStorageConsistencyChecker
implements AutoCloseable {
    private static final String COUNT_STORE_CONSISTENCY_CHECKER_TAG = "countStoreConsistencyChecker";
    private static final String SCHEMA_CONSISTENCY_CHECKER_TAG = "schemaConsistencyChecker";
    private static final String CONSISTENCY_CHECKER_TOKEN_LOADER_TAG = "consistencyCheckerTokenLoader";
    static final int[] DEFAULT_SLOT_SIZES = new int[]{40, 40, 1, 1, 1, 1, 1};
    private final PageCache pageCache;
    private final NeoStores neoStores;
    private final TokenHolders tokenHolders;
    private final CountsStore counts;
    private final PageCacheTracer cacheTracer;
    private final CacheAccess cacheAccess;
    private final ConsistencyReporter reporter;
    private final CountsState observedCounts;
    private final NodeBasedMemoryLimiter limiter;
    private final CheckerContext context;
    private final ProgressMonitorFactory.MultiPartBuilder progress;

    public RecordStorageConsistencyChecker(PageCache pageCache, NeoStores neoStores, CountsStore counts, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, IndexAccessors indexAccessors, InconsistencyReport report, ProgressMonitorFactory progressFactory, Config config, int numberOfThreads, boolean debug, ConsistencyFlags consistencyFlags, NodeBasedMemoryLimiter.Factory memoryLimit, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        this.pageCache = pageCache;
        this.neoStores = neoStores;
        this.counts = counts;
        this.cacheTracer = cacheTracer;
        int stopCountThreshold = (Integer)config.get(GraphDatabaseInternalSettings.experimental_consistency_checker_stop_threshold);
        AtomicInteger stopCount = new AtomicInteger(0);
        ConsistencyReporter.Monitor monitor = ConsistencyReporter.NO_MONITOR;
        if (stopCountThreshold > 0) {
            monitor = (ignoredArg1, ignoredArg2, ignoredArg3) -> {
                if (!this.isCancelled() && stopCount.incrementAndGet() >= stopCountThreshold) {
                    this.cancel("Observed " + stopCount.get() + " inconsistencies.");
                }
            };
        }
        this.reporter = new ConsistencyReporter(new DirectRecordAccess(new StoreAccess(neoStores), null), report, monitor, cacheTracer);
        this.tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
        ParallelExecution execution = new ParallelExecution(numberOfThreads, exception -> this.cancel("Unexpected exception"), 1000000);
        RecordLoading recordLoading = new RecordLoading(neoStores);
        this.limiter = this.instantiateMemoryLimiter(memoryLimit);
        this.cacheAccess = new DefaultCacheAccess(DefaultCacheAccess.defaultByteArray(this.limiter.rangeSize(), memoryTracker), Counts.NONE, numberOfThreads);
        this.observedCounts = new CountsState(neoStores, this.cacheAccess, memoryTracker);
        this.progress = progressFactory.multipleParts("Consistency check");
        this.context = new CheckerContext(neoStores, indexAccessors, labelScanStore, relationshipTypeScanStore, execution, this.reporter, this.cacheAccess, this.tokenHolders, recordLoading, this.observedCounts, this.limiter, this.progress, pageCache, cacheTracer, memoryTracker, debug, consistencyFlags);
    }

    public void check() throws ConsistencyCheckIncompleteException {
        assert (!this.context.isCancelled());
        try {
            this.context.initialize();
            this.safeLoadTokens(this.neoStores);
            SchemaChecker schemaChecker = new SchemaChecker(this.context);
            IntObjectHashMap mandatoryNodeProperties = new IntObjectHashMap();
            IntObjectHashMap mandatoryRelationshipProperties = new IntObjectHashMap();
            try (PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(SCHEMA_CONSISTENCY_CHECKER_TAG);){
                schemaChecker.check((MutableIntObjectMap<MutableIntSet>)mandatoryNodeProperties, (MutableIntObjectMap<MutableIntSet>)mandatoryRelationshipProperties, cursorTracer);
            }
            NodeChecker nodeChecker = new NodeChecker(this.context, (MutableIntObjectMap<MutableIntSet>)mandatoryNodeProperties);
            IndexChecker indexChecker = new IndexChecker(this.context, EntityType.NODE);
            RelationshipChecker relationshipChecker = new RelationshipChecker(this.context, (MutableIntObjectMap<MutableIntSet>)mandatoryRelationshipProperties);
            RelationshipGroupChecker relationshipGroupChecker = new RelationshipGroupChecker(this.context);
            RelationshipChainChecker relationshipChainChecker = new RelationshipChainChecker(this.context);
            ProgressMonitorFactory.Completer progressCompleter = this.progress.build();
            int numberOfRanges = this.limiter.numberOfRanges();
            int i = 1;
            while (this.limiter.hasNext() && !this.isCancelled()) {
                LongRange range = (LongRange)this.limiter.next();
                if (numberOfRanges > 1) {
                    this.context.debug("=== Checking range %d/%d (%s) ===", i, numberOfRanges, range);
                }
                this.context.initializeRange();
                this.cacheAccess.setPivotId(range.from());
                this.context.runIfAllowed(indexChecker, range);
                this.cacheAccess.setCacheSlotSizesAndClear(DEFAULT_SLOT_SIZES);
                this.context.runIfAllowed(nodeChecker, range);
                this.context.runIfAllowed(relationshipGroupChecker, range);
                this.context.runIfAllowed(relationshipChecker, range);
                this.context.runIfAllowed(relationshipChainChecker, range);
                ++i;
            }
            if (!this.isCancelled() && this.context.consistencyFlags.isCheckGraph()) {
                this.checkCounts();
            }
            progressCompleter.close();
        }
        catch (Exception e) {
            this.cancel("ConsistencyChecker failed unexpectedly");
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    private NodeBasedMemoryLimiter instantiateMemoryLimiter(NodeBasedMemoryLimiter.Factory memoryLimit) {
        long pageCacheMemory = this.pageCache.maxCachedPages() * (long)this.pageCache.pageSize();
        long nodeCount = this.neoStores.getNodeStore().getHighId();
        return memoryLimit.create(pageCacheMemory, nodeCount);
    }

    @Override
    public void close() throws Exception {
        this.context.cancel();
        this.observedCounts.close();
    }

    private void checkCounts() {
        if (this.counts != CountsStore.NULL_INSTANCE) {
            try (CountsState.CountsChecker checker = this.observedCounts.checker(this.reporter);
                 PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(COUNT_STORE_CONSISTENCY_CHECKER_TAG);){
                this.counts.accept((CountsVisitor)checker, cursorTracer);
            }
        }
    }

    private void safeLoadTokens(NeoStores neoStores) {
        try (PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(CONSISTENCY_CHECKER_TOKEN_LOADER_TAG);){
            this.tokenHolders.relationshipTypeTokens().setInitialTokens(RecordLoading.safeLoadTokens(neoStores.getRelationshipTypeTokenStore(), cursorTracer));
            this.tokenHolders.labelTokens().setInitialTokens(RecordLoading.safeLoadTokens(neoStores.getLabelTokenStore(), cursorTracer));
            this.tokenHolders.propertyKeyTokens().setInitialTokens(RecordLoading.safeLoadTokens(neoStores.getPropertyKeyTokenStore(), cursorTracer));
        }
    }

    private void cancel(String message) {
        if (!this.isCancelled()) {
            this.context.debug("Stopping: %s", message);
            this.context.cancel();
        }
    }

    private boolean isCancelled() {
        return this.context.isCancelled();
    }
}

