/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.RecordScanner;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class SequentialRecordScanner<RECORD>
extends RecordScanner<RECORD> {
    private static final String CONSISTENCY_SEQUENTIAL_SCANNER_TAG = "consistencySequentialScanner";
    private final PageCacheTracer pageCacheTracer;

    public SequentialRecordScanner(String name, Statistics statistics, int threads, BoundedIterable<RECORD> store, ProgressMonitorFactory.MultiPartBuilder builder, RecordProcessor<RECORD> processor, PageCacheTracer pageCacheTracer, IterableStore ... warmUpStores) {
        super(name, statistics, threads, store, builder, processor, warmUpStores);
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    protected void scan() {
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(CONSISTENCY_SEQUENTIAL_SCANNER_TAG);){
            for (Object record : this.store) {
                this.processor.process(record, cursorTracer);
                this.progress.add(1L);
            }
        }
    }
}

