/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyCheckTasks;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.CountsBuilderDecorator;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.TaskExecutor;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.newchecker.RecordStorageConsistencyChecker;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.store.CacheSmallStoresRecordAccess;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.logging.Log;
import org.neo4j.memory.MemoryTracker;

public class FullCheck {
    private static final String INDEX_STRUCTURE_CHECKER_TAG = "indexStructureChecker";
    private static final String CONSISTENCY_RECORD_ACCESSOR_TAG = "consistencyRecordAccessor";
    private static final String COUNT_STORE_CONSISTENCY_CHECKER_TAG = "countStoreConsistencyChecker";
    private final boolean useExperimentalChecker;
    private final Config config;
    private final boolean verbose;
    private final NodeBasedMemoryLimiter.Factory memoryLimit;
    private final ProgressMonitorFactory progressFactory;
    private final IndexSamplingConfig samplingConfig;
    private final int threads;
    private final Statistics statistics;
    private ConsistencyFlags flags;

    public FullCheck(ProgressMonitorFactory progressFactory, Statistics statistics, int threads, ConsistencyFlags consistencyFlags, Config config, boolean verbose, NodeBasedMemoryLimiter.Factory memoryLimit) {
        this.statistics = statistics;
        this.threads = threads;
        this.progressFactory = progressFactory;
        this.flags = consistencyFlags;
        this.samplingConfig = new IndexSamplingConfig(config);
        this.config = config;
        this.useExperimentalChecker = (Boolean)config.get(GraphDatabaseInternalSettings.experimental_consistency_checker);
        this.verbose = verbose;
        this.memoryLimit = memoryLimit;
    }

    public ConsistencySummaryStatistics execute(PageCache pageCache, DirectStoreAccess stores, ThrowingSupplier<CountsStore, IOException> countsSupplier, IndexAccessors.IndexAccessorLookup indexAccessorLookup, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, Log log) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport(new InconsistencyMessageLogger(log), summary);
        CountsStore countsStore = this.getCountsStore(countsSupplier, log, summary);
        this.execute(pageCache, stores, report, countsStore, indexAccessorLookup, pageCacheTracer, memoryTracker);
        if (!summary.isConsistent()) {
            log.warn("Inconsistencies found: " + summary);
        }
        return summary;
    }

    private void checkCountsStoreConsistency(InconsistencyReport report, CountsBuilderDecorator countsBuilder, RecordAccess records, CountsStore countsStore, PageCacheTracer pageCacheTracer) {
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(COUNT_STORE_CONSISTENCY_CHECKER_TAG);){
            if (this.flags.isCheckGraph() && countsStore != CountsStore.NULL_INSTANCE) {
                countsBuilder.checkCounts((CountsAccessor)countsStore, new ConsistencyReporter(records, report, pageCacheTracer), this.progressFactory, cursorTracer);
            }
        }
    }

    private CountsStore getCountsStore(ThrowingSupplier<CountsStore, IOException> countsSupplier, Log log, ConsistencySummaryStatistics summary) {
        CountsStore countsStore = CountsStore.NULL_INSTANCE;
        if (this.flags.isCheckGraph() || this.flags.isCheckIndexStructure()) {
            try {
                countsStore = (CountsStore)countsSupplier.get();
            }
            catch (Exception e) {
                log.error("Counts store is missing, broken or of an older format and will not be consistency checked", (Throwable)e);
                summary.update(RecordType.COUNTS, 1, 0);
            }
        }
        return countsStore;
    }

    void execute(PageCache pageCache, DirectStoreAccess directStoreAccess, InconsistencyReport report, CountsStore countsStore, IndexAccessors.IndexAccessorLookup indexAccessorLookup, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) throws ConsistencyCheckIncompleteException {
        block15: {
            try (IndexAccessors indexes = new IndexAccessors(directStoreAccess.indexes(), directStoreAccess.nativeStores().getRawNeoStores(), this.samplingConfig, indexAccessorLookup, pageCacheTracer, directStoreAccess.tokenHolders().lookupWithIds());){
                if (!((Boolean)this.config.get(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store)).booleanValue() && this.flags.isCheckRelationshipTypeScanStore()) {
                    report.warning("Consistency checker was configured to validate consistency of relationship type scan store, but this auxiliary store is not enabled and can therefore not be validated.");
                    report.updateSummary(RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, 0, 1);
                    this.flags = new ConsistencyFlags(this.flags.isCheckGraph(), this.flags.isCheckIndexes(), this.flags.isCheckIndexStructure(), this.flags.isCheckLabelScanStore(), false, this.flags.isCheckPropertyOwners());
                }
                if (this.flags.isCheckIndexStructure()) {
                    FullCheck.consistencyCheckIndexStructure(directStoreAccess.labelScanStore(), directStoreAccess.relationshipTypeScanStore(), directStoreAccess.indexStatisticsStore(), countsStore, indexes, this.allIdGenerators(directStoreAccess), report, this.progressFactory, pageCacheTracer);
                }
                if (!this.useExperimentalChecker) {
                    DefaultCacheAccess cacheAccess = new DefaultCacheAccess(DefaultCacheAccess.defaultByteArray(directStoreAccess.nativeStores().getNodeStore().getHighId(), memoryTracker), this.statistics.getCounts(), this.threads);
                    RecordAccess recordAccess = FullCheck.recordAccess(directStoreAccess.nativeStores(), cacheAccess, pageCacheTracer);
                    OwnerCheck ownerCheck = new OwnerCheck(this.flags.isCheckPropertyOwners(), new DynamicStore[0]);
                    CountsBuilderDecorator countsBuilder = new CountsBuilderDecorator(directStoreAccess.nativeStores());
                    CheckDecorator.ChainCheckDecorator decorator = new CheckDecorator.ChainCheckDecorator(ownerCheck, countsBuilder);
                    ConsistencyReporter reporter = new ConsistencyReporter(recordAccess, report, ConsistencyReporter.NO_MONITOR, pageCacheTracer);
                    StoreAccess nativeStores = directStoreAccess.nativeStores();
                    StoreProcessor processEverything = new StoreProcessor(decorator, reporter, Stage.SEQUENTIAL_FORWARD, cacheAccess);
                    ProgressMonitorFactory.MultiPartBuilder progress = this.progressFactory.multipleParts("Full Consistency Check");
                    MultiPassStore.Factory multiPass = new MultiPassStore.Factory(decorator, recordAccess, cacheAccess, report, ConsistencyReporter.NO_MONITOR, pageCacheTracer);
                    ConsistencyCheckTasks taskCreator = new ConsistencyCheckTasks(progress, processEverything, nativeStores, this.statistics, cacheAccess, directStoreAccess.labelScanStore(), directStoreAccess.relationshipTypeScanStore(), indexes, multiPass, reporter, this.threads, pageCacheTracer);
                    List<ConsistencyCheckerTask> tasks = taskCreator.createTasksForFullCheck(this.flags.isCheckLabelScanStore(), this.flags.isCheckRelationshipTypeScanStore(), this.flags.isCheckIndexes(), this.flags.isCheckGraph());
                    progress.build();
                    TaskExecutor.execute(tasks, decorator::prepare);
                    this.checkCountsStoreConsistency(report, countsBuilder, recordAccess, countsStore, pageCacheTracer);
                    ownerCheck.scanForOrphanChains(this.progressFactory);
                    break block15;
                }
                try (RecordStorageConsistencyChecker checker = new RecordStorageConsistencyChecker(pageCache, directStoreAccess.nativeStores().getRawNeoStores(), countsStore, directStoreAccess.labelScanStore(), directStoreAccess.relationshipTypeScanStore(), indexes, report, this.progressFactory, this.config, this.threads, this.verbose, this.flags, this.memoryLimit, pageCacheTracer, memoryTracker);){
                    checker.check();
                }
            }
            catch (Exception e) {
                throw new ConsistencyCheckIncompleteException(e);
            }
        }
    }

    private List<IdGenerator> allIdGenerators(DirectStoreAccess directStoreAccess) {
        ArrayList<IdGenerator> idGenerators = new ArrayList<IdGenerator>();
        directStoreAccess.idGeneratorFactory().visit(idGenerators::add);
        return idGenerators;
    }

    private static RecordAccess recordAccess(StoreAccess store, CacheAccess cacheAccess, PageCacheTracer pageCacheTracer) {
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(CONSISTENCY_RECORD_ACCESSOR_TAG);){
            CacheSmallStoresRecordAccess cacheSmallStoresRecordAccess = new CacheSmallStoresRecordAccess(new DirectRecordAccess(store, cacheAccess), (PropertyKeyTokenRecord[])FullCheck.readAllRecords(PropertyKeyTokenRecord.class, (RecordStore)store.getPropertyKeyTokenStore(), (PageCursorTracer)cursorTracer), (RelationshipTypeTokenRecord[])FullCheck.readAllRecords(RelationshipTypeTokenRecord.class, (RecordStore)store.getRelationshipTypeTokenStore(), (PageCursorTracer)cursorTracer), (LabelTokenRecord[])FullCheck.readAllRecords(LabelTokenRecord.class, (RecordStore)store.getLabelTokenStore(), (PageCursorTracer)cursorTracer));
            return cacheSmallStoresRecordAccess;
        }
    }

    private static void consistencyCheckIndexStructure(LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, IndexStatisticsStore indexStatisticsStore, CountsStore countsStore, IndexAccessors indexes, List<IdGenerator> idGenerators, InconsistencyReport report, ProgressMonitorFactory progressMonitorFactory, PageCacheTracer pageCacheTracer) {
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(INDEX_STRUCTURE_CHECKER_TAG);){
            long schemaIndexCount = Iterables.count(indexes.onlineRules());
            long additionalCount = 4L;
            long idGeneratorsCount = idGenerators.size();
            long totalCount = schemaIndexCount + 4L + idGeneratorsCount;
            ProgressListener listener = progressMonitorFactory.singlePart("Index structure consistency check", totalCount);
            listener.started();
            FullCheck.consistencyCheckNonSchemaIndexes(report, listener, labelScanStore, relationshipTypeScanStore, indexStatisticsStore, countsStore, idGenerators, cursorTracer);
            FullCheck.consistencyCheckSchemaIndexes(indexes, report, listener, cursorTracer);
            listener.done();
        }
    }

    private static void consistencyCheckNonSchemaIndexes(InconsistencyReport report, ProgressListener listener, LabelScanStore labelScanStore, RelationshipTypeScanStore relationshipTypeScanStore, IndexStatisticsStore indexStatisticsStore, CountsStore countsStore, List<IdGenerator> idGenerators, PageCursorTracer cursorTracer) {
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)labelScanStore, RecordType.LABEL_SCAN_DOCUMENT, cursorTracer);
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)relationshipTypeScanStore, RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, cursorTracer);
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)indexStatisticsStore, RecordType.INDEX_STATISTICS, cursorTracer);
        FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)countsStore, RecordType.COUNTS, cursorTracer);
        for (IdGenerator idGenerator : idGenerators) {
            FullCheck.consistencyCheckSingleCheckable(report, listener, (ConsistencyCheckable)idGenerator, RecordType.ID_STORE, cursorTracer);
        }
    }

    private static void consistencyCheckSingleCheckable(InconsistencyReport report, ProgressListener listener, ConsistencyCheckable checkable, RecordType recordType, PageCursorTracer cursorTracer) {
        ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(report, recordType);
        ReporterFactory proxyFactory = new ReporterFactory((InvocationHandler)handler);
        checkable.consistencyCheck(proxyFactory, cursorTracer);
        handler.updateSummary();
        listener.add(1L);
    }

    private static void consistencyCheckSchemaIndexes(IndexAccessors indexes, InconsistencyReport report, ProgressListener listener, PageCursorTracer cursorTracer) {
        ArrayList<IndexDescriptor> rulesToRemove = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor onlineRule : indexes.onlineRules()) {
            ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(report, RecordType.INDEX);
            ReporterFactory reporterFactory = new ReporterFactory((InvocationHandler)handler);
            IndexAccessor accessor = indexes.accessorFor(onlineRule);
            if (!accessor.consistencyCheck(reporterFactory, cursorTracer)) {
                rulesToRemove.add(onlineRule);
            }
            handler.updateSummary();
            listener.add(1L);
        }
        for (IndexDescriptor toRemove : rulesToRemove) {
            indexes.remove(toRemove);
        }
    }

    private static <T extends AbstractBaseRecord> T[] readAllRecords(Class<T> type, RecordStore<T> store, PageCursorTracer cursorTracer) {
        AbstractBaseRecord[] records = (AbstractBaseRecord[])Array.newInstance(type, (int)store.getHighId());
        for (int i = 0; i < records.length; ++i) {
            records[i] = store.getRecord((long)i, store.newRecord(), RecordLoad.FORCE, cursorTracer);
        }
        return records;
    }
}

