/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class PendingReferenceCheck<REFERENCED extends AbstractBaseRecord> {
    private CheckerEngine engine;
    private final ComparativeRecordChecker checker;

    PendingReferenceCheck(CheckerEngine engine, ComparativeRecordChecker checker) {
        this.engine = engine;
        this.checker = checker;
    }

    public synchronized String toString() {
        if (this.engine == null) {
            return String.format("CompletedReferenceCheck{%s}", this.checker);
        }
        return ConsistencyReporter.pendingCheckToString(this.engine, this.checker);
    }

    public void checkReference(REFERENCED referenced, RecordAccess records, PageCursorTracer cursorTracer) {
        ConsistencyReporter.dispatchReference(this.engine(), this.checker, referenced, records, cursorTracer);
    }

    public void checkDiffReference(REFERENCED oldReferenced, REFERENCED newReferenced, RecordAccess records, PageCursorTracer cursorTracer) {
        ConsistencyReporter.dispatchChangeReference(this.engine(), this.checker, oldReferenced, newReferenced, records, cursorTracer);
    }

    public synchronized void skip() {
        if (this.engine != null) {
            ConsistencyReporter.dispatchSkip(this.engine);
            this.engine = null;
        }
    }

    private synchronized CheckerEngine engine() {
        if (this.engine == null) {
            throw new IllegalStateException("Reference has already been checked.");
        }
        try {
            CheckerEngine checkerEngine = this.engine;
            return checkerEngine;
        }
        finally {
            this.engine = null;
        }
    }
}

