/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipInUseWithCorrectRelationshipTypeCheck<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport>
implements ComparativeRecordChecker<RECORD, RelationshipRecord, REPORT> {
    private final long[] indexRelationshipTypes;

    public RelationshipInUseWithCorrectRelationshipTypeCheck(long[] expectedEntityTokenIds) {
        this.indexRelationshipTypes = NodeInUseWithCorrectLabelsCheck.sortAndDeduplicate(expectedEntityTokenIds);
    }

    @Override
    public void checkReference(RECORD record, RelationshipRecord relationshipRecord, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (relationshipRecord.inUse()) {
            long type = relationshipRecord.getType();
            if (Arrays.binarySearch(this.indexRelationshipTypes, type) < 0) {
                for (long indexRelationshipType : this.indexRelationshipTypes) {
                    ((ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport)engine.report()).relationshipDoesNotHaveExpectedRelationshipType(relationshipRecord, indexRelationshipType);
                }
            }
        } else {
            ((ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport)engine.report()).relationshipNotInUse(relationshipRecord);
        }
    }
}

