/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Iterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.index.label.AllEntriesLabelScanReader;
import org.neo4j.internal.index.label.NodeLabelRange;

class GapFreeAllEntriesLabelScanReader
implements AllEntriesLabelScanReader {
    private final AllEntriesLabelScanReader nodeLabelRanges;
    private final long highId;

    GapFreeAllEntriesLabelScanReader(AllEntriesLabelScanReader nodeLabelRanges, long highId) {
        this.nodeLabelRanges = nodeLabelRanges;
        this.highId = highId;
    }

    public long maxCount() {
        return this.nodeLabelRanges.maxCount();
    }

    public void close() throws Exception {
        this.nodeLabelRanges.close();
    }

    public int rangeSize() {
        return this.nodeLabelRanges.rangeSize();
    }

    public Iterator<NodeLabelRange> iterator() {
        return new GapFillingIterator(this.nodeLabelRanges.iterator(), (this.highId - 1L) / (long)this.nodeLabelRanges.rangeSize(), this.nodeLabelRanges.rangeSize());
    }

    private static class GapFillingIterator
    extends PrefetchingIterator<NodeLabelRange> {
        private final long highestRangeId;
        private final Iterator<NodeLabelRange> source;
        private final long[][] emptyRangeData;
        private NodeLabelRange nextFromSource;
        private long currentRangeId = -1L;

        GapFillingIterator(Iterator<NodeLabelRange> nodeLabelRangeIterator, long highestRangeId, int rangeSize) {
            this.highestRangeId = highestRangeId;
            this.source = nodeLabelRangeIterator;
            this.emptyRangeData = new long[rangeSize][];
        }

        protected NodeLabelRange fetchNextOrNull() {
            while (true) {
                if (this.nextFromSource != null) {
                    if (this.currentRangeId + 1L == this.nextFromSource.id()) {
                        ++this.currentRangeId;
                        return this.nextFromSource;
                    }
                    if (this.currentRangeId < this.nextFromSource.id()) {
                        return new NodeLabelRange(++this.currentRangeId, this.emptyRangeData);
                    }
                }
                if (this.source.hasNext()) {
                    this.nextFromSource = this.source.next();
                    continue;
                }
                if (this.currentRangeId >= this.highestRangeId) break;
                this.nextFromSource = new NodeLabelRange(this.highestRangeId, this.emptyRangeData);
            }
            return null;
        }
    }
}

