/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.consistency.repair.RelationshipChainExplorer;
import org.neo4j.consistency.repair.RelationshipNodeField;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class OwningNodeRelationshipChain {
    private final RelationshipChainExplorer relationshipChainExplorer;
    private final RecordStore<NodeRecord> nodeStore;
    private final NodeRecord nodeRecord;

    public OwningNodeRelationshipChain(RelationshipChainExplorer relationshipChainExplorer, RecordStore<NodeRecord> nodeStore) {
        this.relationshipChainExplorer = relationshipChainExplorer;
        this.nodeStore = nodeStore;
        this.nodeRecord = (NodeRecord)nodeStore.newRecord();
    }

    public RecordSet<RelationshipRecord> findRelationshipChainsThatThisRecordShouldBelongTo(RelationshipRecord relationship) {
        RecordSet<RelationshipRecord> records = new RecordSet<RelationshipRecord>();
        for (RelationshipNodeField field : RelationshipNodeField.values()) {
            long nodeId = field.get(relationship);
            this.nodeStore.getRecord(nodeId, (AbstractBaseRecord)this.nodeRecord, RecordLoad.FORCE);
            records.addAll(this.relationshipChainExplorer.followChainFromNode(nodeId, this.nodeRecord.getNextRel()));
        }
        return records;
    }
}

