/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.newchecker.DynamicNodeLabelsCache;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.store.synthetic.CountsEntry;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.OffHeapLongArray;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.recordstorage.RelationshipCounter;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class CountsState
implements AutoCloseable {
    private static final long COUNT_VISITED_MARK = 0x4000000000000000L;
    private final long highLabelId;
    private final long highRelationshipTypeId;
    private final long highNodeId;
    private final CacheAccess cacheAccess;
    private final OffHeapLongArray nodeCounts;
    private final ConcurrentMap<CountsKey, AtomicLong> nodeCountsStray = new ConcurrentHashMap<CountsKey, AtomicLong>();
    private final LongArray relationshipLabelCounts;
    private final LongArray relationshipWildcardCounts;
    private final ConcurrentMap<CountsKey, AtomicLong> relationshipCountsStray = new ConcurrentHashMap<CountsKey, AtomicLong>();
    private final DynamicNodeLabelsCache dynamicNodeLabelsCache;

    CountsState(NeoStores neoStores, CacheAccess cacheAccess) {
        this(neoStores.getLabelTokenStore().getHighId(), neoStores.getRelationshipTypeTokenStore().getHighId(), neoStores.getNodeStore().getHighId(), cacheAccess);
    }

    CountsState(long highLabelId, long highRelationshipTypeId, long highNodeId, CacheAccess cacheAccess) {
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.highNodeId = highNodeId;
        this.cacheAccess = cacheAccess;
        NumberArrayFactory arrayFactory = NumberArrayFactory.OFF_HEAP;
        this.nodeCounts = (OffHeapLongArray)arrayFactory.newLongArray(highLabelId + 1L, 0L);
        this.relationshipLabelCounts = arrayFactory.newLongArray(RelationshipCounter.labelsCountsLength((long)highLabelId, (long)highRelationshipTypeId), 0L);
        this.relationshipWildcardCounts = arrayFactory.newLongArray(RelationshipCounter.wildcardCountsLength((long)highRelationshipTypeId), 0L);
        this.dynamicNodeLabelsCache = new DynamicNodeLabelsCache();
    }

    @Override
    public void close() {
        this.nodeCounts.close();
        this.relationshipLabelCounts.close();
        this.relationshipWildcardCounts.close();
        this.dynamicNodeLabelsCache.close();
    }

    RelationshipCounter instantiateRelationshipCounter() {
        return new RelationshipCounter(this.nodeLabelsLookup(), this.highLabelId, this.highRelationshipTypeId, this.relationshipWildcardCounts, this.relationshipLabelCounts, (array, index) -> ((OffHeapLongArray)array).getAndAdd(index, 1L));
    }

    long cacheDynamicNodeLabels(long[] labelIds) {
        return this.dynamicNodeLabelsCache.put(labelIds);
    }

    void clearDynamicNodeLabelsCache() {
        this.dynamicNodeLabelsCache.clear();
    }

    RelationshipCounter.NodeLabelsLookup nodeLabelsLookup() {
        return new RelationshipCounter.NodeLabelsLookup(){
            private final CacheAccess.Client cacheAccessClient;
            private long[] labelsHolder;
            {
                this.cacheAccessClient = CountsState.this.cacheAccess.client();
                this.labelsHolder = new long[20];
            }

            public long[] nodeLabels(long nodeId) {
                if (nodeId >= CountsState.this.highNodeId) {
                    return PrimitiveLongCollections.EMPTY_LONG_ARRAY;
                }
                boolean hasSingleLabel = this.cacheAccessClient.getBooleanFromCache(nodeId, 6);
                long labelField = this.cacheAccessClient.getFromCache(nodeId, 1);
                if (hasSingleLabel) {
                    this.labelsHolder[0] = labelField;
                    this.labelsHolder[1] = -1L;
                    return this.labelsHolder;
                }
                boolean hasInlinedLabels = this.cacheAccessClient.getBooleanFromCache(nodeId, 4);
                return hasInlinedLabels ? InlineNodeLabels.parseInlined((long)labelField) : CountsState.this.dynamicNodeLabelsCache.get(labelField, this.labelsHolder);
            }
        };
    }

    void incrementNodeLabel(int label, long increment) {
        if (this.isValidLabelId(label)) {
            this.nodeCounts.getAndAdd(this.labelIdArrayPos(label), increment);
        } else {
            this.nodeCountsStray.computeIfAbsent(CountsKey.nodeKey((long)label), k -> new AtomicLong()).addAndGet(increment);
        }
    }

    private boolean isValidLabelId(int label) {
        return label == -1 || label >= 0 && (long)label < this.highLabelId;
    }

    void incrementRelationshipTypeCounts(RelationshipCounter counter, RelationshipRecord relationship) {
        counter.processRelationshipTypeCounts(relationship, (s, t, e) -> this.relationshipCountsStray.computeIfAbsent(CountsKey.relationshipKey((long)s, (long)t, (long)e), k -> new AtomicLong()).incrementAndGet());
    }

    void incrementRelationshipNodeCounts(RelationshipCounter counter, RelationshipRecord relationship, boolean processStartNode, boolean processEndNode) {
        counter.processRelationshipNodeCounts(relationship, (s, t, e) -> this.relationshipCountsStray.computeIfAbsent(CountsKey.relationshipKey((long)s, (long)t, (long)e), k -> new AtomicLong()).incrementAndGet(), processStartNode, processEndNode);
    }

    private static boolean hasVisitedCountMark(long countValue) {
        return (countValue & 0x4000000000000000L) != 0L;
    }

    private static long markCountVisited(long countValue) {
        return countValue | 0x4000000000000000L;
    }

    private static long unmarkCountVisited(long countValue) {
        return countValue & 0xBFFFFFFFFFFFFFFFL;
    }

    CountsChecker checker(final ConsistencyReporter reporter) {
        return new CountsChecker(){
            RelationshipCounter relationshipCounter;
            {
                this.relationshipCounter = CountsState.this.instantiateRelationshipCounter();
            }

            public void visitNodeCount(int labelId, long count) {
                if (CountsState.this.isValidLabelId(labelId)) {
                    long pos = CountsState.this.labelIdArrayPos(labelId);
                    long expected = CountsState.unmarkCountVisited(CountsState.this.nodeCounts.get(pos));
                    if (expected != count) {
                        reporter.forCounts(new CountsEntry(CountsKey.nodeKey((long)labelId), count)).inconsistentNodeCount(expected);
                    }
                    CountsState.this.nodeCounts.set(pos, CountsState.markCountVisited(expected));
                } else {
                    AtomicLong expected = (AtomicLong)CountsState.this.nodeCountsStray.remove(CountsKey.nodeKey((long)labelId));
                    if (expected != null) {
                        if (expected.longValue() != count) {
                            reporter.forCounts(new CountsEntry(CountsKey.nodeKey((long)labelId), count)).inconsistentNodeCount(expected.longValue());
                        }
                    } else {
                        reporter.forCounts(new CountsEntry(CountsKey.nodeKey((long)labelId), count)).inconsistentNodeCount(0L);
                    }
                }
            }

            public void visitRelationshipCount(int startLabelId, int relTypeId, int endLabelId, long count) {
                CountsKey countsKey = CountsKey.relationshipKey((long)startLabelId, (long)relTypeId, (long)endLabelId);
                if (this.relationshipCounter.isValid(startLabelId, relTypeId, endLabelId)) {
                    long expected = CountsState.unmarkCountVisited(this.relationshipCounter.get(startLabelId, relTypeId, endLabelId));
                    if (expected != count) {
                        reporter.forCounts(new CountsEntry(countsKey, count)).inconsistentRelationshipCount(expected);
                    }
                    this.relationshipCounter.set(startLabelId, relTypeId, endLabelId, CountsState.markCountVisited(expected));
                } else {
                    AtomicLong expected = (AtomicLong)CountsState.this.relationshipCountsStray.remove(countsKey);
                    if (expected != null) {
                        if (expected.longValue() != count) {
                            reporter.forCounts(new CountsEntry(countsKey, count)).inconsistentRelationshipCount(expected.longValue());
                        }
                    } else {
                        reporter.forCounts(new CountsEntry(countsKey, count)).inconsistentRelationshipCount(0L);
                    }
                }
            }

            @Override
            public void close() {
                int labelId = 0;
                while ((long)labelId < CountsState.this.highLabelId) {
                    long count2 = CountsState.this.nodeCounts.get((long)labelId);
                    if (!CountsState.hasVisitedCountMark(count2) && count2 > 0L) {
                        reporter.forCounts(new CountsEntry(CountsKey.nodeKey((long)labelId), 0L)).inconsistentNodeCount(count2);
                    }
                    ++labelId;
                }
                int start = -1;
                while ((long)start < CountsState.this.highLabelId) {
                    int end = -1;
                    while ((long)end < CountsState.this.highLabelId) {
                        int type = -1;
                        while ((long)type < CountsState.this.highRelationshipTypeId) {
                            long count3;
                            if (!(start != -1 && end != -1 || CountsState.hasVisitedCountMark(count3 = this.relationshipCounter.get(start, type, end)) || count3 <= 0L)) {
                                reporter.forCounts(new CountsEntry(CountsKey.relationshipKey((long)start, (long)type, (long)end), 0L)).inconsistentRelationshipCount(count3);
                            }
                            ++type;
                        }
                        ++end;
                    }
                    ++start;
                }
                CountsState.this.nodeCountsStray.forEach((countsKey, count) -> reporter.forCounts(new CountsEntry((CountsKey)countsKey, count.get())));
                CountsState.this.relationshipCountsStray.forEach((countsKey, count) -> reporter.forCounts(new CountsEntry((CountsKey)countsKey, count.get())));
            }
        };
    }

    private long labelIdArrayPos(int labelId) {
        return labelId == -1 ? this.highLabelId : (long)labelId;
    }

    static interface CountsChecker
    extends CountsVisitor,
    AutoCloseable {
        @Override
        public void close();
    }
}

