/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public abstract class CacheTask
extends ConsistencyCheckerTask {
    protected final Stage stage;
    protected final CacheAccess cacheAccess;

    public CacheTask(Stage stage, CacheAccess cacheAccess) {
        super("CacheTask-" + stage, Statistics.NONE, 1);
        this.stage = stage;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void run() {
        if (this.stage.getCacheSlotSizes().length > 0) {
            this.cacheAccess.setCacheSlotSizes(this.stage.getCacheSlotSizes());
        }
        this.processCache();
    }

    protected abstract void processCache();

    public static class CheckNextRel
    extends CacheTask {
        private final StoreAccess storeAccess;
        private final StoreProcessor storeProcessor;

        public CheckNextRel(Stage stage, CacheAccess cacheAccess, StoreAccess storeAccess, StoreProcessor storeProcessor) {
            super(stage, cacheAccess);
            this.storeAccess = storeAccess;
            this.storeProcessor = storeProcessor;
        }

        @Override
        protected void processCache() {
            RecordStore nodeStore = this.storeAccess.getNodeStore();
            CacheAccess.Client client = this.cacheAccess.client();
            long highId = nodeStore.getHighId();
            for (long nodeId = 0L; nodeId < highId; ++nodeId) {
                NodeRecord node;
                if (client.getFromCache(nodeId, 2) != 0L || !(node = (NodeRecord)nodeStore.getRecord(nodeId, (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.FORCE)).inUse() || node.isDense()) continue;
                this.storeProcessor.processNode((RecordStore<NodeRecord>)nodeStore, node);
            }
        }
    }

    public static class CacheNextRel
    extends CacheTask {
        private final ResourceIterable<NodeRecord> nodes;

        public CacheNextRel(Stage stage, CacheAccess cacheAccess, ResourceIterable<NodeRecord> nodes) {
            super(stage, cacheAccess);
            this.nodes = nodes;
        }

        @Override
        protected void processCache() {
            this.cacheAccess.clearCache();
            long[] fields = new long[]{-1L, 1L, 0L};
            CacheAccess.Client client = this.cacheAccess.client();
            try (ResourceIterator nodeRecords = this.nodes.iterator();){
                while (nodeRecords.hasNext()) {
                    NodeRecord node = (NodeRecord)nodeRecords.next();
                    if (!node.inUse()) continue;
                    fields[0] = node.getNextRel();
                    client.putToCache(node.getId(), fields);
                }
            }
        }
    }
}

