/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public interface CheckDecorator {
    public static final CheckDecorator NONE = new Adapter();

    public void prepare();

    public OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> decorateNodeChecker(OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> var1);

    public OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> decorateRelationshipChecker(OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> var1);

    public RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> decoratePropertyChecker(RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> var1);

    public RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> decoratePropertyKeyTokenChecker(RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> var1);

    public RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> decorateRelationshipTypeTokenChecker(RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> var1);

    public RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> decorateLabelTokenChecker(RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> var1);

    public RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> decorateRelationshipGroupChecker(RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> var1);

    public static class ChainCheckDecorator
    implements CheckDecorator {
        private final CheckDecorator[] decorators;

        public ChainCheckDecorator(CheckDecorator ... decorators) {
            this.decorators = decorators;
        }

        @Override
        public void prepare() {
            for (CheckDecorator decorator : this.decorators) {
                decorator.prepare();
            }
        }

        @Override
        public OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> decorateNodeChecker(OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
            for (CheckDecorator decorator : this.decorators) {
                checker = decorator.decorateNodeChecker(checker);
            }
            return checker;
        }

        @Override
        public OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> decorateRelationshipChecker(OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
            for (CheckDecorator decorator : this.decorators) {
                checker = decorator.decorateRelationshipChecker(checker);
            }
            return checker;
        }

        @Override
        public RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> decoratePropertyChecker(RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
            for (CheckDecorator decorator : this.decorators) {
                checker = decorator.decoratePropertyChecker(checker);
            }
            return checker;
        }

        @Override
        public RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> decoratePropertyKeyTokenChecker(RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
            for (CheckDecorator decorator : this.decorators) {
                checker = decorator.decoratePropertyKeyTokenChecker(checker);
            }
            return checker;
        }

        @Override
        public RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> decorateRelationshipTypeTokenChecker(RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
            for (CheckDecorator decorator : this.decorators) {
                checker = decorator.decorateRelationshipTypeTokenChecker(checker);
            }
            return checker;
        }

        @Override
        public RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> decorateLabelTokenChecker(RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
            for (CheckDecorator decorator : this.decorators) {
                checker = decorator.decorateLabelTokenChecker(checker);
            }
            return checker;
        }

        @Override
        public RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> decorateRelationshipGroupChecker(RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
            for (CheckDecorator decorator : this.decorators) {
                checker = decorator.decorateRelationshipGroupChecker(checker);
            }
            return checker;
        }
    }

    public static class Adapter
    implements CheckDecorator {
        @Override
        public void prepare() {
        }

        @Override
        public OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> decorateNodeChecker(OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
            return checker;
        }

        @Override
        public OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> decorateRelationshipChecker(OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
            return checker;
        }

        @Override
        public RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> decoratePropertyChecker(RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
            return checker;
        }

        @Override
        public RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> decoratePropertyKeyTokenChecker(RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
            return checker;
        }

        @Override
        public RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> decorateRelationshipTypeTokenChecker(RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
            return checker;
        }

        @Override
        public RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> decorateLabelTokenChecker(RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
            return checker;
        }

        @Override
        public RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> decorateRelationshipGroupChecker(RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
            return checker;
        }
    }
}

