/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.commandline.arguments.common.OptionalCanonicalPath;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;

public class CheckConsistencyCommand
implements AdminCommand {
    public static final String CHECK_GRAPH = "check-graph";
    public static final String CHECK_INDEXES = "check-indexes";
    public static final String CHECK_LABEL_SCAN_STORE = "check-label-scan-store";
    public static final String CHECK_PROPERTY_OWNERS = "check-property-owners";
    private static final Arguments arguments = new Arguments().withDatabase().withArgument((NamedArgument)new OptionalCanonicalPath("backup", "/path/to/backup", "", "Path to backup to check consistency of. Cannot be used together with --database.")).withArgument((NamedArgument)new OptionalBooleanArg("verbose", false, "Enable verbose output.")).withArgument((NamedArgument)new OptionalCanonicalPath("report-dir", "directory", ".", "Directory to write report file in.")).withArgument((NamedArgument)new OptionalCanonicalPath("additional-config", "config-file-path", "", "Configuration file to supply additional configuration in. This argument is DEPRECATED.")).withArgument((NamedArgument)new OptionalBooleanArg("check-graph", true, "Perform checks between nodes, relationships, properties, types and tokens.")).withArgument((NamedArgument)new OptionalBooleanArg("check-indexes", true, "Perform checks on indexes.")).withArgument((NamedArgument)new OptionalBooleanArg("check-label-scan-store", true, "Perform checks on the label scan store.")).withArgument((NamedArgument)new OptionalBooleanArg("check-property-owners", false, "Perform additional checks on property ownership. This check is *very* expensive in time and memory."));
    private final Path homeDir;
    private final Path configDir;
    private final OutsideWorld outsideWorld;
    private final ConsistencyCheckService consistencyCheckService;

    public CheckConsistencyCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this(homeDir, configDir, outsideWorld, new ConsistencyCheckService());
    }

    public CheckConsistencyCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld, ConsistencyCheckService consistencyCheckService) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
        this.consistencyCheckService = consistencyCheckService;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        boolean checkPropertyOwners;
        boolean checkLabelScanStore;
        boolean checkIndexes;
        boolean checkGraph;
        Path reportDir;
        Optional additionalConfigFile;
        boolean verbose;
        Optional backupPath;
        String database;
        try {
            database = arguments.parse(args).get("database");
            backupPath = arguments.getOptionalPath("backup");
            verbose = arguments.getBoolean("verbose");
            additionalConfigFile = arguments.getOptionalPath("additional-config");
            reportDir = (Path)arguments.getOptionalPath("report-dir").orElseThrow(() -> new IllegalArgumentException("report-dir must be a valid path"));
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        if (backupPath.isPresent()) {
            if (arguments.has("database")) {
                throw new IncorrectUsage("Only one of '--database' and '--backup' can be specified.");
            }
            if (!((Path)backupPath.get()).toFile().isDirectory()) {
                throw new CommandFailed(String.format("Specified backup should be a directory: %s", backupPath.get()));
            }
        }
        Config config = CheckConsistencyCommand.loadNeo4jConfig(this.homeDir, this.configDir, database, this.loadAdditionalConfig(additionalConfigFile));
        try {
            checkGraph = arguments.has(CHECK_GRAPH) ? arguments.getBoolean(CHECK_GRAPH) : ((Boolean)config.get(ConsistencyCheckSettings.consistency_check_graph)).booleanValue();
            checkIndexes = arguments.has(CHECK_INDEXES) ? arguments.getBoolean(CHECK_INDEXES) : ((Boolean)config.get(ConsistencyCheckSettings.consistency_check_indexes)).booleanValue();
            checkLabelScanStore = arguments.has(CHECK_LABEL_SCAN_STORE) ? arguments.getBoolean(CHECK_LABEL_SCAN_STORE) : ((Boolean)config.get(ConsistencyCheckSettings.consistency_check_label_scan_store)).booleanValue();
            checkPropertyOwners = arguments.has(CHECK_PROPERTY_OWNERS) ? arguments.getBoolean(CHECK_PROPERTY_OWNERS) : ((Boolean)config.get(ConsistencyCheckSettings.consistency_check_property_owners)).booleanValue();
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            ConsistencyCheckService.Result consistencyCheckResult;
            File storeDir = backupPath.map(Path::toFile).orElse((File)config.get(GraphDatabaseSettings.database_path));
            this.checkDbState(storeDir, config);
            ZoneId logTimeZone = ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
            ProgressMonitorFactory progressMonitorFactory = ProgressMonitorFactory.NONE;
            if (System.console() != null) {
                progressMonitorFactory = ProgressMonitorFactory.textual((OutputStream)System.out);
            }
            if (!(consistencyCheckResult = this.consistencyCheckService.runFullConsistencyCheck(storeDir, config, progressMonitorFactory, (LogProvider)FormattedLogProvider.withZoneId((ZoneId)logTimeZone).toOutputStream((OutputStream)System.out), (FileSystemAbstraction)fileSystem, verbose, reportDir.toFile(), new ConsistencyFlags(checkGraph, checkIndexes, checkLabelScanStore, checkPropertyOwners))).isSuccessful()) {
                throw new CommandFailed(String.format("Inconsistencies found. See '%s' for details.", consistencyCheckResult.reportFile()));
            }
        }
        catch (IOException | ConsistencyCheckIncompleteException e) {
            throw new CommandFailed("Consistency checking failed." + e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> loadAdditionalConfig(Optional<Path> additionalConfigFile) {
        if (additionalConfigFile.isPresent()) {
            try {
                return MapUtil.load((File)additionalConfigFile.get().toFile());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read configuration file [%s]", additionalConfigFile), e);
            }
        }
        return new HashMap<String, String>();
    }

    private void checkDbState(File storeDir, Config additionalConfiguration) throws CommandFailed {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (Config)additionalConfiguration);){
            RecoveryRequiredChecker requiredChecker = new RecoveryRequiredChecker((FileSystemAbstraction)fileSystem, pageCache, additionalConfiguration, new Monitors());
            if (requiredChecker.isRecoveryRequiredAt(storeDir)) {
                throw new CommandFailed(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database before running the consistency check.", "To perform recovery please start database and perform clean shutdown."}));
            }
        }
        catch (IOException e) {
            this.outsideWorld.stdErrLine("Failure when checking for recovery state: '%s', continuing as normal.%n" + e.getMessage());
        }
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName, Map<String, String> additionalConfig) {
        additionalConfig.put(GraphDatabaseSettings.active_database.name(), databaseName);
        return Config.fromFile((Path)configDir.resolve("neo4j.conf")).withHome(homeDir).withConnectorsDisabled().withSettings(additionalConfig).build();
    }

    public static Arguments arguments() {
        return arguments;
    }
}

