/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neo4j.consistency.ConsistencyReportLog;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.lucene.LuceneLabelScanStoreBuilder;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ConsistencyCheckService {
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose) throws ConsistencyCheckIncompleteException, IOException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), verbose);
    }

    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose) throws ConsistencyCheckIncompleteException, IOException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, verbose, this.defaultReportDir(tuningConfiguration, storeDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose, File reportDir) throws ConsistencyCheckIncompleteException, IOException {
        Log log = logProvider.getLog(this.getClass());
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, tuningConfiguration, PageCacheTracer.NULL, logProvider.getLog(PageCache.class));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            Result result = this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose, reportDir);
            return result;
        }
        finally {
            try {
                pageCache.close();
            }
            catch (Exception e) {
                log.error("Failure during shutdown of the page cache", (Throwable)e);
            }
        }
    }

    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose, this.defaultReportDir(tuningConfiguration, storeDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, File reportDir) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        Log log = logProvider.getLog(this.getClass());
        Config consistencyCheckerConfig = tuningConfiguration.with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}), new Class[0]);
        StoreFactory factory = new StoreFactory(storeDir, consistencyCheckerConfig, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), pageCache, fileSystem, logProvider);
        File reportFile = this.chooseReportPath(reportDir);
        ConsistencyReportLog reportLog = new ConsistencyReportLog(Suppliers.lazySingleton(() -> {
            try {
                return new PrintWriter(Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)reportFile, (boolean)true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        try (NeoStores neoStores = factory.openAllNeoStores();){
            LabelScanStore labelScanStore = null;
            try {
                StoreAccess storeAccess;
                Statistics statistics;
                NeoStoreIndexStoreView indexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, neoStores);
                OperationalMode operationalMode = OperationalMode.single;
                labelScanStore = new LuceneLabelScanStoreBuilder(storeDir, (IndexStoreView)indexStoreView, fileSystem, consistencyCheckerConfig, operationalMode, logProvider).build();
                LuceneSchemaIndexProvider indexes = new LuceneSchemaIndexProvider(fileSystem, DirectoryFactory.PERSISTENT, storeDir, logProvider, consistencyCheckerConfig, operationalMode);
                int numberOfThreads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
                AccessStatistics stats = new AccessStatistics();
                if (verbose) {
                    statistics = new VerboseStatistics(stats, new DefaultCounts(numberOfThreads), log);
                    storeAccess = new AccessStatsKeepingStoreAccess(neoStores, stats);
                } else {
                    statistics = Statistics.NONE;
                    storeAccess = new StoreAccess(neoStores);
                }
                storeAccess.initialize();
                DirectStoreAccess stores = new DirectStoreAccess(storeAccess, labelScanStore, (SchemaIndexProvider)indexes);
                FullCheck check = new FullCheck(tuningConfiguration, progressFactory, statistics, numberOfThreads);
                summary = check.execute(stores, (Log)new DuplicatingLog(new Log[]{log, reportLog}));
            }
            finally {
                try {
                    if (null != labelScanStore) {
                        labelScanStore.shutdown();
                    }
                }
                catch (IOException e) {
                    log.error("Failure during shutdown of label scan store", (Throwable)e);
                }
            }
        }
        if (!summary.isConsistent()) {
            log.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile.getPath()});
            return Result.failure(reportFile);
        }
        return Result.success(reportFile);
    }

    private File chooseReportPath(File reportDir) {
        return new File(reportDir, ConsistencyCheckService.defaultLogFileName(this.timestamp));
    }

    private File defaultReportDir(Config tuningConfiguration, File storeDir) {
        if (tuningConfiguration.get(GraphDatabaseSettings.neo4j_home) == null) {
            tuningConfiguration = tuningConfiguration.with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.neo4j_home.name(), storeDir.getAbsolutePath()}), new Class[0]);
        }
        return (File)tuningConfiguration.get(GraphDatabaseSettings.logs_directory);
    }

    private static String defaultLogFileName(Date date) {
        return String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date));
    }

    public static int defaultConsistencyCheckThreadsNumber() {
        return Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    }

    public static interface Result {
        public static Result failure(final File reportFile) {
            return new Result(){

                @Override
                public boolean isSuccessful() {
                    return false;
                }

                @Override
                public File reportFile() {
                    return reportFile;
                }
            };
        }

        public static Result success(final File reportFile) {
            return new Result(){

                @Override
                public boolean isSuccessful() {
                    return true;
                }

                @Override
                public File reportFile() {
                    return reportFile;
                }
            };
        }

        public boolean isSuccessful();

        public File reportFile();
    }
}

