/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class PackedMultiFieldCache {
    private final LongArray array;
    private LongBitsManipulator slots;
    private long[] initValues;

    public PackedMultiFieldCache(int ... slotSizes) {
        this(NumberArrayFactory.AUTO.newDynamicLongArray(1000000L, 0L), slotSizes);
    }

    public PackedMultiFieldCache(LongArray array, int ... slotSizes) {
        this.array = array;
        this.setSlotSizes(slotSizes);
    }

    public void put(long index, long ... values) {
        long field = 0L;
        for (int i = 0; i < values.length; ++i) {
            field = this.slots.set(field, i, values[i]);
        }
        this.array.set(index, field);
    }

    public void put(long index, int slot, long value) {
        long field = this.array.get(index);
        field = this.slots.set(field, slot, value);
        this.array.set(index, field);
    }

    public long get(long index, int slot) {
        return this.slots.get(this.array.get(index), slot);
    }

    public void setSlotSizes(int ... slotSizes) {
        this.slots = new LongBitsManipulator(slotSizes);
        this.initValues = PackedMultiFieldCache.getInitVals(slotSizes);
    }

    public void clear() {
        long length = this.array.length();
        for (long i = 0L; i < length; ++i) {
            this.clear(i);
        }
    }

    public void clear(long index) {
        this.put(index, this.initValues);
    }

    private static long[] getInitVals(int[] slotSizes) {
        long[] initVals = new long[slotSizes.length];
        for (int i = 0; i < initVals.length; ++i) {
            initVals[i] = PackedMultiFieldCache.isId(slotSizes, i) ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : 0L;
        }
        return initVals;
    }

    private static boolean isId(int[] slotSizes, int i) {
        return slotSizes[i] >= 35;
    }
}

