/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingObserver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.logging.InternalLog;

public class LocalConfig
extends Config {
    private final Config config;
    private Map<Setting<Object>, Collection<SettingChangeListener<Object>>> registeredListeners = new ConcurrentHashMap<Setting<Object>, Collection<SettingChangeListener<Object>>>();

    public LocalConfig(Config config) {
        this.config = config;
    }

    @Override
    public <T> void addListener(Setting<T> setting, SettingChangeListener<T> listener) {
        this.registeredListeners.computeIfAbsent((SettingImpl)setting, v -> new ConcurrentLinkedQueue()).add(listener);
        this.config.addListener(setting, listener);
    }

    @Override
    public <T> void removeListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Collection<SettingChangeListener<Object>> listeners = this.registeredListeners.get(setting);
        if (listeners != null) {
            listeners.remove(listener);
        }
        this.config.removeListener(setting, listener);
    }

    public void removeAllLocalListeners() {
        for (Map.Entry<Setting<Object>, Collection<SettingChangeListener<Object>>> settingListeners : this.registeredListeners.entrySet()) {
            Setting<Object> setting = settingListeners.getKey();
            Collection<SettingChangeListener<Object>> listeners = settingListeners.getValue();
            for (SettingChangeListener<Object> listener : listeners) {
                this.config.removeListener(setting, listener);
            }
        }
        this.registeredListeners = new ConcurrentHashMap<Setting<Object>, Collection<SettingChangeListener<Object>>>();
    }

    @Override
    public <T extends GroupSetting> Map<String, T> getGroups(Class<T> group) {
        return this.config.getGroups(group);
    }

    @Override
    public <T extends GroupSetting, U extends T> Map<Class<U>, Map<String, U>> getGroupsFromInheritance(Class<T> parentClass) {
        return this.config.getGroupsFromInheritance(parentClass);
    }

    @Override
    public <T> T get(Setting<T> setting) {
        return this.config.get(setting);
    }

    @Override
    public <T> T getDefault(Setting<T> setting) {
        return this.config.getDefault(setting);
    }

    @Override
    public <T> T getStartupValue(Setting<T> setting) {
        return this.config.getStartupValue(setting);
    }

    @Override
    public <T> Config.ValueSource getValueSource(Setting<T> setting) {
        return this.config.getValueSource(setting);
    }

    @Override
    public <T> SettingObserver<T> getObserver(Setting<T> setting) {
        return this.config.getObserver(setting);
    }

    @Override
    public <T> void setDynamic(Setting<T> setting, T value, String scope) {
        this.config.setDynamic(setting, value, scope);
    }

    @Override
    public <T> void setDynamicByUser(Setting<T> setting, T value, String scope) {
        this.config.setDynamicByUser(setting, value, scope);
    }

    @Override
    public <T> void set(Setting<T> setting, T value) {
        this.config.set(setting, value);
    }

    @Override
    public <T> void setIfNotSet(Setting<T> setting, T value) {
        this.config.setIfNotSet(setting, value);
    }

    @Override
    public boolean isExplicitlySet(Setting<?> setting) {
        return this.config.isExplicitlySet(setting);
    }

    @Override
    public String toString() {
        return this.config.toString();
    }

    @Override
    public String toString(boolean includeNullValues) {
        return this.config.toString(includeNullValues);
    }

    @Override
    public void setLogger(InternalLog log) {
        this.config.setLogger(log);
    }

    @Override
    public Map<Setting<Object>, Object> getValues() {
        return this.config.getValues();
    }

    @Override
    public Setting<Object> getSetting(String name) {
        return this.config.getSetting(name);
    }

    @Override
    public Map<String, Setting<Object>> getDeclaredSettings() {
        return this.config.getDeclaredSettings();
    }

    @Override
    public Object configStringLookup(String setting) {
        return this.config.configStringLookup(setting);
    }
}

