/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.ssl;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.GroupSettingHelper;
import org.neo4j.configuration.SettingBuilder;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.string.SecureString;

@PublicApi
public class SslPolicyConfig
implements GroupSetting {
    public final Setting<Boolean> enabled;
    @Description(value="The mandatory base directory for cryptographic objects of this policy. It is also possible to override each individual configuration with absolute paths.")
    public final Setting<Path> base_directory;
    @Description(value="Path to directory of CRLs (Certificate Revocation Lists) in PEM format.")
    public final Setting<Path> revoked_dir;
    @Description(value="Makes this policy trust all remote parties. Enabling this is not recommended and the trusted directory will be ignored.")
    public final Setting<Boolean> trust_all;
    @Description(value="Makes this policy trust expired certificates. Enabling will also allow the instance to use an expired certificate itself.")
    public final Setting<Boolean> trust_expired;
    @Description(value="Client authentication stance.")
    public final Setting<ClientAuth> client_auth;
    @Description(value="Restrict allowed TLS protocol versions.")
    public final Setting<List<String>> tls_versions;
    @Description(value="Restrict allowed ciphers. Valid values depend on JRE and SSL however some examples can be found here https://docs.oracle.com/en/java/javase/11/docs/specs/security/standard-names.html#jsse-cipher-suite-names")
    public final Setting<List<String>> ciphers;
    @Description(value="When true, this node will verify the hostname of every other instance it connects to by comparing the address it used to connect with it and the patterns described in the remote hosts public certificate Subject Alternative Names")
    public final Setting<Boolean> verify_hostname;
    @Description(value="Private PKCS#8 key in PEM format.")
    public final Setting<Path> private_key;
    @Description(value="The passphrase for the private key.")
    public final Setting<SecureString> private_key_password;
    @Description(value="X.509 certificate (chain) of this server in PEM format.")
    public final Setting<Path> public_certificate;
    @Description(value="Path to directory of X.509 certificates in PEM format for trusted parties.")
    public final Setting<Path> trusted_dir;
    private final SslPolicyScope scope;

    public static SslPolicyConfig forScope(SslPolicyScope scope) {
        return new SslPolicyConfig(scope.name());
    }

    private SslPolicyConfig(String scopeString) {
        this.scope = SslPolicyScope.fromName(scopeString);
        if (this.scope == null) {
            throw new IllegalArgumentException("SslPolicy can not be created for scope: " + scopeString);
        }
        this.enabled = this.getBuilder("enabled", SettingValueParsers.BOOL, Boolean.FALSE).build();
        this.base_directory = this.getBuilder("base_directory", SettingValueParsers.PATH, Path.of(this.scope.baseDir, new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
        this.revoked_dir = this.getBuilder("revoked_dir", SettingValueParsers.PATH, Path.of("revoked", new String[0])).setDependency(this.base_directory).build();
        this.trust_all = this.getBuilder("trust_all", SettingValueParsers.BOOL, false).build();
        this.trust_expired = this.getBuilder("trust_expired", SettingValueParsers.BOOL, true).build();
        this.client_auth = this.getBuilder("client_auth", SettingValueParsers.ofEnum(ClientAuth.class), this.scope.authDefault).build();
        this.tls_versions = this.getBuilder("tls_versions", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("TLSv1.2", "TLSv1.3")).build();
        this.ciphers = this.getBuilder("ciphers", SettingValueParsers.listOf(SettingValueParsers.STRING), null).build();
        this.verify_hostname = this.getBuilder("verify_hostname", SettingValueParsers.BOOL, false).build();
        this.private_key = this.getBuilder("private_key", SettingValueParsers.PATH, Path.of("private.key", new String[0])).setDependency(this.base_directory).build();
        this.private_key_password = this.getBuilder("private_key_password", SettingValueParsers.SECURE_STRING, null).build();
        this.public_certificate = this.getBuilder("public_certificate", SettingValueParsers.PATH, Path.of("public.crt", new String[0])).setDependency(this.base_directory).build();
        this.trusted_dir = this.getBuilder("trusted_dir", SettingValueParsers.PATH, Path.of("trusted", new String[0])).setDependency(this.base_directory).build();
    }

    public SslPolicyConfig() {
        this("testing");
    }

    @Override
    public String name() {
        return this.scope.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String getPrefix() {
        return "dbms.ssl.policy";
    }

    public SslPolicyScope getScope() {
        return this.scope;
    }

    private <T> SettingBuilder<T> getBuilder(String suffix, SettingValueParser<T> parser, T defaultValue) {
        return GroupSettingHelper.getBuilder(this.getPrefix(), this.name(), suffix, parser, defaultValue);
    }
}

