/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.pagecache;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBuffer;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.buffer.NativeIOBuffer;
import org.neo4j.memory.MemoryTracker;

public class ConfigurableIOBufferFactory
implements IOBufferFactory {
    private final Config config;
    private final MemoryTracker memoryTracker;

    public ConfigurableIOBufferFactory(Config config, MemoryTracker memoryTracker) {
        this.config = config;
        this.memoryTracker = memoryTracker;
    }

    public NativeIOBuffer createBuffer() {
        return this.config.get(GraphDatabaseSettings.pagecache_buffered_flush_enabled) != false ? new ConfigurableIOBuffer(this.config, this.memoryTracker) : DISABLED_BUFFER_FACTORY.createBuffer();
    }
}

