/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import inet.ipaddr.IPAddressString;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.memory.HeapEstimatorCacheConfig;

public class GraphDatabaseInternalSettings
implements SettingsDeclaration {
    @Internal
    @Description(value="Enable use of experimental Cypher versions.")
    public static final Setting<Boolean> enable_experimental_cypher_versions = SettingImpl.newBuilder("internal.dbms.cypher.enable_experimental_versions", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="A list of CIDR-notation IPv4 or IPv6 addresses to block when accessing URLs.This list is checked when LOAD CSV or apoc.load.json is called.")
    public static final Setting<List<IPAddressString>> cypher_ip_blocklist = SettingImpl.newBuilder("internal.dbms.cypher_ip_blocklist", SettingValueParsers.listOf(SettingValueParsers.CIDR_IP), List.of()).build();
    @Internal
    @Description(value="Path of the databases directory")
    public static final Setting<Path> databases_root_path = SettingImpl.newBuilder("internal.server.directories.databases.root", SettingValueParsers.PATH, Path.of("databases", new String[0])).setDependency(GraphDatabaseSettings.data_directory).immutable().build();
    @Internal
    @Description(value="Enable duplication of user log messages to debug log.")
    public static final Setting<Boolean> duplication_user_messages = SettingImpl.newBuilder("internal.server.logs.user.duplication_to_debug", SettingValueParsers.BOOL, true).immutable().build();
    @Internal
    @Description(value="Configure lucene partition size. This is mainly used to test partitioning behaviour without having to create Integer.MAX_VALUE indexed entities.")
    public static final Setting<Integer> lucene_max_partition_size = SettingImpl.newBuilder("internal.dbms.lucene.max_partition_size", SettingValueParsers.INT, null).build();
    @Internal
    @Description(value="Include additional information in deadlock descriptions.")
    public static final Setting<Boolean> lock_manager_verbose_deadlocks = SettingImpl.newBuilder("internal.dbms.lock_manager.verbose_deadlocks", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="Name of the tracer factory to be used. Current implementations are: null, default & verbose.")
    public static final Setting<String> tracer = SettingImpl.newBuilder("internal.dbms.tracer", SettingValueParsers.STRING, null).build();
    @Internal
    @Description(value="Print out the effective Neo4j configuration after startup.")
    public static final Setting<Boolean> dump_configuration = SettingImpl.newBuilder("internal.dbms.report_configuration", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Specifies if the consistency checker should stop when number of observed inconsistencies exceed the threshold. If the value is zero, all inconsistencies will be reported")
    public static final Setting<Integer> consistency_checker_fail_fast_threshold = SettingImpl.newBuilder("internal.consistency_checker.fail_fast_threshold", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Set this to specify the default runtime for the default language version.")
    public static final Setting<CypherRuntime> cypher_runtime = SettingImpl.newBuilder("internal.cypher.runtime", SettingValueParsers.ofEnum(CypherRuntime.class), CypherRuntime.DEFAULT).build();
    @Internal
    @Description(value="This is used for an optimisation in VarExpandCursor. For paths where the length of the path is below this threshold, the `selectionCursor` will be used to check if a relationship is unique in the path. When the threshold is reached a set will be used instead. If the threshold is set to -1 `selectionCursor` will be used no matter the length of the path.")
    public static final Setting<Integer> var_expand_relationship_id_set_threshold = SettingImpl.newBuilder("internal.cypher.var_expand_relationship_id_set_threshold", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(-1)).build();
    @Internal
    @Description(value="Choose the expression engine. The default is to only compile expressions that are hot, if 'COMPILED' is chosen all expressions will be compiled directly and if 'INTERPRETED' is chosen expressions will never be compiled.")
    public static final Setting<CypherExpressionEngine> cypher_expression_engine = SettingImpl.newBuilder("internal.cypher.expression_engine", SettingValueParsers.ofEnum(CypherExpressionEngine.class), CypherExpressionEngine.DEFAULT).build();
    @Internal
    @Description(value="The maximum size in bytes of methods generated for compiled expressions")
    public static final Setting<Integer> cypher_expression_compiled_method_limit = SettingImpl.newBuilder("internal.cypher.expression_method_limit", SettingValueParsers.INT, 8000).addConstraint(SettingConstraints.min(0)).addConstraint(SettingConstraints.max(65535)).build();
    @Internal
    @Description(value="Number of uses before an expression is considered for compilation")
    public static final Setting<Integer> cypher_expression_recompilation_limit = SettingImpl.newBuilder("internal.cypher.expression_recompilation_limit", SettingValueParsers.INT, 10).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Enable tracing of compilation in cypher.")
    public static final Setting<Boolean> cypher_compiler_tracing = SettingImpl.newBuilder("internal.cypher.compiler_tracing", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Large databases might change slowly, and so to prevent queries from never being replanned the divergence threshold set by dbms.cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by internal.cypher.replan_algorithm and will cause the threshold to reach the value set here once the time since the previous replanning has reached internal.cypher.target_replan_interval. Setting this value to higher than the dbms.cypher.statistics_divergence_threshold will cause the threshold to not decay over time.")
    public static final Setting<Double> query_statistics_divergence_target = SettingImpl.newBuilder("internal.cypher.statistics_divergence_target", SettingValueParsers.DOUBLE, 0.1).addConstraint(SettingConstraints.range(0.0, 1.0)).build();
    @Internal
    @Description(value="The planning strategy for selective path patterns, e.g. `MATCH ANY SHORTEST ...`.")
    public static final Setting<StatefulShortestPlanningMode> stateful_shortest_planning_mode = SettingImpl.newBuilder("internal.cypher.stateful_shortest_planning_mode", SettingValueParsers.ofEnum(StatefulShortestPlanningMode.class), StatefulShortestPlanningMode.CARDINALITY_HEURISTIC).build();
    @Internal
    @Description(value="Feature flag to decide when to plan an expandInto.")
    public static final Setting<PlanVarExpandInto> plan_var_expand_into = SettingImpl.newBuilder("internal.cypher.plan_var_expand_into", SettingValueParsers.ofEnum(PlanVarExpandInto.class), PlanVarExpandInto.SINGLE_ROW).build();
    @Internal
    @Description(value="Feature flag to enable/disable the rewriting of GPM Shortest patterns into legacy findShortest where conversions are possible")
    public static final Setting<Boolean> gpm_shortest_to_legacy_shortest_enabled = SettingImpl.newBuilder("internal.cypher.enable_shortest_to_legacy_shortest", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Any quantifier in a selective path pattern above this limit gets removed and instead expressed as a predicate. This is done to limit the size of the NFA. Note that for a QPP, the limit is divided by the number of relationships in the QPP. As an example, if this limit is set to 4, a QPP with 2 relationships and the quantifier {,2} will get rewritten.")
    public static final Setting<Integer> stateful_shortest_planning_rewrite_quantifiers_above = SettingImpl.newBuilder("internal.cypher.stateful_shortest_planning_rewrite_quantifiers_above", SettingValueParsers.INT, 100).build();
    @Internal
    @Description(value="The threshold when a warning is generated if a label scan is done after a load csv where the label has no index")
    public static final Setting<Long> query_non_indexed_label_warning_threshold = SettingImpl.newBuilder("internal.cypher.non_indexed_label_warning_threshold", SettingValueParsers.LONG, 10000L).build();
    @Internal
    @Description(value="To improve IDP query planning time, we can restrict the internal planning table size, triggering compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    public static final Setting<Integer> cypher_idp_solver_table_threshold = SettingImpl.newBuilder("internal.cypher.idp_solver_table_threshold", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(16)).build();
    @Internal
    @Description(value="To improve IDP query planning time, we can restrict the internal planning loop duration, triggering more frequent compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    public static final Setting<Long> cypher_idp_solver_duration_threshold = SettingImpl.newBuilder("internal.cypher.idp_solver_duration_threshold", SettingValueParsers.LONG, 1000L).addConstraint(SettingConstraints.min(10L)).build();
    @Internal
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by dbms.cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by internal.cypher.replan_algorithm and will cause the threshold to reach the value set by internal.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set here. Setting this value to less than the value of dbms.cypher.min_replan_interval will cause the threshold to not decay over time.")
    public static final Setting<Duration> cypher_replan_interval_target = SettingImpl.newBuilder("internal.cypher.target_replan_interval", SettingValueParsers.DURATION, Duration.ofHours(7L)).build();
    @Internal
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by dbms.cypher.statistics_divergence_threshold is configured to shrink over time using the algorithm set here. This will cause the threshold to reach the value set by internal.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set in internal.cypher.target_replan_interval. Setting the algorithm to 'none' will cause the threshold to not decay over time.")
    public static final Setting<CypherReplanAlgorithm> cypher_replan_algorithm = SettingImpl.newBuilder("internal.cypher.replan_algorithm", SettingValueParsers.ofEnum(CypherReplanAlgorithm.class), CypherReplanAlgorithm.DEFAULT).build();
    @Internal
    @Description(value="Set this to enable monitors in the Cypher runtime.")
    public static final Setting<Boolean> cypher_enable_runtime_monitors = SettingImpl.newBuilder("internal.cypher.enable_runtime_monitors", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Set this to enable tracer monitors in the Cypher query caches.")
    public static final Setting<Boolean> cypher_enable_query_cache_monitors = SettingImpl.newBuilder("internal.cypher.enable_query_cache_monitors", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable tracing of pipelined runtime scheduler.")
    public static final Setting<Boolean> enable_pipelined_runtime_trace = SettingImpl.newBuilder("internal.cypher.pipelined.enable_runtime_trace", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Path to the pipelined runtime scheduler trace. If 'stdOut' and tracing is on, will print to std out.")
    public static final Setting<Path> pipelined_scheduler_trace_filename = SettingImpl.newBuilder("internal.cypher.pipelined.runtime_trace_path", SettingValueParsers.PATH, Path.of("stdOut", new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Internal
    @Description(value="The size of batches in the pipelined runtime for queries which work with few rows.")
    public static final Setting<Integer> cypher_pipelined_batch_size_small = SettingImpl.newBuilder("internal.cypher.pipelined.batch_size_small", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(1)).build();
    @Internal
    @Description(value="The size of batches in the pipelined runtime for queries which work with many rows.")
    public static final Setting<Integer> cypher_pipelined_batch_size_big = SettingImpl.newBuilder("internal.cypher.pipelined.batch_size_big", SettingValueParsers.INT, 1024).addConstraint(SettingConstraints.min(1)).build();
    @Internal
    @Description(value="Maximum number of queries that the Cypher worker threads for the parallel runtime will start working on concurrently. If set to 0, a default value of `server.cypher.parallel.worker_limit` will be chosen.")
    public static final Setting<Integer> cypher_max_active_queries_count = SettingImpl.newBuilder("internal.cypher.max_number_of_active_queries", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).dynamic().build();
    @Internal
    @Description(value="Maximum number of cached thread execution contexts per query used by Cypher workers for the parallel runtime. If set to 0, a default value that is a multiple of `server.cypher.parallel.worker_limit` will be chosen. If not 0, it will be round up to minimum `server.cypher.parallel.worker_limit`, and round down to the nearest multiple of `server.cypher.parallel.worker_limit`. The default value should be good enough for most use cases,  but it can be tweaked based on the workload as a trade-off between performance and available memory.")
    public static final Setting<Integer> cypher_max_cached_worker_resources_count = SettingImpl.newBuilder("internal.cypher.max_number_of_cached_worker_resources", SettingValueParsers.INT, 0).build();
    @Internal
    @Description(value="Configures the time interval between Cypher query monitor checks. Determines how often monitor thread will check the query queue of the parallel runtime for timeouts. A duration of zero disables query monitor checks.")
    public static final Setting<Duration> cypher_query_monitor_check_interval = SettingImpl.newBuilder("internal.cypher.query_monitor_check_interval", SettingValueParsers.DURATION, Duration.ofSeconds(5L)).dynamic().build();
    @Internal
    @Description(value="Configures the timeout before queries that have ended (finished successfully, been cancelled or failed), but where the client is still waiting for cleanup to complete, are forcefully removed.")
    public static final Setting<Duration> cypher_query_pending_release_timeout = SettingImpl.newBuilder("internal.cypher.query_pending_release_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).dynamic().build();
    @Internal
    @Description(value="Enable or disable the parallel runtime. The parallel runtime is an experimental feature and is disabled by default.")
    public static final Setting<CypherParallelRuntimeSupport> cypher_parallel_runtime_support = SettingImpl.newBuilder("internal.cypher.parallel_runtime_support", SettingValueParsers.ofEnum(CypherParallelRuntimeSupport.class), CypherParallelRuntimeSupport.ALL).dynamic().build();
    @Internal
    @Description(value="Track memory allocations for queries executed with the parallel runtime")
    public static final Setting<Boolean> enable_parallel_runtime_memory_tracking = SettingImpl.newBuilder("internal.cypher.enable_parallel_runtime_memory_tracking", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="The worker management determines how the Cypher parallel runtime will distribute query execution work between multiple threads.")
    public static final Setting<CypherWorkerManagement> cypher_worker_management = SettingImpl.newBuilder("internal.cypher.worker_management", SettingValueParsers.ofEnum(CypherWorkerManagement.class), CypherWorkerManagement.DEFAULT).build();
    @Internal
    @Description(value="If set to true we can force source code generation by appending debug=generate_java_source to query")
    public static final Setting<Boolean> cypher_allow_source_generation = SettingImpl.newBuilder("internal.cypher.pipelined.allow_source_generation", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="For compiled execution, specialized code is generated and then executed. More optimizations such as operator fusion may apply. Operator fusion means that multiple operators such as for example AllNodesScan -> Filter -> ProduceResult can be compiled into a single specialized operator. This setting only applies to the pipelined and parallel runtime. Allowed values are \"default\" (the default, use compiled when applicable), \"compiled\" and \"interpreted\".")
    public static final Setting<CypherOperatorEngine> cypher_operator_engine = SettingImpl.newBuilder("internal.cypher.pipelined.operator_engine", SettingValueParsers.ofEnum(CypherOperatorEngine.class), CypherOperatorEngine.DEFAULT).build();
    @Internal
    @Description(value="The maximum size in bytes of methods generated for fused operators")
    public static final Setting<Integer> cypher_operator_compiled_method_limit = SettingImpl.newBuilder("internal.cypher.pipelined.method_limit", SettingValueParsers.INT, 65535).addConstraint(SettingConstraints.min(0)).addConstraint(SettingConstraints.max(65535)).build();
    @Internal
    @Description(value="Use interpreted pipes as a fallback for operators that do not have a specialized implementation in the pipelined runtime. Allowed values are \"disabled\", \"default\" (the default, use whitelisted_plans_only when applicable), \"whitelisted_plans_only\" and \"all\" (experimental). The default is to enable the use of a subset of whitelisted operators that are known to be supported, whereas \"all\" is an experimental option that enables the fallback to be used for all possible operators that are not known to be internal.")
    public static final Setting<CypherPipelinedInterpretedPipesFallback> cypher_pipelined_interpreted_pipes_fallback = SettingImpl.newBuilder("internal.cypher.pipelined_interpreted_pipes_fallback", SettingValueParsers.ofEnum(CypherPipelinedInterpretedPipesFallback.class), CypherPipelinedInterpretedPipesFallback.DEFAULT).build();
    @Internal
    @Description(value="The maximum number of operator fusions over pipelines (i.e. where an operator that would normally be considered pipeline-breaking, e.g. expand), that is considered before a pipeline break is forced.")
    public static final Setting<Integer> cypher_pipelined_operator_fusion_over_pipeline_limit = SettingImpl.newBuilder("internal.cypher.pipelined.operator_fusion_over_pipeline_limit", SettingValueParsers.INT, 8).build();
    @Internal
    @Description(value="The minimum number of operators to consider for fusion. If the number of fuseable operators in a pipeline is less than this value no fusion will be attempted.")
    public static final Setting<Integer> cypher_pipelined_operator_fusion_lower_limit = SettingImpl.newBuilder("internal.cypher.pipelined.operator_fusion_lower_limit", SettingValueParsers.INT, 2).build();
    @Internal
    @Description(value="Choose the Eager Analysis implementation")
    public static final Setting<EagerAnalysisImplementation> cypher_eager_analysis_implementation = SettingImpl.newBuilder("internal.cypher.eager_analysis_implementation", SettingValueParsers.ofEnum(EagerAnalysisImplementation.class), EagerAnalysisImplementation.LP).build();
    @Internal
    @Description(value="Enable fallback to updateStrategy=alwaysEager for LP eager analyzer")
    public static final Setting<Boolean> cypher_lp_eager_analysis_fallback_enabled = SettingImpl.newBuilder("internal.cypher.lp_eager_analysis_fallback_enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Enables extra SemanticFeature:s during cypher semantic checking")
    public static final Setting<Set<String>> cypher_enable_extra_semantic_features = SettingImpl.newBuilder("internal.cypher.enable_extra_semantic_features", SettingValueParsers.setOf(SettingValueParsers.STRING), Set.of()).build();
    @Internal
    @Description(value="Enable freeing memory of unused columns during Cypher query execution")
    public static final Setting<Boolean> cypher_free_memory_of_unused_columns = SettingImpl.newBuilder("internal.cypher.free_memory_of_unused_columns", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Max number of recent queries to collect in the data collector module. Will round down to the nearest power of two. The default number (8192 query invocations)  was chosen as a trade-off between getting a useful amount of queries, and not wasting too much heap. Even with a buffer full of unique queries, the estimated footprint lies in tens of MBs. If the buffer is full of cached queries, the retained size was measured to 265 kB. Setting this to 0 will disable data collection of queries completely.")
    public static final Setting<Integer> data_collector_max_recent_query_count = SettingImpl.newBuilder("internal.datacollector.max_recent_query_count", SettingValueParsers.INT, 8192).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Sets the upper limit for how much of the query text that will be retained by the query collector. For queries longer than the limit, only a prefix of size limit will be retained by the collector. Lowering this value will reduce the memory footprint of collected query invocations under loads with many queries with long query texts, which could occur for generated queries. The downside is that on retrieving queries by `db.stats.retrieve`, queries longer than this max size would be returned incomplete. Setting this to 0 will completely drop query texts from the collected queries.")
    public static final Setting<Integer> data_collector_max_query_text_size = SettingImpl.newBuilder("internal.datacollector.max_query_text_size", SettingValueParsers.INT, 10000).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Enable or disable the ability to create and drop databases.")
    public static final Setting<Boolean> block_create_drop_database = SettingImpl.newBuilder("internal.dbms.block_create_drop_database", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the ability to start and stop databases.")
    public static final Setting<Boolean> block_start_stop_database = SettingImpl.newBuilder("internal.dbms.block_start_stop_database", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the ability to alter databases.")
    public static final Setting<Boolean> block_alter_database = SettingImpl.newBuilder("internal.dbms.block_alter_database", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the ability to use remote aliases.")
    public static final Setting<Boolean> block_remote_alias = SettingImpl.newBuilder("internal.dbms.block_remote_alias", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the ability to perform server management.")
    public static final Setting<Boolean> block_server_management = SettingImpl.newBuilder("internal.dbms.block_server_management", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the ability to execute the `dbms.upgrade` procedure.")
    @Deprecated(since="5.9.0")
    public static final Setting<Boolean> block_upgrade_procedures = SettingImpl.newBuilder("internal.dbms.upgrade_restriction_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Configure if the database should create the default admin user.")
    public static final Setting<Boolean> create_default_user = SettingImpl.newBuilder("internal.dbms.create_default_user", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="The maximum amount of time to wait for the database to become available, when starting a new transaction.")
    public static final Setting<Duration> transaction_start_timeout = SettingImpl.newBuilder("internal.dbms.transaction_start_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(1L)).build();
    @Internal
    @Description(value="Location of the database scripts directory.")
    public static final Setting<Path> scripts_dir = SettingImpl.newBuilder("internal.server.directories.scripts", SettingValueParsers.PATH, Path.of("scripts", new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Internal
    @Description(value="Name of file containing commands to be run during initialization of the system database. The file should exists in the scripts directory in neo4j home directory.")
    public static final Setting<Path> system_init_file = SettingImpl.newBuilder("internal.dbms.init_file", SettingValueParsers.PATH, null).immutable().setDependency(scripts_dir).build();
    @Internal
    @Description(value="Maximum time to wait for active transaction completion when rotating counts store")
    public static final Setting<Duration> counts_store_rotation_timeout = SettingImpl.newBuilder("internal.dbms.counts_store_rotation_timeout", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).build();
    @Internal
    @Description(value="Set the maximum number of threads that can concurrently be used to sample indexes. Zero means unrestricted.")
    public static final Setting<Integer> index_sampling_parallelism = SettingImpl.newBuilder("internal.dbms.index_sampling.parallelism", SettingValueParsers.INT, 4).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Set the maximum number of concurrent index populations across system. This also limit the number of threads used to scan store. Note that multiple indexes can be populated by a single index population if they were created in the same transaction. Zero means unrestricted. ")
    public static final Setting<Integer> index_population_parallelism = SettingImpl.newBuilder("internal.dbms.index_population.parallelism", SettingValueParsers.INT, 2).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Set the number of threads used for each index population job. Those threads execute individual subtasks provided by index population main threads, see internal.dbms.index_population.parallelism.Zero means one thread per cpu core. Thus the maximum total number of index worker threads in the system is internal.dbms.index_population.workers * internal.dbms.index_population.parallelism.")
    public static final Setting<Integer> index_population_workers = SettingImpl.newBuilder("internal.dbms.index_population.workers", SettingValueParsers.INT, Integer.max(1, Runtime.getRuntime().availableProcessors() / 4)).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Set the frequency and offset for reporting index usage statistics.")
    public static final Setting<Duration> index_usage_report_frequency = SettingImpl.newBuilder("internal.dbms.index.usage_report_frequency", SettingValueParsers.DURATION, Duration.ofSeconds(10L)).addConstraint(SettingConstraints.resolution(ChronoUnit.SECONDS)).build();
    @Internal
    @Description(value="Set the frequency and offset for reporting the total index sizes. Zero means disabled.")
    public static final Setting<Duration> index_total_size_report_frequency = SettingImpl.newBuilder("internal.dbms.index.total_size_report_frequency", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.resolution(ChronoUnit.SECONDS)).build();
    @Internal
    @Description(value="If 'true', new database will be created without token indexes for labels and relationships.")
    public static final Setting<Boolean> skip_default_indexes_on_creation = SettingImpl.newBuilder("internal.dbms.index.skip_default_indexes_on_creation", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="If sent in index-provider in index create should be respected. Only for tests, latest should always be used")
    public static final Setting<Boolean> always_use_latest_index_provider = SettingImpl.newBuilder("internal.dbms.index.always_use_latest_index_provider", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="If `true`, Neo4j will abort recovery if any errors are encountered in the logical log. Setting this to `false` will allow Neo4j to restore as much as possible from the corrupted log files and ignore the rest, but, the integrity of the database might be compromised.")
    public static final Setting<Boolean> fail_on_corrupted_log_files = SettingImpl.newBuilder("internal.dbms.tx_log.fail_on_corrupted_log_files", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Specifies if engine should run cypher query based on a snapshot of accessed data. Query will be restarted in case if concurrent modification of data will be detected.")
    public static final Setting<Boolean> snapshot_query = SettingImpl.newBuilder("internal.dbms.query.snapshot", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Specifies number or retries that query engine will do to execute query based on stable accessed data snapshot before giving up.")
    public static final Setting<Integer> snapshot_query_retries = SettingImpl.newBuilder("internal.dbms.query.snapshot.retries", SettingValueParsers.INT, 5).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="Cypher keeps a cache of the conversion from logical plans to execution plans. This cache is mainly meant to avoid generating code multiple times if different queries use the same logical plan. Items are only evicted from the cache when all query caches are cleared, e.g. by calling `db.clearQueryCaches()`. The cache is allowed to grow up to this size. If the size is set to -1 (default), it will use the size configured for the query cache, that is `server.db.query_cache_size`Setting the size to 0 means disabling this cache.")
    public static final Setting<Integer> query_execution_plan_cache_size = SettingImpl.newBuilder("internal.dbms.query_execution_plan_cache_size", SettingValueParsers.INT, -1).addConstraint(SettingConstraints.min(-1)).build();
    @Internal
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that e.g a block size of 120 will hold a 60 character long string before overflowing into a second block. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    public static final Setting<Integer> string_block_size = SettingImpl.newBuilder("internal.dbms.block_size.strings", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    public static final Setting<Integer> array_block_size = SettingImpl.newBuilder("internal.dbms.block_size.array_properties", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Specifies the block size for storing labels exceeding in-lined space in node record. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    public static final Setting<Integer> label_block_size = SettingImpl.newBuilder("internal.dbms.block_size.labels", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Enable disable the GC stall monitor.")
    public static final Setting<Boolean> vm_pause_monitor_enabled = SettingImpl.newBuilder("internal.vm_pause_monitor.enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="VM pause monitor measurement duration")
    public static final Setting<Duration> vm_pause_monitor_measurement_duration = SettingImpl.newBuilder("internal.vm_pause_monitor.measurement_duration", SettingValueParsers.DURATION, Duration.ofMillis(200L)).build();
    @Internal
    @Description(value="Alert threshold for total pause time during one VM pause monitor measurement")
    public static final Setting<Duration> vm_pause_monitor_stall_alert_threshold = SettingImpl.newBuilder("internal.vm_pause_monitor.stall_alert_threshold", SettingValueParsers.DURATION, Duration.ofMillis(200L)).build();
    @Internal
    @Description(value="Create a heap dump just before the end of each query execution. The heap dump will be placed in log directory and the file name will contain the query id, to be correlated with an entry in the query log. Only live objects will be included to minimize the file size. ")
    public static final Setting<Boolean> log_queries_heap_dump_enabled = SettingImpl.newBuilder("internal.dbms.logs.query.heap_dump_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="Enables or disables logging of deprecation notifications to the structured query log.")
    public static final Setting<Boolean> log_queries_deprecation_notifications = SettingImpl.newBuilder("internal.dbms.logs.query.deprecation_notifications.enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="Specifies number of operations that batch inserter will try to group into one batch before flushing data into underlying storage.")
    public static final Setting<Integer> batch_inserter_batch_size = SettingImpl.newBuilder("internal.tools.batch_inserter.batch_size", SettingValueParsers.INT, 10000).build();
    @Internal
    @Description(value="Location of the auth store repository directory")
    public static final Setting<Path> auth_store_directory = SettingImpl.newBuilder("internal.server.directories.auth", SettingValueParsers.PATH, Path.of("dbms", new String[0])).immutable().setDependency(GraphDatabaseSettings.data_directory).build();
    @Internal
    @Description(value="Quiet period for netty shutdown")
    public static final Setting<Integer> netty_server_shutdown_quiet_period = SettingImpl.newBuilder("internal.dbms.bolt.netty_server_shutdown_quiet_period", SettingValueParsers.INT, 5).build();
    @Internal
    @Description(value="Timeout for netty shutdown")
    public static final Setting<Duration> netty_server_shutdown_timeout = SettingImpl.newBuilder("internal.dbms.bolt.netty_server_shutdown_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(15L)).build();
    @Internal
    @Description(value="Create an archive of an index before re-creating it if failing to load on startup.")
    public static final Setting<Boolean> archive_failed_index = SettingImpl.newBuilder("internal.dbms.index.archive_failed", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Forces smaller ID cache, in order to preserve memory.")
    public static final Setting<Boolean> force_small_id_cache = SettingImpl.newBuilder("internal.dbms.force_small_id_cache", SettingValueParsers.BOOL, Boolean.FALSE).build();
    @Internal
    @Description(value="Perform some data consistency checks on transaction apply")
    public static final Setting<Boolean> consistency_check_on_apply = SettingImpl.newBuilder("internal.dbms.storage.consistency_check_on_apply", SettingValueParsers.BOOL, Boolean.FALSE).build();
    @Internal
    @Description(value="Time interval of inactivity after which a driver will be closed.")
    public static final Setting<Duration> routing_driver_idle_timeout = SettingImpl.newBuilder("internal.dbms.routing.driver.timeout", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Internal
    @Description(value="Time interval between driver idleness check.")
    public static final Setting<Duration> routing_driver_idle_check_interval = SettingImpl.newBuilder("internal.dbms.routing.driver.idle_check_interval", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Internal
    @Description(value="Number of event loops used by drivers. Event loops are shared between drivers, so this is the total number of event loops created.\n Defaults to the number of available processors.")
    public static final Setting<Integer> routing_driver_event_loop_count = SettingImpl.newBuilder("internal.dbms.routing.driver.event_loop_count", SettingValueParsers.INT, Runtime.getRuntime().availableProcessors()).build();
    @Internal
    @Description(value="Enables logging of leaked driver session")
    public static final Setting<Boolean> routing_driver_log_leaked_sessions = SettingImpl.newBuilder("internal.dbms.routing.driver.logging.leaked_sessions", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Specifies the time after which a transaction marked for termination is logged as potentially leaked. A value of zero disables the check.")
    public static final Setting<Duration> transaction_termination_timeout = SettingImpl.newBuilder("internal.db.transaction.termination_timeout", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).dynamic().build();
    @Description(value="Specifies at which file size the checkpoint log will auto-rotate. Minimum accepted value is 1 KiB. ")
    @Internal
    public static final Setting<Long> checkpoint_logical_log_rotation_threshold = SettingImpl.newBuilder("internal.db.checkpoint_log.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)1L)).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)1L))).build();
    @Description(value="Number of checkpoint logs files to keep.")
    @Internal
    public static final Setting<Integer> checkpoint_logical_log_keep_threshold = SettingImpl.newBuilder("internal.db.checkpoint_log.rotation.keep.files", SettingValueParsers.INT, 3).addConstraint(SettingConstraints.range(2, 100)).build();
    @Internal
    @Description(value="Whether or not to dump system and database diagnostics. This takes a non-negligible amount of time to do and therefore test databases can disable this to reduce startup times")
    public static final Setting<Boolean> dump_diagnostics = SettingImpl.newBuilder("internal.dbms.dump_diagnostics", SettingValueParsers.BOOL, Boolean.TRUE).build();
    @Internal
    @Description(value="Whether or not to split diagnostics messages into multiple logged messages. Can be useful if there is a log message length limitation, as the diagnostics can be very long")
    public static final Setting<Boolean> split_diagnostics = SettingImpl.newBuilder("internal.dbms.split_diagnostics", SettingValueParsers.BOOL, Boolean.TRUE).build();
    @Internal
    @Description(value="Validate if transaction statements are properly closed")
    public static final Setting<Boolean> track_tx_statement_close = SettingImpl.newBuilder("internal.dbms.debug.track_tx_statement_close", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Trace open/close transaction statements")
    public static final Setting<Boolean> trace_tx_statements = SettingImpl.newBuilder("internal.dbms.debug.trace_tx_statement", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Validate if cursors are properly closed")
    public static final Setting<Boolean> track_cursor_close = SettingImpl.newBuilder("internal.dbms.debug.track_cursor_close", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Trace unclosed cursors")
    public static final Setting<Boolean> trace_cursors = SettingImpl.newBuilder("internal.dbms.debug.trace_cursors", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Reporting interval for page cache speed logging")
    public static final Setting<Duration> page_cache_tracer_speed_reporting_threshold = SettingImpl.newBuilder("internal.dbms.debug.page_cache_tracer_speed_reporting_threshold", SettingValueParsers.DURATION, Duration.ofSeconds(10L)).build();
    @Internal
    @Description(value="Logging information about recovered index samples")
    public static final Setting<Boolean> log_recover_index_samples = SettingImpl.newBuilder("internal.dbms.index.sampling.log_recovered_samples", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable asynchronous index sample recovery")
    public static final Setting<Boolean> async_recover_index_samples = SettingImpl.newBuilder("internal.dbms.index.sampling.async_recovery", SettingValueParsers.BOOL, true).immutable().build();
    @Internal
    @Description(value="Wait for asynchronous index sample recovery to finish")
    public static final Setting<Boolean> async_recover_index_samples_wait = SettingImpl.newBuilder("internal.dbms.index.sampling.async_recovery_wait", SettingValueParsers.BOOL, null).setDependency(async_recover_index_samples).build();
    @Internal
    @Description(value="Track heap memory allocations for transactions")
    public static final Setting<Boolean> enable_transaction_heap_allocation_tracking = SettingImpl.newBuilder("internal.dbms.enable_transaction_heap_allocation_tracking", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Chunk size for heap memory reservation from the memory pool")
    public static final Setting<Long> initial_transaction_heap_grab_size = SettingImpl.newBuilder("internal.dbms.initial_transaction_heap_grab_size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)2L)).immutable().build();
    @Internal
    @Description(value="Chunk size for heap memory reservation per worker from the transaction memory pool")
    public static final Setting<Long> initial_transaction_heap_grab_size_per_worker = SettingImpl.newBuilder("internal.dbms.initial_transaction_heap_grab_size_per_worker", SettingValueParsers.BYTES, ByteUnit.kibiBytes((long)128L)).build();
    @Internal
    @Description(value="Chunk size for maximum heap memory reservation per worker from the transaction memory pool")
    public static final Setting<Long> max_transaction_heap_grab_size_per_worker = SettingImpl.newBuilder("internal.dbms.max_transaction_heap_grab_size_per_worker", SettingValueParsers.BYTES, null).setDependency(initial_transaction_heap_grab_size).addConstraint(SettingConstraints.lessThanOrEqualLong(initial_transaction_heap_grab_size)).build();
    @Internal
    @Description(value="Default value whether or not to strictly prioritize ids from freelist, as opposed to allocating from high id.Given a scenario where there are multiple concurrent calls to allocating IDsand there are free ids on the freelist, some perhaps cached, some not. Thread noticing that there are no free ids cached will try to acquirescanner lock and if it succeeds it will perform a scan and place found free ids in the cache and return. Otherwise:   If `false`: thread will allocate from high id and return, to not block id allocation request.   If `true` : thread will await lock released and check cache afterwards. If no id is cached even then it will allocate from high id.")
    public static final Setting<Boolean> strictly_prioritize_id_freelist = SettingImpl.newBuilder("internal.dbms.strictly_prioritize_id_freelist", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Block/buffer size for index population")
    public static final Setting<Long> index_populator_block_size = SettingImpl.newBuilder("internal.dbms.index.populator_block_size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)1L)).addConstraint(SettingConstraints.min(20L)).addConstraint(SettingConstraints.max(Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="Merge factory for index population")
    public static final Setting<Integer> index_populator_merge_factor = SettingImpl.newBuilder("internal.dbms.index.populator_merge_factor", SettingValueParsers.INT, 8).build();
    @Internal
    @Description(value="Enable/disable logging for the id generator")
    public static final Setting<Boolean> id_generator_log_enabled = SettingImpl.newBuilder("internal.dbms.idgenerator.log.enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable/disable internal GBPTree log for structural changes for forensics purposes")
    public static final Setting<Boolean> gbptree_structure_log_enabled = SettingImpl.newBuilder("internal.dbms.debug.gbptree_structure_log_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Log file rotation threshold for id generator logging")
    public static final Setting<Long> id_generator_log_rotation_threshold = SettingImpl.newBuilder("internal.dbms.idgenerator.log.rotation_threshold", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)200L)).build();
    @Internal
    @Description(value="Log file prune threshold for id generator logging")
    public static final Setting<Duration> id_generator_log_prune_threshold = SettingImpl.newBuilder("internal.dbms.idgenerator.log.prune_threshold", SettingValueParsers.DURATION, Duration.ofDays(2L)).build();
    @Internal
    @Description(value="Print stack trace on failed native io buffer allocation")
    public static final Setting<Boolean> print_page_buffer_allocation_trace = SettingImpl.newBuilder("internal.dbms.debug.print_page_buffer_allocation_trace", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Printing debug information on index population")
    public static final Setting<Boolean> index_population_print_debug = SettingImpl.newBuilder("internal.dbms.index.population_print_debug", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Queue size for index population batched updates")
    public static final Setting<Integer> index_population_queue_threshold = SettingImpl.newBuilder("internal.dbms.index.population_queue_threshold", SettingValueParsers.INT, 20000).build();
    @Internal
    @Description(value="Max size for an index population batch")
    public static final Setting<Long> index_population_batch_max_byte_size = SettingImpl.newBuilder("internal.dbms.index.population_batch_max_byte_size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)10L)).addConstraint(SettingConstraints.max(Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="Timeout for configuration command evaluation, per command.")
    public static final Setting<Duration> config_command_evaluation_timeout = SettingImpl.newBuilder("internal.dbms.config.command_evaluation_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).build();
    @Internal
    @Description(value="Whether or not to do additional checks for locks when making changes as part of commit. This may be expensive to enable.")
    public static final Setting<Boolean> additional_lock_verification = SettingImpl.newBuilder("internal.dbms.extra_lock_verification", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Let the IO controller consider/ignore external IO")
    public static final Setting<Boolean> io_controller_consider_external_io = SettingImpl.newBuilder("internal.dbms.io.controller.consider.external.enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="The maximum number of cached entries in count store (based) stores ")
    public static final Setting<Integer> counts_store_max_cached_entries = SettingImpl.newBuilder("internal.dbms.memory.counts_store_max_cached_entries", SettingValueParsers.INT, 1000000).build();
    @Internal
    @Description(value="Whether or not to use multiple threads whilst performing recovery. Provides performance improvement for some workloads.")
    public static final Setting<Boolean> do_parallel_recovery = SettingImpl.newBuilder("internal.dbms.recovery.enable_parallelism", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Whether or not to log contents of data that is inconsistent when deleting it.")
    public static final Setting<Boolean> log_inconsistent_data_deletion = SettingImpl.newBuilder("internal.dbms.log_inconsistent_data_deletion", SettingValueParsers.BOOL, Boolean.FALSE).dynamic().build();
    @Internal
    @Description(value="Whether or database should switch to read only mode on disk space problems.")
    public static final Setting<Boolean> dynamic_read_only_failover = SettingImpl.newBuilder("internal.dbms.readonly.failover", SettingValueParsers.BOOL, Boolean.TRUE).dynamic().build();
    @Internal
    @Description(value="Feature flag to enable/disable planning of cached properties for entities. Disabling this can cause a regression in performance and can cause results to be returned out-of-order under concurrent updates.")
    public static final Setting<Boolean> planning_cache_properties_for_entities_enabled = SettingImpl.newBuilder("internal.cypher.planning_cache_properties_for_entities_enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Feature flag to enable/disable planning use of intersection scans.")
    public static final Setting<Boolean> planning_intersection_scans_enabled = SettingImpl.newBuilder("internal.cypher.planning_intersection_scans_enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Feature flag to enable/disable planning use of subtraction scans.")
    public static final Setting<Boolean> planning_subtraction_scans_enabled = SettingImpl.newBuilder("internal.cypher.planning_subtraction_scans_enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Limits the maximum amount of off-heap memory the consistency checker will allocate. The value is given as a factor between 0.1 .. 1 and will be multiplied with actual available memory to get the effectively available amount of memory taken into consideration")
    public static final Setting<Double> consistency_check_memory_limit_factor = SettingImpl.newBuilder("internal.consistency_checker.memory_limit_factor", SettingValueParsers.DOUBLE, 0.9).addConstraint(SettingConstraints.min(0.1)).addConstraint(SettingConstraints.max(1.0)).build();
    @Description(value="Allow database to use dedicated transaction appender writer thread.")
    @Internal
    public static final Setting<Boolean> dedicated_transaction_appender = SettingImpl.newBuilder("internal.dbms.tx.logs.dedicated.appender", SettingValueParsers.BOOL, Boolean.FALSE).build();
    @Internal
    @Description(value="Enable per page file metrics collection in a default page cache and cursor tracer.")
    public static final Setting<Boolean> per_file_metrics_counters = SettingImpl.newBuilder("internal.dbms.page.file.tracer", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enables sketching of next transaction log file in the background during reverse recovery.")
    public static final Setting<Boolean> pre_sketch_transaction_logs = SettingImpl.newBuilder("internal.dbms.tx_log.presketch", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enables using format versions that are still under development, which will trigger migration to them on start up. This setting is only useful for tests of incomplete format versions during their development for for testing upgrade itself.")
    public static final Setting<Boolean> include_versions_under_development = SettingImpl.newBuilder("internal.dbms.include_dev_format_versions", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="If set, the database will locate token index files in the old location and under the old name.This is just a temporary setting to be used when the relocation of these indexes is under development")
    public static final Setting<Boolean> use_old_token_index_location = SettingImpl.newBuilder("internal.dbms.use_old_token_index_location", SettingValueParsers.BOOL, false).build();
    @Description(value="Whether or not to do parallel index writes during online transaction application")
    @Internal
    public static final Setting<Boolean> parallel_index_updates_apply = SettingImpl.newBuilder("internal.dbms.parallel_index_updates_apply", SettingValueParsers.BOOL, false).build();
    @Description(value="Whether to offload buffered IDs for freeing to disk, rather than to keep them in memory")
    @Internal
    public static final Setting<Boolean> buffered_ids_offload = SettingImpl.newBuilder("internal.dbms.id_buffering.offload_to_disk", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Max number of processors used when upgrading the store. Defaults to the number of processors available to the JVM. There is a certain amount of minimum threads needed so for that reason there is no lower bound for this value. For optimal performance this value shouldn't be greater than the number of available processors.")
    public static final Setting<Integer> upgrade_processors = SettingImpl.newBuilder("internal.dbms.upgrade_max_processors", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).dynamic().build();
    @Internal
    @Description(value="Maximum size after which the planner will not attempt to plan the disjunction of predicates on a single variable as a distinct union.For example, given the following pattern: `()-[e:FOO|BAR|BAZ]->()`, the planner will attempt to plan a union of `e:Foo`, `e:Bar`, and `e:Baz`unless `internal.cypher.predicates_as_union_max_size` is less than 3.")
    public static final Setting<Integer> predicates_as_union_max_size = SettingImpl.newBuilder("internal.cypher.predicates_as_union_max_size", SettingValueParsers.INT, 255).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Enables creation of graph type dependent constraints")
    public static final Setting<Boolean> dependent_constraints_enabled = SettingImpl.newBuilder("internal.dbms.dependent_constraints_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enables usage of relationship endpoint label and node label existence constraints")
    public static final Setting<Boolean> relationship_endpoint_label_and_node_label_existence_constraints = SettingImpl.newBuilder("internal.dbms.relationship_endpoint_label_and_node_label_existence_constraints", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Set this to specify the literal extraction strategy")
    public static final Setting<ExtractLiteral> extract_literals = SettingImpl.newBuilder("internal.cypher.extract_literals", SettingValueParsers.ofEnum(ExtractLiteral.class), ExtractLiteral.ALWAYS).build();
    @Internal
    @Description(value="Use size of lists and strings of provided parameter values in planning")
    public static final Setting<Boolean> cypher_size_hint_parameters = SettingImpl.newBuilder("internal.cypher.use_parameter_size", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Multi versioned store transaction chunk size.")
    public static final Setting<Long> multi_version_transaction_chunk_size = SettingImpl.newBuilder("internal.db.multiversion.transaction.chunk.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)10L)).build();
    @Internal
    @Description(value="Terminate transaction validation as soon as validation page lock acquisition fails.")
    public static final Setting<Boolean> multi_version_transaction_validation_fail_fast = SettingImpl.newBuilder("internal.db.multiversion.transaction.validation.fail_fast", SettingValueParsers.BOOL, true).dynamic().build();
    @Internal
    @Description(value="Dump transaction validation page locks on multi versioned transaction failure.")
    public static final Setting<Boolean> multi_version_dump_transaction_validation_page_locks = SettingImpl.newBuilder("internal.db.multiversion.transaction.validation.locks.dump", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Dump transaction visibility boundaries in multi versioned database.")
    public static final Setting<Boolean> multi_version_dump_transaction_visibility_boundaries = SettingImpl.newBuilder("internal.db.multiversion.transaction.visibility.boundaries.dump", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Page Cache Warmer blocks database start until it's completed")
    public static final Setting<Boolean> pagecache_warmup_blocking = SettingImpl.newBuilder("internal.db.memory.pagecache.warmup.blocking_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="A feature toggle behind which change data capture feature is developed")
    public static final Setting<Boolean> change_data_capture = SettingImpl.newBuilder("internal.dbms.change_data_capture", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="A feature toggle behind which show setting feature is developed")
    public static final Setting<Boolean> show_setting = SettingImpl.newBuilder("internal.dbms.show_setting", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="A feature toggle behind which composable commands are developed")
    public static final Setting<Boolean> composable_commands = SettingImpl.newBuilder("internal.dbms.composable_commands", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="A feature toggle behind which graph types are developed")
    public static final Setting<Boolean> graph_type_enabled = SettingImpl.newBuilder("internal.dbms.graph_type", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="A feature toggle behind which out of disk space protection feature is developed")
    public static final Setting<Boolean> out_of_disk_space_protection = SettingImpl.newBuilder("internal.dbms.out_of_disk_space_protection", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Just to be used in tests: A way to indicate to fallback to latest dbms runtime component version. Can be needed when purposefully not initializing the system graph, but testing newer features")
    public static final Setting<Boolean> fallback_to_latest_runtime_version = SettingImpl.newBuilder("internal.dbms.fallback_to_latest_runtime_version", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Just to be used in tests: A way to set the latest dbms runtime component version. Can be useful for writing upgrade tests for coming versions")
    public static final Setting<Integer> latest_runtime_version = SettingImpl.newBuilder("internal.dbms.latest_runtime_version", SettingValueParsers.INT, null).build();
    @Internal
    @Description(value="Just to be used in tests: A way to set the latest kernel version. Can be useful for writing upgrade tests for coming versions")
    public static final Setting<Byte> latest_kernel_version = SettingImpl.newBuilder("internal.dbms.latest_kernel_version", SettingValueParsers.BYTE, null).build();
    @Internal
    @Description(value="Ask page cache to close memory allocator on shutdown to clear native memory allocated for page cache pages.\nWARNING: This setting is dangerous and must only be enabled if you completely confident that there are no leaked page cursors.\nOtherwise it can result in VM crashes\n")
    public static final Setting<Boolean> close_allocator_on_shutdown = SettingImpl.newBuilder("internal.dbms.page_cache_close_allocator_on_shutdown", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Size of the memory block used to allocate page cache memory. Default value calculated based on page cache size.")
    public static final Setting<Long> page_cache_allocation_grab_size = SettingImpl.newBuilder("internal.dbms.page_cache_allocator_block_size", SettingValueParsers.BYTES, null).addConstraint(SettingConstraints.min(1L)).build();
    @Internal
    @Description(value="Whether to allow a system graph upgrade to happen automatically (and the procedures becomes no-ops), or should upgrades be done via procedures. Default is true for both editions and all DBMS layouts.")
    @Deprecated(since="5.9.0")
    public static final Setting<Boolean> automatic_upgrade_enabled = SettingImpl.newBuilder("internal.dbms.automatic_upgrade.enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="The length of time to wait in the upgrade procedures for automatic upgrade to complete an upgrade in the background, before just returning 'upgrade pending'.")
    @Deprecated(since="5.9.0")
    public static final Setting<Duration> upgrade_procedure_wait_timeout = SettingImpl.newBuilder("internal.dbms.upgrade.procedure.wait_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).build();
    @Internal
    @Description(value="The size of remote read batches for SPD")
    public static final Setting<Integer> sharded_property_database_batch_size = SettingImpl.newBuilder("internal.dbms.sharded_property_database.batch_size", SettingValueParsers.INT, 8192).build();
    @Internal
    @Description(value="A feature toggle behind which composite queries are routed through the new query router stack")
    public static final Setting<Boolean> composite_queries_with_query_router = SettingImpl.newBuilder("internal.dbms.query_router.composite_queries", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Set to `true` to enable internal error tracing (Currently only Block format).")
    public static final Setting<Boolean> trace_internal_transaction_errors = SettingImpl.newBuilder("internal.db.transaction.trace_internal_errors", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Log whether the query plan served from one of the query caches.")
    public static final Setting<Boolean> log_query_cache_usage = SettingImpl.newBuilder("internal.dbms.logs.query.query_cache_usage", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="Log the hash of query cache key.")
    public static final Setting<Boolean> log_query_cache_key = SettingImpl.newBuilder("internal.dbms.logs.query.query_cache_key", SettingValueParsers.BOOL, true).dynamic().build();
    @Internal
    @Description(value="Log the hash of query cache key also in the plain text query log. The parent setting `internal.dbms.logs.query.query_cache_key` also has to be enabled for this setting to have effect.")
    public static final Setting<Boolean> log_query_cache_key_plain_text = SettingImpl.newBuilder("internal.dbms.logs.query.query_cache_key_plain_text", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="Log the classification of the error status.")
    public static final Setting<Boolean> log_status_classification = SettingImpl.newBuilder("internal.dbms.logs.query.log_status_classification", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="The maximum period of time to wait for changes to the transaction log (specifically to get the position after the last committed transaction). This is an upper bound as further subscriber requests will always lead to fetching the latest transaction details.")
    public static final Setting<Duration> cdc_log_change_max_refresh_interval = SettingImpl.newBuilder("internal.db.cdc.log_change_max_refresh_interval", SettingValueParsers.DURATION, Duration.ofSeconds(1L)).build();
    @Internal
    @Description(value="Multiversion degree store root mapping cache size.")
    public static final Setting<Long> multi_version_degreestore_mapping_cache_size = SettingImpl.newBuilder("internal.dbms.multiversion_degreestore_mapping_cache_size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)10L)).build();
    @Internal
    @Description(value="The reserved namespaces that are used for internal functionality of the DBMS. Procedures and UDFs in these namespaces will never be loaded, or compiled from disk.")
    public static final Setting<List<String>> reserved_procedure_namespaces = SettingImpl.newBuilder("internal.dbms.reserved_procedure_namespaces", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("date", "datetime", "duration", "localdatetime", "localtime", "time", "cdc.*", "date.*", "datetime.*", "db.*", "dbms.*", "duration.*", "graph.*", "internal.*", "localdatetime.*", "localtime.*", "time.*", "tx.*", "unsupported.*")).build();
    @Internal
    @Description(value="The non-reloadable namespaces for procedures that we know are not reloadable, such as APOC-core.")
    public static final Setting<List<String>> non_reloadable_procedure_namespaces = SettingImpl.newBuilder("internal.dbms.non_reloadable_procedure_namespaces", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("apoc.*", "aura.*", "gds.*")).build();
    @Internal
    @Description(value="Feature flag to enable/disable the use of soft references for Cypher query caches (Executable query and Logical plan caches only). The cache will consist of one part strongly referenced items and one part softly referenced items, which can be individually sized. Softly referenced objects can be cleared at any time by the garbage collector in response to memory demand. The total maximum number of entries per cache will be the sum of 'internal.memory.query_cache.strong.num_entries' and 'internal.server.memory.query_cache.soft.num_entries',The soft cache is experimental and disabled by default. ")
    public static final Setting<Boolean> cypher_soft_cache_enabled = SettingImpl.newBuilder("internal.cypher.enable_soft_query_cache", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Size of the query cache with strong references. This setting is only deciding cache size when `internal.cypher.enable_soft_query_cache` is set to `true`.")
    public static final Setting<Integer> query_cache_strong_size = SettingImpl.newBuilder("internal.server.memory.query_cache.strong_cache_num_entries", SettingValueParsers.INT, 200).addConstraint(SettingConstraints.min(0)).dynamic().build();
    @Internal
    @Description(value="Size of the query cache with soft references. This setting is only deciding cache size when `internal.cypher.enable_soft_query_cache` is set to `true`.")
    public static final Setting<Integer> query_cache_soft_size = SettingImpl.newBuilder("internal.server.memory.query_cache.soft_cache_num_entries", SettingValueParsers.INT, 800).addConstraint(SettingConstraints.min(0)).dynamic().build();
    @Internal
    @Description(value="Feature flag to enable/disable the ANTLR parser as opposed to Javacc. If changed dynamically, query caches need to be cleared for it to take effect.")
    public static final Setting<Boolean> cypher_parser_antlr_enabled = SettingImpl.newBuilder("internal.cypher.parser.antlr_enabled", SettingValueParsers.BOOL, true).dynamic().build();
    @Internal
    @Description(value="Time to wait before sending the first UDC ping.")
    public static final Setting<Long> udc_initial_delay_ms = SettingImpl.newBuilder("internal.dbms.usage_report.initial_delay_ms", SettingValueParsers.LONG, TimeUnit.MINUTES.toMillis(10L)).build();
    @Internal
    @Description(value="Interval of the UDC pings.")
    public static final Setting<Long> udc_report_interval_ms = SettingImpl.newBuilder("internal.dbms.usage_report.report_interval_ms", SettingValueParsers.LONG, TimeUnit.DAYS.toMillis(1L)).build();
    @Internal
    @Description(value="Enable/disable network communications for UDP pings, useful for testing purposes.")
    public static final Setting<Boolean> udc_network_enabled = SettingImpl.newBuilder("internal.dbms.usage_report.udc_network_enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Id controller maintenance interval")
    public static final Setting<Duration> id_controller_maintenance_interval = SettingImpl.newBuilder("internal.db.idcontroller.maintenance_interval", SettingValueParsers.DURATION, Duration.ofSeconds(1L)).build();
    @Internal
    @Description(value="Maximum time to download metadata when seeding metadata during CREATE DATABASE. It is recommended to keep this low, since a system transaction is kept open during this time.")
    public static final Setting<Duration> seed_with_metadata_timeout = SettingImpl.newBuilder("internal.dbms.seed_with_metadata_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(60L)).build();
    @Internal
    @Description(value="Choose the remote batch properties implementation")
    public static final Setting<RemoteBatchPropertiesImplementation> cypher_remote_batch_properties_implementation = SettingImpl.newBuilder("internal.cypher.remote_batch_properties_implementation", SettingValueParsers.ofEnum(RemoteBatchPropertiesImplementation.class), RemoteBatchPropertiesImplementation.REWRITER).build();
    @Internal
    @Description(value="Allow duplicated setting declarations when strict validation is enabled.")
    public static final Setting<Boolean> strict_config_validation_allow_duplicates = SettingImpl.newBuilder("internal.server.config.strict_validation.allow_duplicates.enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Push valid predicates into Remote Batch Properties")
    public static final Setting<Boolean> push_predicates_into_remote_batch_properties = SettingImpl.newBuilder("internal.cypher.push_predicates_into_remote_batch_properties", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enables returning the client address provided by a driver as the sole router in routing tables. This makes it easier for networking middleware to migrate workload to new Neo4j servers, or even a new DBMS.")
    public static final Setting<Boolean> client_provided_router_enabled = SettingImpl.newBuilder("internal.dbms.routing.client_provided_router_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="A list of prefixes to append to the client provided router address when the server cycles through addresses to force a routing table update.")
    public static final Setting<List<String>> client_provided_router_prefixes = SettingImpl.newBuilder("internal.dbms.routing.client_provided_router_prefixes", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("a", "b", "c", "d")).addConstraint(SettingConstraints.minSize(2)).build();
    @Internal
    @Description(value="The period of time for the server to wait between cycling client provided router address prefixes to force a routing table update.")
    public static final Setting<Duration> client_provided_router_prefix_rotation_period = SettingImpl.newBuilder("internal.dbms.routing.client_provided_router_rotation_period", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).addConstraint(SettingConstraints.range(Duration.ofSeconds(10L), Duration.ofDays(1L))).build();
    @Internal
    @Description(value="The suffix we expect on the client provided address in order to trigger the behaviour of client_provided_router_enabled and return said address as the sole router in routing tables.")
    public static final Setting<String> client_provided_router_suffix = SettingImpl.newBuilder("internal.dbms.routing.client_provided_address_suffix", SettingValueParsers.STRING, "endpoints.neo4j.io").build();
    @Internal
    @Description(value="Enforce index commands generation.")
    public static final Setting<Boolean> multiversion_index_commands_enabled = SettingImpl.newBuilder("internal.db.multiversion.index.commands.enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Enable background prefetch of the pages affected by transaction commands before applying them")
    public static final Setting<Boolean> prefetch_on_commit = SettingImpl.newBuilder("internal.dbms.prefetch_on_commit", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="The maximum amount of time to wait for terminated transactions to start closing before allowing initiated database shutdown to continue")
    public static final Setting<Duration> shutdown_terminated_transaction_wait_timeout = SettingImpl.newBuilder("internal.db.transaction.shutdown_terminated_transaction_wait_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(1L)).build();
    @Internal
    @Description(value="Enable the use of a heap estimator cache that can reduce heap usage overestimation of large objects  in some queries.")
    public static final Setting<HeapEstimatorCachePreset> heap_estimator_cache_preset = SettingImpl.newBuilder("internal.server.heap_estimator_cache.preset", SettingValueParsers.ofEnum(HeapEstimatorCachePreset.class), HeapEstimatorCachePreset.DEFAULT).dynamic().build();
    @Internal
    @Description(value="The maximum size of a heap estimator cache instance. This setting only takes effect in combination with 'internal.server.heap_estimator_cache.preset' set to 'custom'.")
    public static final Setting<Integer> heap_estimator_cache_size_limit = SettingImpl.newBuilder("internal.server.heap_estimator_cache.size_limit", SettingValueParsers.INT, 16).addConstraint(SettingConstraints.min(0)).dynamic().build();
    @Internal
    @Description(value="The estimated heap usage threshold in bytes for an object to be considered a large object by  the heap estimator cache. Only objects larger than this threshold will be considered for caching. This setting only takes effect in combination with 'internal.server.heap_estimator_cache.preset' set to 'custom'.")
    public static final Setting<Long> heap_estimator_cache_large_object_threshold = SettingImpl.newBuilder("internal.server.heap_estimator_cache.large_object_threshold", SettingValueParsers.BYTES, 65536L).addConstraint(SettingConstraints.min(0L)).dynamic().build();

    public static HeapEstimatorCacheConfig extractCustomHeapEstimatorCacheConfig(Config config) {
        return new HeapEstimatorCacheConfig(config.get(heap_estimator_cache_size_limit).intValue(), config.get(heap_estimator_cache_large_object_threshold).longValue());
    }

    public static enum CypherRuntime {
        DEFAULT,
        LEGACY,
        INTERPRETED,
        SLOTTED,
        PIPELINED,
        PARALLEL;

    }

    public static enum CypherExpressionEngine {
        DEFAULT,
        INTERPRETED,
        COMPILED,
        ONLY_WHEN_HOT;

    }

    public static enum StatefulShortestPlanningMode {
        INTO_ONLY,
        ALL_IF_POSSIBLE,
        CARDINALITY_HEURISTIC;

    }

    public static enum PlanVarExpandInto {
        MINIMUM_COST,
        SINGLE_ROW;

    }

    public static enum CypherReplanAlgorithm {
        DEFAULT,
        NONE,
        INVERSE,
        EXPONENTIAL;

    }

    public static enum CypherParallelRuntimeSupport {
        DISABLED,
        ALL;

    }

    public static enum CypherWorkerManagement {
        DEFAULT,
        THREAD_POOL;

    }

    public static enum CypherOperatorEngine {
        DEFAULT,
        COMPILED,
        INTERPRETED;

    }

    public static enum CypherPipelinedInterpretedPipesFallback {
        DISABLED,
        DEFAULT,
        ALL,
        WHITELISTED_PLANS_ONLY;

    }

    public static enum EagerAnalysisImplementation {
        IR,
        LP;

    }

    public static enum ExtractLiteral {
        ALWAYS,
        NEVER,
        IF_NO_PARAMETER;

    }

    public static enum RemoteBatchPropertiesImplementation {
        PLANNER,
        REWRITER,
        SKIP_REMOTE_BATCHING;

    }

    public static enum HeapEstimatorCachePreset {
        DEFAULT,
        DISABLED,
        SMALL,
        LARGE,
        CUSTOM;

    }
}

