/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.time.Duration;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.ConnectorDefaults;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;

@PublicApi
public final class BoltConnector
implements SettingsDeclaration {
    public static final int DEFAULT_PORT = 7687;
    public static final String NAME = "bolt";
    public static final String INTERNAL_NAME = "bolt-internal";
    @Description(value="Enable the bolt connector")
    public static final Setting<Boolean> enabled = ConnectorDefaults.bolt_enabled;
    @Description(value="Enable the collection of driver telemetry.")
    public static final Setting<Boolean> server_bolt_telemetry_enabled = SettingImpl.newBuilder("server.bolt.telemetry.enabled", SettingValueParsers.BOOL, false).build();
    @Description(value="Encryption level to require this connector to use")
    public static final Setting<EncryptionLevel> encryption_level = SettingImpl.newBuilder("server.bolt.tls_level", SettingValueParsers.ofEnum(EncryptionLevel.class), EncryptionLevel.DISABLED).build();
    @Description(value="Address the connector should bind to")
    public static final Setting<SocketAddress> listen_address = SettingImpl.newBuilder("server.bolt.listen_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7687)).setDependency(GraphDatabaseSettings.default_listen_address).build();
    @Description(value="Advertised address for this connector")
    public static final Setting<SocketAddress> advertised_address = SettingImpl.newBuilder("server.bolt.advertised_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7687)).addConstraint(SettingConstraints.NO_ALL_INTERFACES_ADDRESS).setDependency(GraphDatabaseSettings.default_advertised_address).build();
    @Description(value="The type of messages to enable keep-alive messages for (ALL, STREAMING or OFF)")
    public static final Setting<KeepAliveRequestType> connection_keep_alive_type = SettingImpl.newBuilder("server.bolt.connection_keep_alive_for_requests", SettingValueParsers.ofEnum(KeepAliveRequestType.class), KeepAliveRequestType.ALL).build();
    @Description(value="The maximum time to wait before sending a NOOP on connections waiting for responses from active ongoing queries. The minimum value is 1 millisecond.")
    public static final Setting<Duration> connection_keep_alive = SettingImpl.newBuilder("server.bolt.connection_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).addConstraint(SettingConstraints.min(Duration.ofMillis(1L))).build();
    @Description(value="The interval between every scheduled keep-alive check on all connections with active queries. Zero duration turns off keep-alive service.")
    public static final Setting<Duration> connection_keep_alive_streaming_scheduling_interval = SettingImpl.newBuilder("server.bolt.connection_keep_alive_streaming_scheduling_interval", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(0L))).build();
    @Description(value="The total amount of probes to be missed before a connection is considered stale.The minimum for this value is 1.")
    public static final Setting<Integer> connection_keep_alive_probes = SettingImpl.newBuilder("server.bolt.connection_keep_alive_probes", SettingValueParsers.INT, 2).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="The number of threads to keep in the thread pool bound to this connector, even if they are idle.")
    public static final Setting<Integer> thread_pool_min_size = SettingImpl.newBuilder("server.bolt.thread_pool_min_size", SettingValueParsers.INT, 5).build();
    @Description(value="The maximum number of threads allowed in the thread pool bound to this connector.")
    public static final Setting<Integer> thread_pool_max_size = SettingImpl.newBuilder("server.bolt.thread_pool_max_size", SettingValueParsers.INT, 400).build();
    @Description(value="The maximum time an idle thread in the thread pool bound to this connector will wait for new tasks.")
    public static final Setting<Duration> thread_pool_keep_alive = SettingImpl.newBuilder("server.bolt.thread_pool_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).build();
    @Description(value="Enables accounting based reporting of benign errors within the Bolt stack (when enabled, benign errors are reported only when such events occur with unusual frequency. Otherwise, all benign network errors will be reported)")
    public static final Setting<Boolean> enable_error_accounting = SettingImpl.newBuilder("server.bolt.enable_network_error_accounting", SettingValueParsers.BOOL, true).build();
    @Description(value="The maximum amount of network related connection aborts permitted within a given window before emitting log messages (a value of zero reverts to legacy warning behavior)")
    public static final Setting<Long> network_abort_warn_threshold = SettingImpl.newBuilder("server.bolt.network_abort_warn_threshold", SettingValueParsers.LONG, 2L).addConstraint(SettingConstraints.min(1L)).build();
    @Description(value="The duration of the window in which network related connection aborts are sampled")
    public static final Setting<Duration> network_abort_warn_window_duration = SettingImpl.newBuilder("server.bolt.network_abort_warn_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="The duration for which network related connection aborts need to remain at a reasonable level before the error is cleared")
    public static final Setting<Duration> network_abort_clear_window_duration = SettingImpl.newBuilder("server.bolt.network_abort_clear_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="The maximum amount of unscheduled requests permitted during thread starvation events within a given window before emitting log messages")
    public static final Setting<Long> thread_starvation_warn_threshold = SettingImpl.newBuilder("server.bolt.thread_starvation_warn_threshold", SettingValueParsers.LONG, 2L).addConstraint(SettingConstraints.min(1L)).build();
    @Description(value="The duration of the window in which unscheduled requests are sampled")
    public static final Setting<Duration> thread_starvation_warn_window_duration = SettingImpl.newBuilder("server.bolt.thread_starvation_warn_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="The duration for which unscheduled requests need to remain at a reasonable level before the error is cleared")
    public static final Setting<Duration> thread_starvation_clear_window_duration = SettingImpl.newBuilder("server.bolt.thread_starvation_clear_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="Amount of time spent between samples of current traffic usage (lower values result in more accurate reporting while incurring a higher performance penalty; a value of zero disables traffic accounting)")
    public static final Setting<Duration> traffic_accounting_check_period = SettingImpl.newBuilder("server.bolt.traffic_accounting_check_period", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).addConstraint(SettingConstraints.any(SettingConstraints.is(Duration.ZERO), SettingConstraints.min(Duration.ofMinutes(1L)))).build();
    @Description(value="Time required to be spent below the configured traffic threshold in order to clear traffic warnings")
    public static final Setting<Duration> traffic_accounting_clear_duration = SettingImpl.newBuilder("server.bolt.traffic_accounting_clear_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofMinutes(1L))).build();
    @Description(value="Maximum permitted incoming traffic within a configured accounting check window before emitting a warning (in Mbps)")
    public static final Setting<Long> traffic_accounting_incoming_threshold_mbps = SettingImpl.newBuilder("server.bolt.traffic_accounting_incoming_threshold_mbps", SettingValueParsers.LONG, 950L).addConstraint(SettingConstraints.min(1L)).build();
    @Description(value="Maximum permitted outgoing traffic within a configured accounting check window before emitting a warning (in Mbps)")
    public static final Setting<Long> traffic_accounting_outgoing_threshold_mbps = SettingImpl.newBuilder("server.bolt.traffic_accounting_outgoing_threshold_mbps", SettingValueParsers.LONG, 950L).addConstraint(SettingConstraints.min(1L)).build();

    public static enum EncryptionLevel {
        REQUIRED,
        OPTIONAL,
        DISABLED;

    }

    public static enum KeepAliveRequestType {
        ALL,
        STREAMING,
        OFF;

    }
}

