/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.ConnectorDefaults;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;

@PublicApi
public final class HttpConnector
implements SettingsDeclaration {
    public static final int DEFAULT_PORT = 7474;
    public static final String NAME = "http";
    @Description(value="Enable the http connector")
    public static final Setting<Boolean> enabled = ConnectorDefaults.http_enabled;
    @Description(value="Address the connector should bind to")
    public static final Setting<SocketAddress> listen_address = SettingImpl.newBuilder("server.http.listen_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7474)).setDependency(GraphDatabaseSettings.default_listen_address).build();
    @Description(value="Advertised address for this connector")
    public static final Setting<SocketAddress> advertised_address = SettingImpl.newBuilder("server.http.advertised_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7474)).addConstraint(SettingConstraints.NO_ALL_INTERFACES_ADDRESS).setDependency(GraphDatabaseSettings.default_advertised_address).build();
}

