/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;

public class ConnectorPortRegister {
    private final ConcurrentHashMap<ConnectorType, HostnamePort> connectorsInfo = new ConcurrentHashMap();
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public void register(ConnectorType connectorKey, InetSocketAddress localAddress) {
        this.register(connectorKey, localAddress.getHostString(), localAddress.getPort());
    }

    public void register(ConnectorType connectorKey, SocketAddress localAddress) {
        this.register(connectorKey, localAddress.getHostname(), localAddress.getPort());
    }

    public void deregister(ConnectorType connectorKey) {
        this.connectorsInfo.remove((Object)connectorKey);
    }

    public HostnamePort getLocalAddress(ConnectorType connectorKey) {
        return this.connectorsInfo.get((Object)connectorKey);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void register(ConnectorType connectorKey, String hostname, int port) {
        HostnamePort hostnamePort = new HostnamePort(hostname, port);
        this.connectorsInfo.put(connectorKey, hostnamePort);
        this.listeners.forEach(listener -> listener.portRegistered(connectorKey, new SocketAddress(hostname, port)));
    }

    public static interface Listener {
        public void portRegistered(ConnectorType var1, SocketAddress var2);
    }
}

