/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.neo4j.annotations.api.PublicApi;

@PublicApi
public final class GlobbingPattern {
    private final String originalString;
    private final Pattern regexPattern;

    public GlobbingPattern(String pattern) {
        this.originalString = pattern;
        try {
            this.regexPattern = GlobbingPattern.buildRegex(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid globbing pattern '" + pattern + "'", e);
        }
    }

    public static List<GlobbingPattern> create(String ... patterns) {
        ArrayList<GlobbingPattern> globbingPatterns = new ArrayList<GlobbingPattern>();
        for (String pattern : patterns) {
            globbingPatterns.add(new GlobbingPattern(pattern));
        }
        return globbingPatterns;
    }

    public boolean matches(String value) {
        return this.regexPattern.matcher(value).matches();
    }

    public String toString() {
        return this.originalString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobbingPattern that = (GlobbingPattern)o;
        return this.originalString.equals(that.originalString);
    }

    public int hashCode() {
        return this.originalString.hashCode();
    }

    private static Pattern buildRegex(String globbingPattern) {
        StringBuilder patternString = new StringBuilder();
        for (int i = 0; i < globbingPattern.length(); ++i) {
            char ch = globbingPattern.charAt(i);
            if (ch == '*') {
                patternString.append(".*");
                continue;
            }
            if (ch == '?') {
                patternString.append(".");
                continue;
            }
            if (ch == '.' || ch == '-') {
                patternString.append("\\").append(ch);
                continue;
            }
            patternString.append(ch);
        }
        return Pattern.compile(patternString.toString());
    }
}

