/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.database.readonly;

import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public final class ConfigReadOnlyDatabaseListener
extends LifecycleAdapter {
    private final ReadOnlyDatabases readOnlyDatabases;
    private final Config config;
    private SettingChangeListener<Boolean> readOnlyDatabaseDefault;
    private SettingChangeListener<Set<String>> readOnlyDatabasesList;
    private SettingChangeListener<Set<String>> writableDatabasesList;

    public ConfigReadOnlyDatabaseListener(ReadOnlyDatabases readOnlyDatabases, Config config) {
        this.readOnlyDatabases = readOnlyDatabases;
        this.config = config;
    }

    private <T> SettingChangeListener<T> getConfigChangeListener(Setting<T> ignored) {
        return (oldValue, newValue) -> this.readOnlyDatabases.refresh();
    }

    private <T> SettingChangeListener<T> addConfigListener(Setting<T> setting) {
        SettingChangeListener<T> changeListener = this.getConfigChangeListener(setting);
        this.config.addListener(setting, changeListener);
        return changeListener;
    }

    private <T> void removeConfigListener(Setting<T> setting, SettingChangeListener<T> changeListener) {
        if (changeListener != null) {
            this.config.removeListener(setting, changeListener);
        }
    }

    public void init() throws Exception {
        this.readOnlyDatabaseDefault = this.addConfigListener(GraphDatabaseSettings.read_only_database_default);
        this.readOnlyDatabasesList = this.addConfigListener(GraphDatabaseSettings.read_only_databases);
        this.writableDatabasesList = this.addConfigListener(GraphDatabaseSettings.writable_databases);
        this.readOnlyDatabases.refresh();
    }

    public void shutdown() throws Exception {
        this.removeConfigListener(GraphDatabaseSettings.read_only_database_default, this.readOnlyDatabaseDefault);
        this.removeConfigListener(GraphDatabaseSettings.read_only_databases, this.readOnlyDatabasesList);
        this.removeConfigListener(GraphDatabaseSettings.writable_databases, this.writableDatabasesList);
    }
}

