/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.Objects;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DbmsReadOnlyChecker;
import org.neo4j.kernel.api.exceptions.ReadOnlyDbException;
import org.neo4j.util.VisibleForTesting;

public interface DatabaseReadOnlyChecker {
    public static DatabaseReadOnlyChecker writable() {
        return WritableDatabaseReadOnlyChecker.INSTANCE;
    }

    public static DatabaseReadOnlyChecker readOnly() {
        return ReadOnlyDatabaseReadOnlyChecker.INSTANCE;
    }

    public boolean isReadOnly();

    public void check();

    public static class ReadOnlyDatabaseReadOnlyChecker
    implements DatabaseReadOnlyChecker {
        static final ReadOnlyDatabaseReadOnlyChecker INSTANCE = new ReadOnlyDatabaseReadOnlyChecker();

        private ReadOnlyDatabaseReadOnlyChecker() {
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void check() {
            throw new RuntimeException((Throwable)new ReadOnlyDbException());
        }
    }

    public static class WritableDatabaseReadOnlyChecker
    implements DatabaseReadOnlyChecker {
        static final WritableDatabaseReadOnlyChecker INSTANCE = new WritableDatabaseReadOnlyChecker();

        private WritableDatabaseReadOnlyChecker() {
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public void check() {
        }
    }

    public static class Default
    implements DatabaseReadOnlyChecker {
        private final DbmsReadOnlyChecker dbmsChecker;
        private final String databaseName;

        @VisibleForTesting
        public Default(Config config, String databaseName) {
            this(new DbmsReadOnlyChecker.Default(config), databaseName);
        }

        public Default(DbmsReadOnlyChecker dbmsChecker, String databaseName) {
            this.dbmsChecker = Objects.requireNonNull(dbmsChecker);
            this.databaseName = Objects.requireNonNull(databaseName);
        }

        @Override
        public boolean isReadOnly() {
            return this.dbmsChecker.isReadOnly(this.databaseName);
        }

        @Override
        public void check() {
            if (this.isReadOnly()) {
                throw new RuntimeException((Throwable)new ReadOnlyDbException(this.databaseName));
            }
        }
    }
}

