/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;

public class GraphDatabaseInternalSettings
implements SettingsDeclaration {
    @Internal
    public static final Setting<Path> databases_root_path = SettingImpl.newBuilder("unsupported.dbms.directories.databases.root", SettingValueParsers.PATH, Path.of("databases", new String[0])).setDependency(GraphDatabaseSettings.data_directory).immutable().build();
    @Deprecated
    @Internal
    @Description(value="Location where Neo4j keeps the logical transaction logs.")
    public static final Setting<Path> logical_logs_location = SettingImpl.newBuilder("dbms.directories.tx_log", SettingValueParsers.PATH, Path.of("neo4j", new String[0])).setDependency(databases_root_path).build();
    @Internal
    @Description(value="Configure lucene to be in memory only, for test environment. This is set in code and should never be configured explicitly.")
    public static final Setting<Boolean> ephemeral_lucene = SettingImpl.newBuilder("unsupported.dbms.lucene.ephemeral", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<String> lock_manager = SettingImpl.newBuilder("unsupported.dbms.lock_manager", SettingValueParsers.STRING, "forseti").build();
    @Internal
    public static final Setting<Boolean> lock_manager_verbose_deadlocks = SettingImpl.newBuilder("unsupported.dbms.lock_manager.verbose_deadlocks", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<String> tracer = SettingImpl.newBuilder("unsupported.dbms.tracer", SettingValueParsers.STRING, null).build();
    @Internal
    @Description(value="Print out the effective Neo4j configuration after startup.")
    public static final Setting<Boolean> dump_configuration = SettingImpl.newBuilder("unsupported.dbms.report_configuration", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Specifies if the consistency checker should stop when number of observed inconsistencies exceed the threshold. If the value is zero, all inconsistencies will be reported")
    public static final Setting<Integer> consistency_checker_fail_fast_threshold = SettingImpl.newBuilder("unsupported.consistency_checker.fail_fast_threshold", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Set this to specify the default runtime for the default language version.")
    public static final Setting<CypherRuntime> cypher_runtime = SettingImpl.newBuilder("unsupported.cypher.runtime", SettingValueParsers.ofEnum(CypherRuntime.class), CypherRuntime.DEFAULT).build();
    @Internal
    @Description(value="Choose the expression engine. The default is to only compile expressions that are hot, if 'COMPILED' is chosen all expressions will be compiled directly and if 'INTERPRETED' is chosen expressions will never be compiled.")
    public static final Setting<CypherExpressionEngine> cypher_expression_engine = SettingImpl.newBuilder("unsupported.cypher.expression_engine", SettingValueParsers.ofEnum(CypherExpressionEngine.class), CypherExpressionEngine.DEFAULT).build();
    @Internal
    @Description(value="Number of uses before an expression is considered for compilation")
    public static final Setting<Integer> cypher_expression_recompilation_limit = SettingImpl.newBuilder("unsupported.cypher.expression_recompilation_limit", SettingValueParsers.INT, 10).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Enable tracing of compilation in cypher.")
    public static final Setting<Boolean> cypher_compiler_tracing = SettingImpl.newBuilder("unsupported.cypher.compiler_tracing", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Large databases might change slowly, and so to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by unsupported.cypher.replan_algorithm and will cause the threshold to reach the value set here once the time since the previous replanning has reached unsupported.cypher.target_replan_interval. Setting this value to higher than the cypher.statistics_divergence_threshold will cause the threshold to not decay over time.")
    public static final Setting<Double> query_statistics_divergence_target = SettingImpl.newBuilder("unsupported.cypher.statistics_divergence_target", SettingValueParsers.DOUBLE, 0.1).addConstraint(SettingConstraints.range(0.0, 1.0)).build();
    @Internal
    @Description(value="The threshold when a warning is generated if a label scan is done after a load csv where the label has no index")
    public static final Setting<Long> query_non_indexed_label_warning_threshold = SettingImpl.newBuilder("unsupported.cypher.non_indexed_label_warning_threshold", SettingValueParsers.LONG, 10000L).build();
    @Internal
    @Description(value="To improve IDP query planning time, we can restrict the internal planning table size, triggering compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    public static final Setting<Integer> cypher_idp_solver_table_threshold = SettingImpl.newBuilder("unsupported.cypher.idp_solver_table_threshold", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(16)).build();
    @Internal
    @Description(value="To improve IDP query planning time, we can restrict the internal planning loop duration, triggering more frequent compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    public static final Setting<Long> cypher_idp_solver_duration_threshold = SettingImpl.newBuilder("unsupported.cypher.idp_solver_duration_threshold", SettingValueParsers.LONG, 1000L).addConstraint(SettingConstraints.min(10L)).build();
    @Internal
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by unsupported.cypher.replan_algorithm and will cause the threshold to reach the value set by unsupported.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set here. Setting this value to less than the value of cypher.min_replan_interval will cause the threshold to not decay over time.")
    public static final Setting<Duration> cypher_replan_interval_target = SettingImpl.newBuilder("unsupported.cypher.target_replan_interval", SettingValueParsers.DURATION, Duration.ofHours(7L)).build();
    @Internal
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time using the algorithm set here. This will cause the threshold to reach the value set by unsupported.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set in unsupported.cypher.target_replan_interval. Setting the algorithm to 'none' will cause the threshold to not decay over time.")
    public static final Setting<CypherReplanAlgorithm> cypher_replan_algorithm = SettingImpl.newBuilder("unsupported.cypher.replan_algorithm", SettingValueParsers.ofEnum(CypherReplanAlgorithm.class), CypherReplanAlgorithm.DEFAULT).build();
    @Internal
    @Description(value="Set this to enable monitors in the Cypher runtime.")
    public static final Setting<Boolean> cypher_enable_runtime_monitors = SettingImpl.newBuilder("unsupported.cypher.enable_runtime_monitors", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Set this to enable relationship indexes in the Cypher runtime.")
    public static final Setting<Boolean> cypher_enable_planning_relationship_indexes = SettingImpl.newBuilder("unsupported.cypher.enable_planning_relationship_indexes", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Enable tracing of pipelined runtime scheduler.")
    public static final Setting<Boolean> enable_pipelined_runtime_trace = SettingImpl.newBuilder("unsupported.cypher.pipelined.enable_runtime_trace", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Path to the pipelined runtime scheduler trace. If 'stdOut' and tracing is on, will print to std out.")
    public static final Setting<Path> pipelined_scheduler_trace_filename = SettingImpl.newBuilder("unsupported.cypher.pipelined.runtime_trace_path", SettingValueParsers.PATH, Path.of("stdOut", new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Internal
    @Description(value="The size of batches in the pipelined runtime for queries which work with few rows.")
    public static final Setting<Integer> cypher_pipelined_batch_size_small = SettingImpl.newBuilder("unsupported.cypher.pipelined.batch_size_small", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(1)).build();
    @Internal
    @Description(value="The size of batches in the pipelined runtime for queries which work with many rows.")
    public static final Setting<Integer> cypher_pipelined_batch_size_big = SettingImpl.newBuilder("unsupported.cypher.pipelined.batch_size_big", SettingValueParsers.INT, 1024).addConstraint(SettingConstraints.min(1)).build();
    @Internal
    @Description(value="Number of threads to allocate to Cypher worker threads for the parallel runtime. If set to 0, two workers will be started for every physical core in the system. If set to -1, no workers will be started and the parallel runtime cannot be used.")
    public static final Setting<Integer> cypher_worker_count = SettingImpl.newBuilder("unsupported.cypher.number_of_workers", SettingValueParsers.INT, 0).build();
    @Internal
    @Description(value="For compiled execution, specialized code is generated and then executed. More optimizations such as operator fusion may apply. Operator fusion means that multiple operators such as for example AllNodesScan -> Filter -> ProduceResult can be compiled into a single specialized operator. This setting only applies to the pipelined and parallel runtime. Allowed values are \"default\" (the default, use compiled when applicable), \"compiled\" and \"interpreted\".")
    public static final Setting<CypherOperatorEngine> cypher_operator_engine = SettingImpl.newBuilder("unsupported.cypher.pipelined.operator_engine", SettingValueParsers.ofEnum(CypherOperatorEngine.class), CypherOperatorEngine.DEFAULT).build();
    @Internal
    @Description(value="Use interpreted pipes as a fallback for operators that do not have a specialized implementation in the pipelined runtime. Allowed values are \"disabled\", \"default\" (the default, use whitelisted_plans_only when applicable), \"whitelisted_plans_only\" and \"all\" (experimental). The default is to enable the use of a subset of whitelisted operators that are known to be supported, whereas \"all\" is an experimental option that enables the fallback to be used for all possible operators that are not known to be unsupported.")
    public static final Setting<CypherPipelinedInterpretedPipesFallback> cypher_pipelined_interpreted_pipes_fallback = SettingImpl.newBuilder("unsupported.cypher.pipelined_interpreted_pipes_fallback", SettingValueParsers.ofEnum(CypherPipelinedInterpretedPipesFallback.class), CypherPipelinedInterpretedPipesFallback.DEFAULT).build();
    @Internal
    @Description(value="The maximum number of operator fusions over pipelines (i.e. where an operator that would normally be considered pipeline-breaking, e.g. expand), that is considered before a pipeline break is forced.")
    public static final Setting<Integer> cypher_pipelined_operator_fusion_over_pipeline_limit = SettingImpl.newBuilder("unsupported.cypher.pipelined.operator_fusion_over_pipeline_limit", SettingValueParsers.INT, 8).build();
    @Internal
    @Description(value="The parser implementation to use for parsing cypher queries.")
    public static final Setting<CypherParser> cypher_parser = SettingImpl.newBuilder("unsupported.cypher.parser", SettingValueParsers.ofEnum(CypherParser.class), CypherParser.DEFAULT).build();
    @Internal
    @Description(value="Determines whether the planner is allowed to push down the sort portion of an ORDER BY + LIMIT combination")
    public static final Setting<SplittingTopBehavior> cypher_splitting_top_behavior = SettingImpl.newBuilder("unsupported.cypher.splitting_top_behavior", SettingValueParsers.ofEnum(SplittingTopBehavior.class), SplittingTopBehavior.DEFAULT).build();
    @Internal
    @Description(value="Max number of recent queries to collect in the data collector module. Will round down to the nearest power of two. The default number (8192 query invocations)  was chosen as a trade-off between getting a useful amount of queries, and not wasting too much heap. Even with a buffer full of unique queries, the estimated footprint lies in tens of MBs. If the buffer is full of cached queries, the retained size was measured to 265 kB. Setting this to 0 will disable data collection of queries completely.")
    public static final Setting<Integer> data_collector_max_recent_query_count = SettingImpl.newBuilder("unsupported.datacollector.max_recent_query_count", SettingValueParsers.INT, 8192).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Sets the upper limit for how much of the query text that will be retained by the query collector. For queries longer than the limit, only a prefix of size limit will be retained by the collector. Lowering this value will reduce the memory footprint of collected query invocations under loads with many queries with long query texts, which could occur for generated queries. The downside is that on retrieving queries by `db.stats.retrieve`, queries longer than this max size would be returned incomplete. Setting this to 0 will completely drop query texts from the collected queries.")
    public static final Setting<Integer> data_collector_max_query_text_size = SettingImpl.newBuilder("unsupported.datacollector.max_query_text_size", SettingValueParsers.INT, 10000).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Enable or disable the ability to create and drop databases.")
    public static final Setting<Boolean> block_create_drop_database = SettingImpl.newBuilder("unsupported.dbms.block_create_drop_database", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the ability to start and stop databases.")
    public static final Setting<Boolean> block_start_stop_database = SettingImpl.newBuilder("unsupported.dbms.block_start_stop_database", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the ability to execute the `dbms.upgrade` procedure.")
    public static final Setting<Boolean> block_upgrade_procedures = SettingImpl.newBuilder("unsupported.dbms.upgrade_restriction_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="The maximum amount of time to wait for the database to become available, when starting a new transaction.")
    public static final Setting<Duration> transaction_start_timeout = SettingImpl.newBuilder("unsupported.dbms.transaction_start_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(1L)).build();
    @Internal
    @Description(value="Location of the database scripts directory.")
    public static final Setting<Path> scripts_dir = SettingImpl.newBuilder("unsupported.dbms.directories.scripts", SettingValueParsers.PATH, Path.of("scripts", new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Internal
    @Description(value="Name of file containing commands to be run during initialization of the system database. The file should exists in the scripts directory in neo4j home directory.")
    public static final Setting<Path> system_init_file = SettingImpl.newBuilder("dbms.init_file", SettingValueParsers.PATH, null).immutable().setDependency(scripts_dir).build();
    @Internal
    @Description(value="Maximum time to wait for active transaction completion when rotating counts store")
    public static final Setting<Duration> counts_store_rotation_timeout = SettingImpl.newBuilder("unsupported.dbms.counts_store_rotation_timeout", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).build();
    @Internal
    @Description(value="Set the maximum number of threads that can concurrently be used to sample indexes. Zero means unrestricted.")
    public static final Setting<Integer> index_sampling_parallelism = SettingImpl.newBuilder("unsupported.dbms.index_sampling.parallelism", SettingValueParsers.INT, 4).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Set the maximum number of concurrent index populations across system. This also limit the number of threads used to scan store. Note that multiple indexes can be populated by a single index population if they were created in the same transaction. Zero means unrestricted. ")
    public static final Setting<Integer> index_population_parallelism = SettingImpl.newBuilder("unsupported.dbms.index_population.parallelism", SettingValueParsers.INT, 2).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Set the number of threads used for each index population job. Those threads execute individual subtasks provided by index population main threads, see unsupported.dbms.index_population.parallelism.Zero means one thread per cpu core. Thus the maximum total number of index worker threads in the system is unsupported.dbms.index_population.workers * unsupported.dbms.index_population.parallelism.")
    public static final Setting<Integer> index_population_workers = SettingImpl.newBuilder("unsupported.dbms.index_population.workers", SettingValueParsers.INT, Integer.max(1, Runtime.getRuntime().availableProcessors() / 4)).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="The default index provider used for managing full-text indexes. Only 'fulltext-1.0' is supported.")
    public static final Setting<String> default_fulltext_provider = SettingImpl.newBuilder("unsupported.dbms.index.default_fulltext_provider", SettingValueParsers.STRING, "fulltext-1.0").build();
    @Internal
    @Description(value="If 'true', new database will be created without token indexes for labels and relationships.")
    public static final Setting<Boolean> skip_default_indexes_on_creation = SettingImpl.newBuilder("unsupported.dbms.index.skip_default_indexes_on_creation", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="If `true`, Neo4j will abort recovery if any errors are encountered in the logical log. Setting this to `false` will allow Neo4j to restore as much as possible from the corrupted log files and ignore the rest, but, the integrity of the database might be compromised.")
    public static final Setting<Boolean> fail_on_corrupted_log_files = SettingImpl.newBuilder("unsupported.dbms.tx_log.fail_on_corrupted_log_files", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Specifies if engine should run cypher query based on a snapshot of accessed data. Query will be restarted in case if concurrent modification of data will be detected.")
    public static final Setting<Boolean> snapshot_query = SettingImpl.newBuilder("unsupported.dbms.query.snapshot", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Specifies number or retries that query engine will do to execute query based on stable accessed data snapshot before giving up.")
    public static final Setting<Integer> snapshot_query_retries = SettingImpl.newBuilder("unsupported.dbms.query.snapshot.retries", SettingValueParsers.INT, 5).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Description(value="Cypher keeps a cache of the conversion from logical plans to execution plans. This cache is mainly meant to avoid generating code multiple times if different queries use the same logical plan. Items are only evicted from the cache when all query caches are cleared, e.g. by calling `db.clearQueryCaches()`. The cache is allowed to grow up to this size. Setting the size to 0 means disabling this cache.")
    public static final Setting<Integer> query_execution_plan_cache_size = SettingImpl.newBuilder("unsupported.dbms.query_execution_plan_cache_size", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that e.g a block size of 120 will hold a 60 character long string before overflowing into a second block. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    public static final Setting<Integer> string_block_size = SettingImpl.newBuilder("unsupported.dbms.block_size.strings", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    public static final Setting<Integer> array_block_size = SettingImpl.newBuilder("unsupported.dbms.block_size.array_properties", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="Specifies the block size for storing labels exceeding in-lined space in node record. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    public static final Setting<Integer> label_block_size = SettingImpl.newBuilder("unsupported.dbms.block_size.labels", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Internal
    @Description(value="An identifier that uniquely identifies this graph database instance within this JVM. Defaults to an auto-generated number depending on how many instance are started in this JVM.")
    public static final Setting<String> forced_kernel_id = SettingImpl.newBuilder("unsupported.dbms.kernel_id", SettingValueParsers.STRING, null).addConstraint(SettingConstraints.matches("[a-zA-Z0-9]*", "has to be a valid kernel identifier")).build();
    @Internal
    public static final Setting<Duration> vm_pause_monitor_measurement_duration = SettingImpl.newBuilder("unsupported.vm_pause_monitor.measurement_duration", SettingValueParsers.DURATION, Duration.ofMillis(100L)).build();
    @Internal
    public static final Setting<Duration> vm_pause_monitor_stall_alert_threshold = SettingImpl.newBuilder("unsupported.vm_pause_monitor.stall_alert_threshold", SettingValueParsers.DURATION, Duration.ofMillis(100L)).build();
    @Internal
    @Description(value="Create a heap dump just before the end of each query execution. The heap dump will be placed in log directory and the file name will contain the query id, to be correlated with an entry in the query log. Only live objects will be included to minimize the file size. ")
    public static final Setting<Boolean> log_queries_heap_dump_enabled = SettingImpl.newBuilder("unsupported.dbms.logs.query.heap_dump_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="Specifies number of operations that batch inserter will try to group into one batch before flushing data into underlying storage.")
    public static final Setting<Integer> batch_inserter_batch_size = SettingImpl.newBuilder("unsupported.tools.batch_inserter.batch_size", SettingValueParsers.INT, 10000).build();
    @Internal
    public static final Setting<Path> auth_store = SettingImpl.newBuilder("unsupported.dbms.security.auth_store.location", SettingValueParsers.PATH, null).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Internal
    @Description(value="Whether to apply network level outbound network buffer based throttling")
    public static final Setting<Boolean> bolt_outbound_buffer_throttle = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="When the size (in bytes) of outbound network buffers, used by bolt's network layer, grows beyond this value bolt channel will advertise itself as unwritable and will block related processing thread until it becomes writable again.")
    public static final Setting<Integer> bolt_outbound_buffer_throttle_high_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle.high_watermark", SettingValueParsers.INT, (int)ByteUnit.kibiBytes((long)512L)).addConstraint(SettingConstraints.range((int)ByteUnit.kibiBytes((long)64L), Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="When the size (in bytes) of outbound network buffers, previously advertised as unwritable, gets below this value bolt channel will re-advertise itself as writable and blocked processing thread will resume execution.")
    public static final Setting<Integer> bolt_outbound_buffer_throttle_low_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle.low_watermark", SettingValueParsers.INT, (int)ByteUnit.kibiBytes((long)128L)).addConstraint(SettingConstraints.range((int)ByteUnit.kibiBytes((long)16L), Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="When the total time outbound network buffer based throttle lock is held exceeds this value, the corresponding bolt channel will be aborted. Setting this to 0 will disable this behaviour.")
    public static final Setting<Duration> bolt_outbound_buffer_throttle_max_duration = SettingImpl.newBuilder("unsupported.dbms.bolt.outbound_buffer_throttle.max_duration", SettingValueParsers.DURATION, Duration.ofMinutes(15L)).addConstraint(SettingConstraints.any(SettingConstraints.min(Duration.ofSeconds(30L)), SettingConstraints.is(Duration.ZERO))).build();
    @Internal
    @Description(value="When the number of queued inbound messages grows beyond this value, reading from underlying channel will be paused (no more inbound messages will be available) until queued number of messages drops below the configured low watermark value.")
    public static final Setting<Integer> bolt_inbound_message_throttle_high_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.inbound_message_throttle.high_watermark", SettingValueParsers.INT, 300).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="When the number of queued inbound messages, previously reached configured high watermark value, drops below this value, reading from underlying channel will be enabled and any pending messages will start queuing again.")
    public static final Setting<Integer> bolt_inbound_message_throttle_low_water_mark = SettingImpl.newBuilder("unsupported.dbms.bolt.inbound_message_throttle.low_watermark", SettingValueParsers.INT, 100).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Internal
    public static final Setting<Boolean> netty_server_use_epoll = SettingImpl.newBuilder("unsupported.dbms.bolt.netty_server_use_epoll", SettingValueParsers.BOOL, true).build();
    @Internal
    public static final Setting<Integer> netty_server_shutdown_quiet_period = SettingImpl.newBuilder("unsupported.dbms.bolt.netty_server_shutdown_quiet_period", SettingValueParsers.INT, 5).build();
    @Internal
    public static final Setting<Duration> netty_server_shutdown_timeout = SettingImpl.newBuilder("unsupported.dbms.bolt.netty_server_shutdown_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(15L)).build();
    @Internal
    public static final Setting<Boolean> netty_message_merge_cumulator = SettingImpl.newBuilder("unsupported.dbms.bolt.netty_message_merge_cumulator", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Create an archive of an index before re-creating it if failing to load on startup.")
    public static final Setting<Boolean> archive_failed_index = SettingImpl.newBuilder("unsupported.dbms.index.archive_failed", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Forces smaller ID cache, in order to preserve memory.")
    public static final Setting<Boolean> force_small_id_cache = SettingImpl.newBuilder("unsupported.dbms.force_small_id_cache", SettingValueParsers.BOOL, Boolean.FALSE).build();
    @Internal
    public static final Setting<Boolean> consistency_check_on_apply = SettingImpl.newBuilder("unsupported.dbms.storage.consistency_check_on_apply", SettingValueParsers.BOOL, Boolean.FALSE).build();
    @Internal
    @Description(value="Time interval of inactivity after which a driver will be closed.")
    public static final Setting<Duration> routing_driver_idle_timeout = SettingImpl.newBuilder("dbms.routing.driver.timeout", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Internal
    @Description(value="Time interval between driver idleness check.")
    public static final Setting<Duration> routing_driver_idle_check_interval = SettingImpl.newBuilder("dbms.routing.driver.idle_check_interval", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Internal
    @Description(value="Number of event loops used by drivers. Event loops are shard between drivers, so this is the total number of event loops created.")
    @DocumentedDefaultValue(value="Number of available processors")
    public static final Setting<Integer> routing_driver_event_loop_count = SettingImpl.newBuilder("dbms.routing.driver.event_loop_count", SettingValueParsers.INT, Runtime.getRuntime().availableProcessors()).build();
    @Internal
    @Description(value="Enables logging of leaked driver session")
    public static final Setting<Boolean> routing_driver_log_leaked_sessions = SettingImpl.newBuilder("dbms.routing.driver.logging.leaked_sessions", SettingValueParsers.BOOL, false).build();
    @Description(value="Specifies at which file size the checkpoint log will auto-rotate. Minimum accepted value is 1 KiB. ")
    public static final Setting<Long> checkpoint_logical_log_rotation_threshold = SettingImpl.newBuilder("unsupported.dbms.checkpoint_log.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)1L)).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)1L))).build();
    @Description(value="Number of checkpoint logs files to keep.")
    public static final Setting<Integer> checkpoint_logical_log_keep_threshold = SettingImpl.newBuilder("unsupported.dbms.checkpoint_log.rotation.keep.files", SettingValueParsers.INT, 3).addConstraint(SettingConstraints.range(2, 100)).build();
    @Internal
    @Description(value="Whether or not to dump system and database diagnostics. This takes a non-negligible amount of time to do and therefore test databases can disable this to reduce startup times")
    public static final Setting<Boolean> dump_diagnostics = SettingImpl.newBuilder("unsupported.dbms.dump_diagnostics", SettingValueParsers.BOOL, Boolean.TRUE).build();
    @Internal
    public static final Setting<Boolean> track_tx_statement_close = SettingImpl.newBuilder("unsupported.dbms.debug.track_tx_statement_close", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Boolean> trace_tx_statements = SettingImpl.newBuilder("unsupported.dbms.debug.trace_tx_statement", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Boolean> track_cursor_close = SettingImpl.newBuilder("unsupported.dbms.debug.track_cursor_close", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Boolean> trace_cursors = SettingImpl.newBuilder("unsupported.dbms.debug.trace_cursors", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Duration> page_cache_tracer_speed_reporting_threshold = SettingImpl.newBuilder("unsupported.dbms.debug.page_cache_tracer_speed_reporting_threshold", SettingValueParsers.DURATION, Duration.ofSeconds(10L)).build();
    @Internal
    public static final Setting<Boolean> log_recover_index_samples = SettingImpl.newBuilder("unsupported.dbms.index.sampling.log_recovered_samples", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Boolean> async_recover_index_samples = SettingImpl.newBuilder("unsupported.dbms.index.sampling.async_recovery", SettingValueParsers.BOOL, true).immutable().build();
    @Internal
    public static final Setting<Boolean> async_recover_index_samples_wait = SettingImpl.newBuilder("unsupported.dbms.index.sampling.async_recovery_wait", SettingValueParsers.BOOL, null).setDependency(async_recover_index_samples).build();
    @Internal
    public static final Setting<Boolean> recovery_ignore_store_id_validation = SettingImpl.newBuilder("unsupported.dbms.recovery.ignore_store_id_validation", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Boolean> enable_transaction_heap_allocation_tracking = SettingImpl.newBuilder("unsupported.dbms.enable_transaction_heap_allocation_tracking", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Long> initial_transaction_heap_grab_size = SettingImpl.newBuilder("unsupported.dbms.initial_transaction_heap_grab_size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)2L)).build();
    @Internal
    public static final Setting<Boolean> strictly_prioritize_id_freelist = SettingImpl.newBuilder("unsupported.dbms.strictly_prioritize_id_freelist", SettingValueParsers.BOOL, true).build();
    @Internal
    public static final Setting<Long> index_populator_block_size = SettingImpl.newBuilder("unsupported.dbms.index.populator_block_size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)1L)).addConstraint(SettingConstraints.min(20L)).addConstraint(SettingConstraints.max(Integer.MAX_VALUE)).build();
    @Internal
    public static final Setting<Integer> index_populator_merge_factor = SettingImpl.newBuilder("unsupported.dbms.index.populator_merge_factor", SettingValueParsers.INT, 8).build();
    @Internal
    public static final Setting<Boolean> id_generator_log_enabled = SettingImpl.newBuilder("unsupported.dbms.idgenerator.log.enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Long> id_generator_log_rotation_threshold = SettingImpl.newBuilder("unsupported.dbms.idgenerator.log.rotation_threshold", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)200L)).build();
    @Internal
    public static final Setting<Duration> id_generator_log_prune_threshold = SettingImpl.newBuilder("unsupported.dbms.idgenerator.log.prune_threshold", SettingValueParsers.DURATION, Duration.ofDays(2L)).build();
    @Internal
    public static final Setting<Boolean> token_scan_write_log_enabled = SettingImpl.newBuilder("unsupported.dbms.tokenscan.log.enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Long> token_scan_write_log_rotation_threshold = SettingImpl.newBuilder("unsupported.dbms.tokenscan.log.rotation_threshold", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)200L)).build();
    @Internal
    public static final Setting<Duration> token_scan_write_log_prune_threshold = SettingImpl.newBuilder("unsupported.dbms.tokenscan.log.prune_threshold", SettingValueParsers.DURATION, Duration.ofDays(2L)).build();
    @Internal
    public static final Setting<Boolean> print_page_buffer_allocation_trace = SettingImpl.newBuilder("unsupported.dbms.debug.print_page_buffer_allocation_trace", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Boolean> index_population_print_debug = SettingImpl.newBuilder("unsupported.dbms.index.population_print_debug", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Integer> index_population_queue_threshold = SettingImpl.newBuilder("unsupported.dbms.index.population_queue_threshold", SettingValueParsers.INT, 20000).build();
    @Internal
    public static final Setting<Long> index_population_batch_max_byte_size = SettingImpl.newBuilder("unsupported.dbms.index.population_batch_max_byte_size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)10L)).addConstraint(SettingConstraints.max(Integer.MAX_VALUE)).build();
    @Internal
    public static final Setting<Duration> config_command_evaluation_timeout = SettingImpl.newBuilder("unsupported.dbms.config.command_evaluation_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).build();
    @Internal
    @Description(value="Whether or not to do additional checks for locks when making changes as part of commit. This may be expensive to enable.")
    public static final Setting<Boolean> additional_lock_verification = SettingImpl.newBuilder("unsupported.dbms.extra_lock_verification", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Boolean> io_controller_consider_external_io = SettingImpl.newBuilder("unsupported.dbms.io.controller.consider.external.enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Internal
    @Description(value="Whether or not DBMS's byte buffer manager should be used for network stack buffers instead of each network library managing its buffers on its own")
    public static final Setting<Boolean> managed_network_buffers = SettingImpl.newBuilder("unsupported.dbms.memory.managed_network_buffers", SettingValueParsers.BOOL, false).build();
    @Internal
    public static final Setting<Duration> neo_byte_buffer_pool_collection_interval_override = SettingImpl.newBuilder("unsupported.dbms.memory.neo_byte_buffer_pool.collection_interval_override", SettingValueParsers.DURATION, null).build();
    @Internal
    public static final Setting<List<String>> neo_byte_buffer_pool_buckets_override = SettingImpl.newBuilder("unsupported.dbms.memory.neo_byte_buffer_pool.buckets_override", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of()).build();
    @Internal
    public static Setting<Integer> counts_store_max_cached_entries = SettingImpl.newBuilder("unsupported.dbms.memory.counts_store_max_cached_entries", SettingValueParsers.INT, 1000000).build();
    @Internal
    @Description(value="Whether or not to use multiple threads whilst performing recovery. Provides performance improvement for some workloads.")
    public static final Setting<Boolean> do_parallel_recovery = SettingImpl.newBuilder("unsupported.dbms.recovery.enable_parallelism", SettingValueParsers.BOOL, false).build();
    @Description(value="Name of storage engine to use when creating new databases (except system database). If null or empty string then a default will be used.This setting will not be used for loading existing databases, where instead the appropriate storage engine for the specific database will be used")
    @Internal
    public static final Setting<String> storage_engine = SettingImpl.newBuilder("unsupported.dbms.storage_engine", SettingValueParsers.STRING, "record").build();
    @Internal
    @Description(value="Whether or not to log contents of data that is inconsistent when deleting it.")
    public static final Setting<Boolean> log_inconsistent_data_deletion = SettingImpl.newBuilder("dbms.log_inconsistent_data_deletion", SettingValueParsers.BOOL, Boolean.FALSE).dynamic().build();
    @Internal
    @Description(value="Feature flag to enable/disable text indexes")
    public static final Setting<Boolean> text_indexes_enabled = SettingImpl.newBuilder("unsupported.dbms.text_indexes_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Limits the maximum amount of off-heap memory the consistency checker will allocate. The value is given as a factor between 0.1 .. 1 and will be multiplied with actual available memory to get the effectively available amount of memory taken into consideration")
    public static final Setting<Double> consistency_check_memory_limit_factor = SettingImpl.newBuilder("unsupported.consistency_checker.memory_limit_factor", SettingValueParsers.DOUBLE, 0.9).addConstraint(SettingConstraints.min(0.1)).addConstraint(SettingConstraints.max(1.0)).build();

    public static enum SplittingTopBehavior {
        DEFAULT,
        DISALLOW;

    }

    public static enum CypherParser {
        DEFAULT,
        PARBOILED,
        JAVACC;

    }

    public static enum CypherPipelinedInterpretedPipesFallback {
        DISABLED,
        DEFAULT,
        ALL,
        WHITELISTED_PLANS_ONLY;

    }

    public static enum CypherOperatorEngine {
        DEFAULT,
        COMPILED,
        INTERPRETED;

    }

    public static enum CypherReplanAlgorithm {
        DEFAULT,
        NONE,
        INVERSE,
        EXPONENTIAL;

    }

    public static enum CypherExpressionEngine {
        DEFAULT,
        INTERPRETED,
        COMPILED,
        ONLY_WHEN_HOT;

    }

    public static enum CypherRuntime {
        DEFAULT,
        INTERPRETED,
        SLOTTED,
        PIPELINED;

    }
}

