/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.helpers.DatabaseNamePattern;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;

public class FromPaths {
    private final Set<Path> paths;
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    public FromPaths(String value) {
        FromPaths.validateNotEmpty(value);
        this.paths = this.buildPaths(value);
    }

    public boolean isSingle() {
        return this.paths.size() == 1;
    }

    public Set<Path> getPaths() {
        return this.paths;
    }

    private Set<Path> getAllFolders(Path path) throws IOException {
        return Arrays.stream(this.fs.listFiles(path)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    private Set<Path> buildPaths(String value) {
        String[] tokens = value.split(",");
        return Arrays.stream(tokens).map(String::trim).filter(t -> !t.isEmpty()).map(path -> new File((String)path).getAbsoluteFile()).peek(file -> {
            FromPaths.validateParentPath(file);
            FromPaths.validateLastSubPath(file);
        }).flatMap(IOUtils.uncheckedFunction(file -> this.getAndFilterPaths((File)file).stream())).collect(Collectors.toSet());
    }

    private Set<Path> getAndFilterPaths(File file) throws IOException {
        String parent = file.getParent();
        DatabaseNamePattern pattern = new DatabaseNamePattern(file.getName());
        if (!pattern.containsPattern()) {
            return Set.of(Path.of(file.toString(), new String[0]));
        }
        return this.getAllFolders(Path.of(parent, new String[0])).stream().filter(path -> {
            Path name = path.getName(path.getNameCount() - 1);
            return pattern.matches(name.toString());
        }).collect(Collectors.toSet());
    }

    private static void validateParentPath(File file) {
        String parentPath = file.getParent();
        if (parentPath != null && !parentPath.trim().isEmpty()) {
            int asterisks = StringUtils.countMatches((CharSequence)parentPath, (char)'*');
            int questionMarks = StringUtils.countMatches((CharSequence)parentPath, (char)'?');
            if (asterisks > 0 || questionMarks > 0) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is illegal. Asterisks and question marks should be placed in the last subpath");
            }
        } else {
            throw new IllegalArgumentException("From path with value=" + file.getAbsolutePath() + " should not point to the root of the file system");
        }
    }

    private static void validateLastSubPath(File file) {
        if (file.getParent() == null || Path.of(file.getParent(), new String[0]).getNameCount() == 0) {
            throw new IllegalArgumentException("From path with value=" + file.getAbsolutePath() + " should not point to the root of the file system");
        }
        String lastSubPath = file.getName();
        try {
            new DatabaseNamePattern(lastSubPath);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Last path of " + file.getAbsolutePath() + " is in illegal format.", ex);
        }
    }

    private static void validateNotEmpty(String path) {
        Objects.requireNonNull(path, "The provided from parameter is empty.");
        if (path.trim().isEmpty()) {
            throw new IllegalArgumentException("The provided from parameter is empty.");
        }
    }
}

