/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.CharUtils;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;

public class DatabaseNameValidator {
    public static final int MINIMUM_DATABASE_NAME_LENGTH = 3;
    public static final int MAXIMUM_DATABASE_NAME_LENGTH = 63;
    private static final Pattern DATABASE_NAME_PATTERN = Pattern.compile("^[a-z0-9-.]+$");
    private static final Pattern DATABASE_NAME_GLOBBING_PATTERN = Pattern.compile("^[a-z0-9-.*?]+$");

    public static void validateExternalDatabaseName(NormalizedDatabaseName normalizedName) {
        DatabaseNameValidator.validateInternalDatabaseName(normalizedName);
        String name = normalizedName.name();
        if (name.startsWith("system")) {
            throw new IllegalArgumentException("Database name '" + name + "' is invalid, due to the prefix 'system'.");
        }
    }

    public static void validateInternalDatabaseName(NormalizedDatabaseName normalizedName) {
        Objects.requireNonNull(normalizedName, "The provided database name is empty.");
        String name = normalizedName.name();
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The provided database name is empty.");
        }
        if (name.length() < 3 || name.length() > 63) {
            throw new IllegalArgumentException("The provided database name must have a length between 3 and 63 characters.");
        }
        if (!CharUtils.isAsciiAlphaLower((char)name.charAt(0))) {
            throw new IllegalArgumentException("Database name '" + name + "' is not starting with an ASCII alphabetic character.");
        }
        if (!DATABASE_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Database name '" + name + "' contains illegal characters. Use simple ascii characters, numbers, dots and dashes.");
        }
    }

    public static String validateDatabaseNamePattern(String name) {
        Objects.requireNonNull(name, "The provided database name is empty.");
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("The provided database name is empty.");
        }
        if ((name = name.toLowerCase()).length() > 63) {
            throw new IllegalArgumentException("The provided database name must have a length between 1 and 63 characters.");
        }
        if (!DATABASE_NAME_GLOBBING_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Database name '" + name + "' contains illegal characters. Use simple ascii characters, numbers, dots, question marks, asterisk and dashes.");
        }
        return name;
    }
}

