/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.util.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.configuration.BufferingLog;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.GroupSetting;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.configuration.SettingObserver;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.Log;
import org.neo4j.service.Services;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;

@IgnoreApiCheck
public class Config
implements Configuration {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";
    protected final Map<String, Entry<?>> settings = new HashMap();
    private final Map<Class<? extends GroupSetting>, Map<String, GroupSetting>> allGroupInstances = new HashMap<Class<? extends GroupSetting>, Map<String, GroupSetting>>();
    private Log log;
    private final boolean expandCommands;
    private final Configuration validationConfig = new ValidationConfig();
    static final int DEFAULT_COMMAND_EVALUATION_TIMEOUT = 30;
    private final int commandEvaluationTimeout = FeatureToggles.getInteger(Config.class, (String)"CommandEvaluationTimeout", (int)30);

    public static Config defaults() {
        return Config.defaults(Map.of());
    }

    public static <T> Config defaults(Setting<T> setting, T value) {
        return Config.defaults(Map.of(setting, value));
    }

    public static Config defaults(Map<Setting<?>, Object> settingValues) {
        return Config.newBuilder().set(settingValues).build();
    }

    public static Builder newBuilder() {
        Builder builder = new Builder();
        Services.loadAll(SettingsDeclaration.class).forEach(decl -> builder.addSettingsClass(decl.getClass()));
        Services.loadAll(GroupSetting.class).forEach(decl -> builder.addGroupSettingClass(decl.getClass()));
        Services.loadAll(SettingMigrator.class).forEach(builder::addMigrator);
        return builder;
    }

    public static Builder emptyBuilder() {
        return new Builder();
    }

    protected Config() {
        this.expandCommands = false;
    }

    private Config(Collection<Class<? extends SettingsDeclaration>> settingsClasses, Collection<Class<? extends GroupSetting>> groupSettingClasses, Collection<SettingMigrator> settingMigrators, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Map<String, Object> overriddenDefaultObjects, Config fromConfig, Log log, boolean expandCommands) {
        this.log = log;
        this.expandCommands = expandCommands;
        if (expandCommands) {
            log.info("Command expansion is explicitly enabled for configuration");
        }
        HashMap<String, String> overriddenDefaultStrings = new HashMap<String, String>();
        try {
            settingMigrators.forEach(migrator -> migrator.migrate(settingValueStrings, overriddenDefaultStrings, log));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Error while migrating settings, please see the exception cause", e);
        }
        Map<String, SettingImpl<?>> definedSettings = Config.getDefinedSettings(settingsClasses);
        Map<String, Class<? extends GroupSetting>> definedGroups = Config.getDefinedGroups(groupSettingClasses);
        HashSet<String> keys = new HashSet<String>(definedSettings.keySet());
        keys.addAll(settingValueStrings.keySet());
        keys.addAll(settingValueObjects.keySet());
        ArrayList newSettings = new ArrayList();
        if (fromConfig != null) {
            fromConfig.allGroupInstances.forEach((cls, fromGroupMap) -> {
                Map groupMap = this.allGroupInstances.computeIfAbsent((Class<? extends GroupSetting>)cls, k -> new HashMap());
                groupMap.putAll(fromGroupMap);
            });
            for (Map.Entry<String, Entry<?>> entry : fromConfig.settings.entrySet()) {
                newSettings.add(entry.getValue().setting);
                keys.remove(entry.getKey());
            }
        }
        boolean strict = (Boolean)GraphDatabaseSettings.strict_config_validation.defaultValue();
        if (keys.remove(GraphDatabaseSettings.strict_config_validation.name())) {
            this.evaluateSetting(GraphDatabaseSettings.strict_config_validation, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects);
            strict = this.get(GraphDatabaseSettings.strict_config_validation);
        }
        newSettings.addAll(this.getActiveSettings(keys, definedGroups, definedSettings, strict));
        this.evaluateSettingValues(newSettings, settingValueStrings, settingValueObjects, overriddenDefaultStrings, overriddenDefaultObjects, fromConfig);
    }

    private void evaluateSettingValues(Collection<SettingImpl<?>> settingsToEvaluate, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Map<String, String> overriddenDefaultStrings, Map<String, Object> overriddenDefaultObjects, Config fromConfig) {
        ArrayDeque newSettings = new ArrayDeque(settingsToEvaluate);
        while (!newSettings.isEmpty()) {
            SettingImpl setting;
            boolean modified = false;
            SettingImpl last = (SettingImpl)newSettings.peekLast();
            HashMap<SettingImpl, SettingImpl<Object>> dependencies = new HashMap<SettingImpl, SettingImpl<Object>>();
            do {
                setting = Objects.requireNonNull((SettingImpl)newSettings.pollFirst());
                boolean retry = false;
                if (setting.dependency() != null && !this.settings.containsKey(setting.dependency().name())) {
                    dependencies.put(setting, setting.dependency());
                    retry = true;
                } else {
                    try {
                        this.evaluateSetting(setting, settingValueStrings, settingValueObjects, fromConfig, overriddenDefaultStrings, overriddenDefaultObjects);
                        modified = true;
                    }
                    catch (AccessDuringEvaluationException e) {
                        dependencies.put(setting, (SettingImpl<Object>)e.getAttemptedAccess());
                        retry = true;
                    }
                }
                if (!retry) continue;
                newSettings.addLast(setting);
            } while (setting != last);
            if (modified || newSettings.isEmpty()) continue;
            String unsolvable = newSettings.stream().map(s -> String.format("'%s'->'%s'", s.name(), ((Setting)dependencies.get(s)).name())).collect(Collectors.joining(",\n", "[", "]"));
            throw new IllegalArgumentException(String.format("Can not resolve setting dependencies. %s depend on settings not present in config, or are in a circular dependency ", unsolvable));
        }
    }

    private Collection<SettingImpl<?>> getActiveSettings(Set<String> settingNames, Map<String, Class<? extends GroupSetting>> definedGroups, Map<String, SettingImpl<?>> declaredSettings, boolean strict) {
        ArrayList newSettings = new ArrayList();
        for (String key : settingNames) {
            GroupSetting group;
            Map groupInstances;
            String id;
            SettingImpl<?> setting = declaredSettings.get(key);
            if (setting != null) {
                newSettings.add(setting);
                continue;
            }
            Optional<Map.Entry> groupEntryOpt = definedGroups.entrySet().stream().filter(e -> key.startsWith((String)e.getKey() + ".")).findAny();
            if (groupEntryOpt.isEmpty()) {
                String msg = String.format("Unrecognized setting. No declared setting with name: %s", key);
                if (strict) {
                    throw new IllegalArgumentException(msg);
                }
                this.log.warn(msg);
                continue;
            }
            Map.Entry groupEntry = groupEntryOpt.get();
            String prefix = (String)groupEntry.getKey();
            String keyWithoutPrefix = key.substring(prefix.length() + 1);
            if (keyWithoutPrefix.matches("^[^.]+$")) {
                id = keyWithoutPrefix;
            } else if (keyWithoutPrefix.matches("^[^.]+\\.[^.]+$")) {
                id = keyWithoutPrefix.substring(0, keyWithoutPrefix.indexOf(46));
            } else {
                String msg = String.format("Malformed group setting name: '%s', does not match any setting in its group.", key);
                if (strict) {
                    throw new IllegalArgumentException(msg);
                }
                this.log.warn(msg);
                continue;
            }
            if ((groupInstances = this.allGroupInstances.computeIfAbsent((Class)groupEntry.getValue(), k -> new HashMap())).containsKey(id)) continue;
            try {
                group = (GroupSetting)Config.createStringInstance((Class)groupEntry.getValue(), id);
            }
            catch (IllegalArgumentException e2) {
                String msg = String.format("Unrecognized setting. No declared setting with name: %s", key);
                if (strict) {
                    throw new IllegalArgumentException(msg);
                }
                this.log.warn(msg);
                continue;
            }
            groupInstances.put(id, group);
            Map<String, SettingImpl<?>> definedSettings = Config.getDefinedSettings(group.getClass(), group);
            if (definedSettings.values().stream().anyMatch(SettingImpl::dynamic)) {
                throw new IllegalArgumentException(String.format("Group setting can not be dynamic: '%s'", key));
            }
            newSettings.addAll(definedSettings.values());
        }
        return newSettings;
    }

    private void evaluateSetting(Setting<?> untypedSetting, Map<String, String> settingValueStrings, Map<String, Object> settingValueObjects, Config fromConfig, Map<String, String> overriddenDefaultStrings, Map<String, Object> overriddenDefaultObjects) {
        SettingImpl setting = (SettingImpl)untypedSetting;
        String key = setting.name();
        try {
            Object defaultValue = null;
            if (overriddenDefaultObjects.containsKey(key)) {
                defaultValue = overriddenDefaultObjects.get(key);
            } else if (overriddenDefaultStrings.containsKey(key)) {
                defaultValue = setting.parse(this.evaluateIfCommand(key, overriddenDefaultStrings.get(key)));
            } else {
                Object fromDefault;
                defaultValue = setting.defaultValue();
                if (fromConfig != null && fromConfig.settings.containsKey(key) && !Objects.equals(defaultValue, fromDefault = fromConfig.settings.get((Object)key).defaultValue)) {
                    defaultValue = fromDefault;
                }
            }
            Object value = null;
            if (settingValueObjects.containsKey(key)) {
                value = settingValueObjects.get(key);
            } else if (settingValueStrings.containsKey(key)) {
                value = setting.parse(this.evaluateIfCommand(key, settingValueStrings.get(key)));
            } else if (fromConfig != null && fromConfig.settings.containsKey(key)) {
                Entry<?> entry = fromConfig.settings.get(key);
                value = entry.isDefault ? null : entry.value;
            }
            value = setting.solveDefault(value, defaultValue);
            this.settings.put(key, this.createEntry(setting, value, defaultValue));
        }
        catch (AccessDuringEvaluationException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            String msg = String.format("Error evaluating value for setting '%s'. %s", setting.name(), exception.getMessage());
            throw new IllegalArgumentException(msg, exception);
        }
    }

    private String evaluateIfCommand(String settingName, String entry) {
        if (Config.isCommand(entry)) {
            Preconditions.checkArgument((boolean)this.expandCommands, (String)String.format("%s is a command, but config is not explicitly told to expand it.", entry));
            String str = entry.trim();
            String command = str.substring(2, str.length() - 1);
            this.log.info("Executing external script to retrieve value of setting " + settingName);
            return Config.executeCommand(command, this.commandEvaluationTimeout);
        }
        return entry;
    }

    private static boolean isCommand(String entry) {
        String str = entry.trim();
        return str.length() > 3 && str.charAt(0) == '$' && str.charAt(1) == '(' && str.charAt(str.length() - 1) == ')';
    }

    private static String executeCommand(String command, int timeout) {
        Process process = null;
        try {
            String[] commands = CommandLine.parse((String)command).toStrings();
            for (int i = 1; i < commands.length; ++i) {
                String arg = commands[i];
                if (!StringUtils.isQuoted((String)arg)) continue;
                commands[i] = arg.substring(1, arg.length() - 1);
            }
            process = new ProcessBuilder(commands).start();
            BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (!process.waitFor(timeout, TimeUnit.SECONDS)) {
                throw new IllegalArgumentException(String.format("Timed out executing command `%s`", command));
            }
            String output = out.lines().collect(Collectors.joining(System.lineSeparator()));
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                String errOutput = err.lines().collect(Collectors.joining(System.lineSeparator()));
                throw new IllegalArgumentException(String.format("Command `%s` failed with exit code %s.%n%s%n%s", command, exitCode, output, errOutput));
            }
            String string = output;
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalArgumentException("Interrupted while executing command", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    private <T> Entry<T> createEntry(SettingImpl<T> setting, T value, T defaultValue) {
        if (setting.dependency() != null) {
            Entry<?> dep = this.settings.get(setting.dependency().name());
            T solvedValue = setting.solveDependency(value != null ? value : defaultValue, dep.getValue());
            return new DepEntry<T>(setting, value, defaultValue, solvedValue);
        }
        return new Entry<T>(setting, value, defaultValue);
    }

    public <T extends GroupSetting> Map<String, T> getGroups(Class<T> group) {
        return new HashMap(this.allGroupInstances.getOrDefault(group, new HashMap()));
    }

    public <T extends GroupSetting, U extends T> Map<Class<U>, Map<String, U>> getGroupsFromInheritance(Class<T> parentClass) {
        return this.allGroupInstances.keySet().stream().filter(parentClass::isAssignableFrom).map(childClass -> childClass).collect(Collectors.toMap(childClass -> childClass, this::getGroups));
    }

    private static <T> T createInstance(Class<T> classObj) {
        T instance;
        try {
            instance = Config.createStringInstance(classObj, null);
        }
        catch (Exception first) {
            try {
                Constructor<T> constructor = classObj.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception second) {
                String name = classObj.getSimpleName();
                String msg = String.format("Failed to create instance of: %s, please see the exception cause", name);
                throw new IllegalArgumentException(msg, Exceptions.chain((Throwable)second, (Throwable)first));
            }
        }
        return instance;
    }

    public <T> T get(Setting<T> setting) {
        return this.getObserver(setting).getValue();
    }

    public <T> SettingObserver<T> getObserver(Setting<T> setting) {
        SettingObserver observer = this.settings.get(setting.name());
        if (observer != null) {
            return observer;
        }
        throw new IllegalArgumentException(String.format("Config has no association with setting: '%s'", setting.name()));
    }

    public <T> void setDynamic(Setting<T> setting, T value, String scope) {
        Entry entry = (Entry)this.getObserver(setting);
        SettingImpl<T> actualSetting = entry.setting;
        if (!actualSetting.dynamic()) {
            throw new IllegalArgumentException(String.format("Setting '%s' is not dynamic and can not be changed at runtime", setting.name()));
        }
        this.set(setting, value);
        this.log.info("%s changed to %s, by %s", new Object[]{setting.name(), actualSetting.valueToString(value), scope});
    }

    public <T> void set(Setting<T> setting, T value) {
        Entry entry = (Entry)this.getObserver(setting);
        SettingImpl actualSetting = entry.setting;
        if (actualSetting.immutable()) {
            throw new IllegalArgumentException(String.format("Setting '%s' immutable (final). Can not amend", actualSetting.name()));
        }
        entry.setValue(value);
    }

    public <T> void setIfNotSet(Setting<T> setting, T value) {
        Entry entry = (Entry)this.getObserver(setting);
        if (entry == null || entry.isDefault) {
            this.set(setting, value);
        }
    }

    public boolean isExplicitlySet(Setting<?> setting) {
        if (this.settings.containsKey(setting.name())) {
            return !this.settings.get((Object)setting.name()).isDefault;
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeNullValues) {
        StringBuilder sb = new StringBuilder();
        this.settings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            SettingImpl setting = ((Entry)e.getValue()).setting;
            Object valueObj = ((Entry)e.getValue()).getValue();
            if (valueObj != null || includeNullValues) {
                String value = setting.valueToString(valueObj);
                sb.append(String.format("%s=%s%n", e.getKey(), value));
            }
        });
        return sb.toString();
    }

    public void setLogger(Log log) {
        if (this.log instanceof BufferingLog) {
            ((BufferingLog)this.log).replayInto(log);
        }
        this.log = log;
    }

    public Map<Setting<Object>, Object> getValues() {
        HashMap<Setting<Object>, Object> values = new HashMap<Setting<Object>, Object>();
        this.settings.forEach((s, entry) -> values.put(entry.setting, entry.value));
        return values;
    }

    public Setting<Object> getSetting(String name) {
        if (!this.settings.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Setting `%s` not found", name));
        }
        return this.settings.get((Object)name).setting;
    }

    public Map<String, Setting<Object>> getDeclaredSettings() {
        return this.settings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Entry)entry.getValue()).setting));
    }

    private static Map<String, Class<? extends GroupSetting>> getDefinedGroups(Collection<Class<? extends GroupSetting>> groupSettingClasses) {
        return groupSettingClasses.stream().collect(Collectors.toMap(cls -> ((GroupSetting)Config.createInstance(cls)).getPrefix(), cls -> cls));
    }

    private static <T> T createStringInstance(Class<T> cls, String id) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return constructor.newInstance(id);
        }
        catch (Exception e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("Could not create instance with id: " + id, e);
            }
            String msg = String.format("'%s' must have a ( @Nullable String ) constructor, be static & non-abstract", cls.getSimpleName());
            throw new RuntimeException(msg, e);
        }
    }

    private static Map<String, SettingImpl<?>> getDefinedSettings(Collection<Class<? extends SettingsDeclaration>> settingsClasses) {
        HashMap settings = new HashMap();
        settingsClasses.forEach(c -> settings.putAll(Config.getDefinedSettings(c, null)));
        return settings;
    }

    private static Map<String, SettingImpl<?>> getDefinedSettings(Class<?> settingClass, Object fromObject) {
        HashMap settings = new HashMap();
        Arrays.stream(FieldUtils.getAllFields(settingClass)).filter(f -> f.getType().isAssignableFrom(SettingImpl.class)).forEach(field -> {
            try {
                field.setAccessible(true);
                SettingImpl setting = (SettingImpl)field.get(fromObject);
                if (field.isAnnotationPresent(Description.class)) {
                    setting.setDescription(field.getAnnotation(Description.class).value());
                }
                if (field.isAnnotationPresent(DocumentedDefaultValue.class)) {
                    setting.setDocumentedDefaultValue(field.getAnnotation(DocumentedDefaultValue.class).value());
                }
                if (field.isAnnotationPresent(Internal.class)) {
                    setting.setInternal();
                }
                if (field.isAnnotationPresent(Deprecated.class)) {
                    setting.setDeprecated();
                }
                settings.put(setting.name(), setting);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("%s %s, from %s is not accessible.", field.getType(), field.getName(), settingClass.getSimpleName()), e);
            }
        });
        return settings;
    }

    public <T> void addListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Entry entry = (Entry)this.getObserver(setting);
        entry.addListener(listener);
    }

    public <T> void removeListener(Setting<T> setting, SettingChangeListener<T> listener) {
        Entry entry = (Entry)this.getObserver(setting);
        entry.removeListener(listener);
    }

    private class ValidationConfig
    implements Configuration {
        private ValidationConfig() {
        }

        public <T> T get(Setting<T> setting) {
            if (setting.dynamic()) {
                throw new IllegalArgumentException("Can not depend on dynamic setting:" + setting.name());
            }
            if (!Config.this.settings.containsKey(setting.name())) {
                throw new AccessDuringEvaluationException(setting);
            }
            return Config.this.get(setting);
        }
    }

    private static class AccessDuringEvaluationException
    extends RuntimeException {
        private final Setting<?> attemptedAccess;

        AccessDuringEvaluationException(Setting<?> attemptedAccess) {
            super(String.format("AccessDuringEvaluationException{ Tried to access %s in config during construction }", attemptedAccess.name()));
            this.attemptedAccess = attemptedAccess;
        }

        Setting<?> getAttemptedAccess() {
            return this.attemptedAccess;
        }
    }

    private class Entry<T>
    implements SettingObserver<T> {
        protected final SettingImpl<T> setting;
        protected final T defaultValue;
        private final boolean validate;
        private final Collection<SettingChangeListener<T>> updateListeners = new ConcurrentLinkedQueue<SettingChangeListener<T>>();
        private volatile T value;
        private volatile boolean isDefault;

        private Entry(SettingImpl<T> setting, T value, T defaultValue) {
            this(setting, value, defaultValue, true);
        }

        private Entry(SettingImpl<T> setting, T value, T defaultValue, boolean validate) {
            this.setting = setting;
            this.defaultValue = defaultValue;
            this.validate = validate;
            this.internalSetValue(value);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        synchronized void setValue(T value) {
            T oldValue = this.value;
            this.internalSetValue(value);
            this.notifyListeners(oldValue, this.value);
        }

        void internalSetValue(T value) {
            this.isDefault = value == null;
            T t = this.value = this.isDefault ? this.defaultValue : value;
            if (this.validate) {
                this.setting.validate(this.value, Config.this.validationConfig);
            }
        }

        protected void notifyListeners(T oldValue, T newValue) {
            this.updateListeners.forEach(listener -> listener.accept(oldValue, newValue));
        }

        private void addListener(SettingChangeListener<T> listener) {
            if (!this.setting.dynamic()) {
                throw new IllegalArgumentException("Setting is not dynamic and will not change");
            }
            this.updateListeners.add(listener);
        }

        private void removeListener(SettingChangeListener<T> listener) {
            this.updateListeners.remove(listener);
        }

        public String toString() {
            return this.setting.valueToString(this.value) + (this.isDefault ? " (default)" : " (configured)");
        }
    }

    private class DepEntry<T>
    extends Entry<T> {
        private volatile T solved;

        private DepEntry(SettingImpl<T> setting, T value, T defaultValue, T solved) {
            super(setting, value, defaultValue, false);
            this.solved = solved;
            setting.validate(solved, Config.this.validationConfig);
        }

        @Override
        public T getValue() {
            return this.solved;
        }

        @Override
        synchronized void setValue(T value) {
            T oldValue = this.solved;
            this.solved = this.setting.solveDependency(value != null ? value : this.defaultValue, Config.this.getObserver(this.setting.dependency()).getValue());
            this.setting.validate(this.solved, Config.this.validationConfig);
            this.internalSetValue(value);
            this.notifyListeners(oldValue, this.solved);
        }
    }

    public static final class Builder {
        private final Collection<Class<? extends SettingsDeclaration>> settingsClasses = new HashSet<Class<? extends SettingsDeclaration>>();
        private final Collection<Class<? extends GroupSetting>> groupSettingClasses = new HashSet<Class<? extends GroupSetting>>();
        private final Collection<SettingMigrator> settingMigrators = new HashSet<SettingMigrator>();
        private final Map<String, String> settingValueStrings = new HashMap<String, String>();
        private final Map<String, Object> settingValueObjects = new HashMap<String, Object>();
        private final Map<String, Object> overriddenDefaults = new HashMap<String, Object>();
        private final List<Path> configFiles = new ArrayList<Path>();
        private Config fromConfig;
        private final Log log = new BufferingLog();
        private boolean expandCommands;

        private static boolean allowedToLogOverriddenValues(String setting) {
            return !Objects.equals(setting, ExternalSettings.additional_jvm.name());
        }

        private void overrideSettingValue(String setting, Object value) {
            String msg = "The '%s' setting is overridden. Setting value changed from '%s' to '%s'.";
            if (this.settingValueStrings.containsKey(setting) && Builder.allowedToLogOverriddenValues(setting)) {
                this.log.warn(msg, new Object[]{setting, this.settingValueStrings.remove(setting), value});
            }
            if (this.settingValueObjects.containsKey(setting)) {
                this.log.warn(msg, new Object[]{setting, this.settingValueObjects.remove(setting), value});
            }
        }

        private Builder setRaw(String setting, String value) {
            this.overrideSettingValue(setting, value);
            this.settingValueStrings.put(setting, value);
            return this;
        }

        private Builder set(String setting, Object value) {
            this.overrideSettingValue(setting, value);
            this.settingValueObjects.put(setting, value);
            return this;
        }

        public Builder setRaw(Map<String, String> settingValues) {
            settingValues.forEach(this::setRaw);
            return this;
        }

        public <T> Builder set(Setting<T> setting, T value) {
            return this.set(setting.name(), value);
        }

        public Builder set(Map<Setting<?>, Object> settingValues) {
            settingValues.forEach((setting, value) -> this.set(setting.name(), value));
            return this;
        }

        private Builder setDefault(String setting, Object value) {
            if (this.overriddenDefaults.containsKey(setting) && Builder.allowedToLogOverriddenValues(setting)) {
                this.log.warn("The overridden default value of '%s' setting is overridden. Setting value changed from '%s' to '%s'.", new Object[]{setting, this.overriddenDefaults.get(setting), value});
            }
            this.overriddenDefaults.put(setting, value);
            return this;
        }

        public Builder setDefaults(Map<Setting<?>, Object> overriddenDefaults) {
            overriddenDefaults.forEach((setting, value) -> this.setDefault(setting.name(), value));
            return this;
        }

        public <T> Builder setDefault(Setting<T> setting, T value) {
            return this.setDefault(setting.name(), value);
        }

        public Builder remove(Setting<?> setting) {
            this.settingValueStrings.remove(setting.name());
            this.settingValueObjects.remove(setting.name());
            return this;
        }

        public Builder removeDefault(Setting<?> setting) {
            this.overriddenDefaults.remove(setting.name());
            return this;
        }

        Builder addSettingsClass(Class<? extends SettingsDeclaration> settingsClass) {
            this.settingsClasses.add(settingsClass);
            return this;
        }

        Builder addGroupSettingClass(Class<? extends GroupSetting> groupSettingClass) {
            this.groupSettingClasses.add(groupSettingClass);
            return this;
        }

        public Builder addMigrator(SettingMigrator migrator) {
            this.settingMigrators.add(migrator);
            return this;
        }

        public Builder fromConfig(Config config) {
            if (this.fromConfig != null) {
                throw new IllegalArgumentException("Can only build a config from one other config.");
            }
            this.fromConfig = config;
            return this;
        }

        public Builder fromFileNoThrow(Path path) {
            if (path != null) {
                this.fromFile(path, false);
            }
            return this;
        }

        public Builder fromFile(Path cfg) {
            return this.fromFile(cfg, true);
        }

        private Builder fromFile(Path file, boolean allowThrow) {
            block12: {
                if (file == null || Files.notExists(file, new LinkOption[0])) {
                    if (allowThrow) {
                        throw new IllegalArgumentException(new IOException("Config file [" + file + "] does not exist."));
                    }
                    this.log.warn("Config file [%s] does not exist.", new Object[]{file});
                    return this;
                }
                try {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        Files.walkFileTree(file, new ConfigDirectoryFileVisitor(file));
                        break block12;
                    }
                    try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                        new Properties(){

                            @Override
                            public synchronized Object put(Object key, Object value) {
                                this.setRaw(key.toString(), value.toString());
                                return null;
                            }
                        }.load(stream);
                    }
                    this.configFiles.add(file);
                }
                catch (IOException e) {
                    if (allowThrow) {
                        throw new IllegalArgumentException("Unable to load config file [" + file + "].", e);
                    }
                    this.log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
                }
            }
            return this;
        }

        public Builder allowCommandExpansion() {
            return this.commandExpansion(true);
        }

        public Builder commandExpansion(boolean expandCommands) {
            this.expandCommands = expandCommands;
            return this;
        }

        private Builder() {
        }

        public Config build() {
            this.expandCommands |= this.fromConfig != null && this.fromConfig.expandCommands;
            if (this.expandCommands) {
                this.validateFilePermissionForCommandExpansion(this.configFiles);
            }
            return new Config(this.settingsClasses, this.groupSettingClasses, this.settingMigrators, this.settingValueStrings, this.settingValueObjects, this.overriddenDefaults, this.fromConfig, this.log, this.expandCommands);
        }

        private void validateFilePermissionForCommandExpansion(List<Path> files) {
            if (files.isEmpty()) {
                return;
            }
            String processOwner = SystemUtils.getUserName();
            if (SystemUtils.IS_OS_UNIX) {
                String processGroup = Config.executeCommand("id -gn", 30);
                for (Path path : files) {
                    try {
                        Set<PosixFilePermission> unixPermission600 = Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
                        PosixFileAttributes attrs = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
                        Set<PosixFilePermission> permissions = attrs.permissions();
                        if (!unixPermission600.containsAll(permissions)) {
                            throw new IllegalArgumentException(String.format("%s does not have the correct file permissions to evaluate commands. Has %s, requires at most %s.", path, permissions, unixPermission600));
                        }
                        String fileOwner = attrs.owner().getName();
                        if (!fileOwner.equals(processOwner)) {
                            throw new IllegalArgumentException(String.format("%s does not have the correct file owner to evaluate commands. Has %s, requires %s.", path, fileOwner, processOwner));
                        }
                        String fileGroup = attrs.group().getName();
                        if (fileGroup.equals(processGroup)) continue;
                        throw new IllegalArgumentException(String.format("%s does not have the correct file group to evaluate commands. Has %s, requires %s.", path, fileGroup, processGroup));
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        throw new IllegalStateException("Unable to access file permissions for " + path, e);
                    }
                }
            } else if (SystemUtils.IS_OS_WINDOWS) {
                for (Path path : files) {
                    try {
                        AclFileAttributeView attrs = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
                        UserPrincipal owner = attrs.getOwner();
                        Set<AclEntryPermission> windowsUserNoExecute = Set.of(AclEntryPermission.READ_DATA, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_ACL, AclEntryPermission.DELETE, AclEntryPermission.DELETE_CHILD, AclEntryPermission.WRITE_OWNER, AclEntryPermission.SYNCHRONIZE);
                        for (AclEntry acl : attrs.getAcl()) {
                            Set<AclEntryPermission> permissions = acl.permissions();
                            if (!AclEntryType.ALLOW.equals((Object)acl.type())) continue;
                            if (acl.principal().equals(owner)) {
                                if (windowsUserNoExecute.containsAll(permissions)) continue;
                                throw new IllegalArgumentException(String.format("%s does not have the correct ACL for owner to evaluate commands. Has %s for %s, requires at most %s.", path, permissions, acl.principal().getName(), windowsUserNoExecute));
                            }
                            if (permissions.isEmpty()) continue;
                            throw new IllegalArgumentException(String.format("%s does not have the correct ACL. Has %s for %s, should be none for all except owner.", path, permissions, acl.principal().getName()));
                        }
                        String domainAndName = owner.getName();
                        String fileOwner = domainAndName.contains("\\") ? domainAndName.split("\\\\")[1] : domainAndName;
                        if (fileOwner.equals(processOwner)) continue;
                        throw new IllegalArgumentException(String.format("%s does not have the correct file owner to evaluate commands. Has %s, requires %s.", path, domainAndName, processOwner));
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        throw new IllegalStateException("Unable to access file permissions for " + path, e);
                    }
                }
            } else {
                throw new IllegalStateException("Configuration command expansion not supported for " + SystemUtils.OS_NAME);
            }
        }

        private class ConfigDirectoryFileVisitor
        implements FileVisitor<Path> {
            private final Path root;

            ConfigDirectoryFileVisitor(Path root) {
                this.root = root;
            }

            private boolean isRoot(Path dir) {
                return this.root.equals(dir);
            }

            private boolean isNotHidden(Path file) {
                return !file.getFileName().toString().startsWith(".");
            }

            private boolean isFile(Path file, BasicFileAttributes attrs) {
                return attrs.isRegularFile() || Files.isRegularFile(file, new LinkOption[0]);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (this.isRoot(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                if (this.isNotHidden(dir)) {
                    Builder.this.log.warn("Ignoring subdirectory in config directory [" + dir + "].");
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (this.isNotHidden(file) && this.isFile(file, attrs)) {
                    String key = file.getFileName().toString();
                    String value = Files.readString(file);
                    Builder.this.setRaw(key, value);
                    Builder.this.configFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc != null ? exc : new IOException("Unknown failure loading config file [" + file.toAbsolutePath() + "]");
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                return FileVisitResult.CONTINUE;
            }
        }
    }
}

