/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.pagecache;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.pagecache.buffer.NativeIOBuffer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.FeatureToggles;

public class ConfigurableIOBuffer
implements NativeIOBuffer {
    private static final boolean PRINT_ALLOCATION_EXCEPTION = FeatureToggles.flag(ConfigurableIOBuffer.class, (String)"printAllocationException", (boolean)false);
    private static final long NOT_INITIALIZED = 0L;
    private final boolean enabled;
    private final MemoryTracker memoryTracker;
    private final long bufferSize;
    private final long bufferAddress;
    private final long alignedAddress;
    private final long allocatedBytes;
    private boolean closed;

    public ConfigurableIOBuffer(Config config, MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        this.bufferSize = 8192 * config.get(GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages);
        this.allocatedBytes = this.bufferSize + 8192L;
        boolean ioBufferEnabled = true;
        long address = 0L;
        try {
            address = UnsafeUtil.allocateMemory((long)this.allocatedBytes, (MemoryTracker)memoryTracker);
        }
        catch (Throwable t) {
            if (PRINT_ALLOCATION_EXCEPTION) {
                t.printStackTrace();
            }
            ioBufferEnabled = false;
        }
        this.bufferAddress = address;
        this.alignedAddress = address + 8192L - address % 8192L;
        this.enabled = ioBufferEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasMoreCapacity(int used, int requestSize) {
        if (!this.enabled) {
            return false;
        }
        return (long)(used + requestSize) <= this.bufferSize;
    }

    public long getAddress() {
        return this.alignedAddress;
    }

    public void close() {
        if (this.enabled && !this.closed) {
            UnsafeUtil.free((long)this.bufferAddress, (long)this.allocatedBytes, (MemoryTracker)this.memoryTracker);
            this.closed = true;
        }
    }
}

