/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.configuration.helpers.SocketAddress;

public class SocketAddressParser {
    private static final Pattern hostnamePortPatternExt = Pattern.compile("\\[(?<hostname>[^\\s]+)]:(?<port>\\d+)");
    private static final Pattern hostnamePortPattern = Pattern.compile("(?<hostname>[^\\s]*([^:\\s]|::)):(?<port>\\d+)");
    private static final Pattern hostnamePattern = Pattern.compile("(?<hostname>[^\\s]+)");
    private static final Pattern portPattern = Pattern.compile(":(?<port>\\d+)");

    public static <T extends SocketAddress> T deriveSocketAddress(String settingName, String settingValue, String defaultHostname, int defaultPort, BiFunction<String, Integer, T> constructor) {
        if (settingValue == null) {
            return (T)((SocketAddress)constructor.apply(defaultHostname, defaultPort));
        }
        T socketAddress = SocketAddressParser.matchHostnamePort(settingValue = settingValue.trim(), constructor);
        if (socketAddress != null) {
            return socketAddress;
        }
        socketAddress = SocketAddressParser.matchPort(settingValue, defaultHostname, constructor);
        if (socketAddress != null) {
            return socketAddress;
        }
        throw new IllegalArgumentException(String.format("Setting \"%s\" must be in the format \"hostname:port\" or \":port\". \"%s\" does not conform to these formats", settingName, settingValue));
    }

    public static <T extends SocketAddress> T socketAddress(String settingValue, BiFunction<String, Integer, T> constructor) {
        if (settingValue == null) {
            throw new IllegalArgumentException("Cannot parse socket address from null");
        }
        T socketAddress = SocketAddressParser.matchHostnamePort(settingValue = settingValue.trim(), constructor);
        if (socketAddress != null) {
            return socketAddress;
        }
        socketAddress = SocketAddressParser.matchPort(settingValue, null, constructor);
        if (socketAddress != null) {
            return socketAddress;
        }
        socketAddress = SocketAddressParser.matchHostname(settingValue, constructor);
        if (socketAddress != null) {
            return socketAddress;
        }
        throw new IllegalArgumentException(String.format("Configured socket address must be in the format \"hostname:port\". \"%s\" does not conform to this format", settingValue));
    }

    private static <T extends SocketAddress> T matchHostname(String settingValue, BiFunction<String, Integer, T> constructor) {
        Matcher hostnameMatcher = hostnamePattern.matcher(settingValue);
        if (hostnameMatcher.matches()) {
            String hostname = hostnameMatcher.group("hostname");
            return (T)((SocketAddress)constructor.apply(hostname, -1));
        }
        return null;
    }

    private static <T extends SocketAddress> T matchHostnamePort(String settingValue, BiFunction<String, Integer, T> constructor) {
        Matcher hostnamePortWithBracketsMatcher = hostnamePortPatternExt.matcher(settingValue);
        if (hostnamePortWithBracketsMatcher.matches()) {
            String hostname = hostnamePortWithBracketsMatcher.group("hostname");
            int port = Integer.parseInt(hostnamePortWithBracketsMatcher.group("port"));
            return (T)((SocketAddress)constructor.apply(hostname, port));
        }
        Matcher hostnamePortMatcher = hostnamePortPattern.matcher(settingValue);
        if (hostnamePortMatcher.matches()) {
            String hostname = hostnamePortMatcher.group("hostname");
            int port = Integer.parseInt(hostnamePortMatcher.group("port"));
            return (T)((SocketAddress)constructor.apply(hostname, port));
        }
        return null;
    }

    private static <T extends SocketAddress> T matchPort(String settingValue, String defaultHostname, BiFunction<String, Integer, T> constructor) {
        Matcher portMatcher = portPattern.matcher(settingValue);
        if (portMatcher.matches()) {
            int port = Integer.parseInt(portMatcher.group("port"));
            return (T)((SocketAddress)constructor.apply(defaultHostname, port));
        }
        return null;
    }
}

