/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.database.readonly;

import java.util.Optional;
import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.database.DatabaseId;

public final class ConfigBasedLookupFactory
implements ReadOnlyDatabases.LookupFactory {
    private final Config config;
    private final DatabaseIdResolver databaseIdResolver;

    public ConfigBasedLookupFactory(Config config, DatabaseIdResolver databaseIdResolver) {
        this.config = config;
        this.databaseIdResolver = databaseIdResolver;
    }

    public ReadOnlyDatabases.Lookup lookupReadOnlyDatabases() {
        return new ConfigLookup(this.databaseIdResolver, this.config.get(GraphDatabaseSettings.read_only_database_default), this.config.get(GraphDatabaseSettings.read_only_databases), this.config.get(GraphDatabaseSettings.writable_databases));
    }

    public static interface DatabaseIdResolver {
        public Optional<DatabaseId> resolve(String var1);
    }

    private record ConfigLookup(DatabaseIdResolver databaseIdResolver, boolean readOnlyDefault, Set<String> readOnlyDatabaseNames, Set<String> writableDatabaseNames) implements ReadOnlyDatabases.Lookup
    {
        public boolean databaseIsReadOnly(DatabaseId databaseId) {
            return this.explicitlyReadOnly(databaseId) || this.implicitlyReadOnly(databaseId);
        }

        public ReadOnlyDatabases.Lookup.Source source() {
            return ReadOnlyDatabases.Lookup.Source.CONFIG;
        }

        private boolean explicitlyReadOnly(DatabaseId databaseId) {
            return this.containsDatabaseId(this.readOnlyDatabaseNames, databaseId);
        }

        private boolean implicitlyReadOnly(DatabaseId databaseId) {
            return this.readOnlyDefault && !this.containsDatabaseId(this.writableDatabaseNames, databaseId);
        }

        private boolean containsDatabaseId(Set<String> names, DatabaseId databaseId) {
            return names.stream().flatMap(name -> this.databaseIdResolver.resolve((String)name).stream()).anyMatch(arg_0 -> ((DatabaseId)databaseId).equals(arg_0));
        }
    }
}

