/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;

public final class BoltConnectorInternalSettings
implements SettingsDeclaration {
    public static final String LOOPBACK_NAME = "bolt-loopback";
    public static final String LOCAL_NAME = "bolt-local";
    public static final SettingValueParser<ConfiguredProtocolVersion> PROTOCOL_VERSION = new SettingValueParser<ConfiguredProtocolVersion>(){

        @Override
        public ConfiguredProtocolVersion parse(String value) {
            String trimmedValue = value.trim();
            return Optional.of(trimmedValue).map(trimmed -> trimmed.split("\\.")).filter(partsArr -> ((String[])partsArr).length == 2).map(List::of).map(partsList -> partsList.stream().map(maybeInt -> {
                try {
                    return Integer.parseInt(maybeInt);
                }
                catch (NumberFormatException ignored) {
                    return null;
                }
            }).filter(Objects::nonNull).toList()).filter(partsInt -> partsInt.size() == 2).map(partsInt -> new ConfiguredProtocolVersion((Integer)partsInt.get(0), (Integer)partsInt.get(1))).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not a valid protocol version value, must be '<major>.<minor>'", value)));
        }

        @Override
        public String getDescription() {
            return "a protocol version (<major>.<minor>)";
        }

        @Override
        public Class<ConfiguredProtocolVersion> getType() {
            return ConfiguredProtocolVersion.class;
        }
    };
    @Internal
    @Description(value="Enable protocol level logging for incoming connections on the Bolt connector")
    public static final Setting<Boolean> protocol_logging = SettingImpl.newBuilder("internal.server.bolt.protocol_logging", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Selects the format in which protocol level log messages are formatted (RAW for wire format, DECODED for decoded server view, BOTH for both formats)")
    public static final Setting<ProtocolLoggingMode> protocol_logging_mode = SettingImpl.newBuilder("internal.server.bolt.protocol_logging_mode", SettingValueParsers.ofEnum(ProtocolLoggingMode.class), ProtocolLoggingMode.DECODED).build();
    @Internal
    @Description(value="Enable capture of traffic logging for incoming connections on the Bolt connector")
    public static final Setting<Boolean> protocol_capture = SettingImpl.newBuilder("internal.server.bolt.protocol_capture", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Path of the data directory. You must not configure more than one Neo4j installation to use the same data directory.")
    public static final Setting<Path> protocol_capture_path = SettingImpl.newBuilder("internal.server.bolt.protocol_capture_path", SettingValueParsers.PATH, Path.of("bolt_capture", new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Internal
    @Description(value="Enable/disable the use of native transports for netty")
    public static final Setting<Boolean> use_native_transport = SettingImpl.newBuilder("internal.dbms.bolt.netty_server_use_native_transport", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="The queue size of the thread pool bound to this connector (-1 for unbounded, 0 for direct handoff, > 0 for bounded)")
    public static final Setting<Integer> unsupported_thread_pool_queue_size = SettingImpl.newBuilder("internal.server.bolt.thread_pool_queue_size", SettingValueParsers.INT, 0).build();
    @Internal
    @Description(value="Enable TCP keep alive probes on this connector")
    public static final Setting<Boolean> tcp_keep_alive = SettingImpl.newBuilder("internal.server.bolt.tcp_keep_alive", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="The maximum time to wait for a user to finish authentication before closing the connection.")
    public static final Setting<Duration> unsupported_bolt_unauth_connection_timeout = SettingImpl.newBuilder("internal.server.bolt.unauth_connection_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).build();
    @Internal
    @Description(value="The maximum inbound message size in bytes are allowed before a connection is authenticated.")
    public static final Setting<Long> unsupported_bolt_unauth_connection_max_inbound_bytes = SettingImpl.newBuilder("internal.server.bolt.unauth_max_inbound_bytes", SettingValueParsers.BYTES, ByteUnit.kibiBytes((long)8L)).build();
    @Internal
    @Description(value="The maximum amount of elements within incoming Packstream messages permitted before a connection is authenticated (0 for disabled, > 0 for limited).")
    public static final Setting<Integer> bolt_unauth_connection_max_structure_elements = SettingImpl.newBuilder("internal.server.bolt.unauth_max_structure_elements", SettingValueParsers.INT, 64).addConstraint(SettingConstraints.range(0, Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="The maximum amount of depth within incoming Packstream messages permitted before a connection is authenticated (0 for disabled, > 0 for limited).")
    public static final Setting<Integer> bolt_unauth_connection_max_structure_depth = SettingImpl.newBuilder("internal.server.bolt.unauth_max_structure_depth", SettingValueParsers.INT, 4).addConstraint(SettingConstraints.range(0, Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="The absolute path of the file for use with the Unix Domain Socket based loopback interface. This file must be specified and will be created at runtime and deleted on shutdown.")
    public static final Setting<Path> unsupported_loopback_listen_file = SettingImpl.newBuilder("internal.dbms.loopback_file", SettingValueParsers.PATH, null).build();
    @Internal
    @Description(value="Whether or not to delete an existing file for use with the Unix Domain Socket based loopback interface. This improves the handling of the case where a previous hard shutdown was unable to delete the file.")
    public static final Setting<Boolean> unsupported_loopback_delete = SettingImpl.newBuilder("internal.dbms.loopback_delete", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable or disable the bolt loopback connector. A user successfully authenticated over this will execute all queries with no security restrictions. This includes overriding the `internal.dbms.block_create_drop_database`, `internal.dbms.block_start_stop_database` and `internal.dbms.upgrade_restriction_enabled` settings.")
    public static final Setting<Boolean> enable_loopback_auth = SettingImpl.newBuilder("internal.dbms.loopback_enabled", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="The maximum time to wait for the thread pool to finish processing its pending jobs and shutdown")
    public static final Setting<Duration> thread_pool_shutdown_wait_time = SettingImpl.newBuilder("internal.server.bolt.thread_pool_shutdown_wait_time", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).build();
    @Internal
    @Description(value="The maximum time to wait for a connection to shut down before issuing a warning")
    public static final Setting<Duration> connection_shutdown_wait_time = SettingImpl.newBuilder("internal.server.bolt.connection_shutdown_wait_time", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).build();
    @Internal
    @Description(value="Whether to apply network level outbound network buffer based throttling")
    public static final Setting<Boolean> bolt_outbound_buffer_throttle = SettingImpl.newBuilder("internal.dbms.bolt.outbound_buffer_throttle", SettingValueParsers.BOOL, true).dynamic().build();
    @Internal
    @Description(value="When the size (in bytes) of outbound network buffers, used by bolt's network layer, grows beyond this value bolt channel will advertise itself as unwritable and will block related processing thread until it becomes writable again.")
    public static final Setting<Integer> bolt_outbound_buffer_throttle_high_water_mark = SettingImpl.newBuilder("internal.dbms.bolt.outbound_buffer_throttle.high_watermark", SettingValueParsers.INT, (int)ByteUnit.kibiBytes((long)512L)).addConstraint(SettingConstraints.range((int)ByteUnit.kibiBytes((long)64L), Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="When the size (in bytes) of outbound network buffers, previously advertised as unwritable, gets below this value bolt channel will re-advertise itself as writable and blocked processing thread will resume execution.")
    public static final Setting<Integer> bolt_outbound_buffer_throttle_low_water_mark = SettingImpl.newBuilder("internal.dbms.bolt.outbound_buffer_throttle.low_watermark", SettingValueParsers.INT, (int)ByteUnit.kibiBytes((long)128L)).addConstraint(SettingConstraints.range((int)ByteUnit.kibiBytes((long)16L), Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="When the total time outbound network buffer based throttle lock is held exceeds this value, the corresponding bolt channel will be aborted. Setting this to 0 will disable this behaviour.")
    public static final Setting<Duration> bolt_outbound_buffer_throttle_max_duration = SettingImpl.newBuilder("internal.dbms.bolt.outbound_buffer_throttle.max_duration", SettingValueParsers.DURATION, Duration.ofMinutes(15L)).addConstraint(SettingConstraints.any(SettingConstraints.min(Duration.ofSeconds(30L)), SettingConstraints.is(Duration.ZERO))).build();
    @Internal
    @Description(value="When the number of queued inbound messages grows beyond this value, reading from underlying channel will be paused (no more inbound messages will be available) until queued number of messages drops below the configured low watermark value.")
    public static final Setting<Integer> bolt_inbound_message_throttle_high_water_mark = SettingImpl.newBuilder("internal.dbms.bolt.inbound_message_throttle.high_watermark", SettingValueParsers.INT, 300).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="When the number of queued inbound messages, previously reached configured high watermark value, drops below this value, reading from underlying channel will be enabled and any pending messages will start queuing again.")
    public static final Setting<Integer> bolt_inbound_message_throttle_low_water_mark = SettingImpl.newBuilder("internal.dbms.bolt.inbound_message_throttle.low_watermark", SettingValueParsers.INT, 100).addConstraint(SettingConstraints.range(1, Integer.MAX_VALUE)).build();
    @Internal
    @Description(value="Enable/disable the use of a merge cumulator for netty")
    public static final Setting<Boolean> netty_message_merge_cumulator = SettingImpl.newBuilder("internal.dbms.bolt.netty_message_merge_cumulator", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Enable/disable generation of response metrics")
    public static final Setting<Boolean> enable_response_metrics = SettingImpl.newBuilder("internal.server.bolt.response_metrics", SettingValueParsers.BOOL, false).build();
    @Internal
    @Description(value="Specifies the initial number of bytes requested when streaming records.")
    public static final Setting<Integer> streaming_buffer_size = SettingImpl.newBuilder("internal.dbms.bolt.streaming_buffer_size", SettingValueParsers.INT, 512).addConstraint(SettingConstraints.min(128)).build();
    @Internal
    @Description(value="Specifies the minimum number of bytes which need to be written in order to flush the local networkpipelines thus making prior written records visible to clients.")
    public static final Setting<Integer> streaming_flush_threshold = SettingImpl.newBuilder("internal.dbms.bolt.streaming_flush_threshold", SettingValueParsers.INT, 8192).addConstraint(SettingConstraints.any(SettingConstraints.is(0), SettingConstraints.min(128))).build();
    @Internal
    @Description(value="Specifies whether transactions shall bind to a single thread for the duration of their lifetime")
    public static final Setting<Boolean> transaction_thread_binding = SettingImpl.newBuilder("internal.dbms.bolt.transaction_thread_binding", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Specifies the duration for which threads will remain bound to wait for new requests to arrive.")
    public static final Setting<Duration> thread_binding_timeout = SettingImpl.newBuilder("internal.dbms.bolt.thread_binding_timeout", SettingValueParsers.DURATION, Duration.ofMillis(10L)).addConstraint(SettingConstraints.min(Duration.ZERO)).build();
    @Internal
    @Description(value="Specifies the string used to connect to the local channel")
    public static final Setting<String> local_channel_address = SettingImpl.newBuilder("internal.dbms.bolt.local_address", SettingValueParsers.STRING, null).build();
    @Internal
    @Description(value="Enabled of disable local bolt connector.")
    public static final Setting<Boolean> enable_local_connector = SettingImpl.newBuilder("internal.dbms.bolt.local_enabled", SettingValueParsers.BOOL, true).build();
    @Internal
    @Description(value="Minimum Bolt Protocol version negotiated by the bolt connector.")
    public static final Setting<ConfiguredProtocolVersion> min_protocol_version = SettingImpl.newBuilder("internal.dbms.bolt.min_protocol_version", PROTOCOL_VERSION, null).build();
    @Internal
    @Description(value="Maximum Bolt Protocol version negotiated by the bolt connector.")
    public static final Setting<ConfiguredProtocolVersion> max_protocol_version = SettingImpl.newBuilder("internal.dbms.bolt.max_protocol_version", PROTOCOL_VERSION, null).build();

    public static enum ProtocolLoggingMode {
        DECODED(false, true),
        RAW(true, false),
        BOTH(true, true);

        private boolean loggingRawTraffic;
        private boolean loggingDecodedTraffic;

        private ProtocolLoggingMode(boolean loggingRawTraffic, boolean loggingDecodedTraffic) {
            this.loggingRawTraffic = loggingRawTraffic;
            this.loggingDecodedTraffic = loggingDecodedTraffic;
        }

        public boolean isLoggingRawTraffic() {
            return this.loggingRawTraffic;
        }

        public boolean isLoggingDecodedTraffic() {
            return this.loggingDecodedTraffic;
        }
    }

    public record ConfiguredProtocolVersion(Integer major, Integer minor) {
    }
}

