/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.OptionalInt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.scheduler.ExecutorServiceFactory;
import org.neo4j.scheduler.SchedulerThreadFactory;

public enum Group {
    TASK_SCHEDULER("Scheduler", ExecutorServiceFactory.unschedulable()),
    PAGE_CACHE_EVICTION("PageCacheEviction"),
    PAGE_CACHE_PRE_FETCHER("PageCachePreFetcher", ExecutorServiceFactory.cachedWithDiscard(), 4),
    FILE_WATCHER("FileWatcher", ExecutorServiceFactory.unschedulable()),
    VM_PAUSE_MONITOR("VmPauseMonitor"),
    LOG_ROTATION("LogRotation"),
    CHECKPOINT("CheckPoint"),
    STORAGE_MAINTENANCE("StorageMaintenance"),
    INDEX_CLEANUP("IndexCleanup"),
    INDEX_CLEANUP_WORK("IndexCleanupWork"),
    TRANSACTION_TIMEOUT_MONITOR("TransactionTimeoutMonitor"),
    INDEX_POPULATION("IndexPopulationMain"),
    INDEX_POPULATION_WORK("IndexPopulationWork", ExecutorServiceFactory.cached()),
    INDEX_SAMPLING("IndexSampling"),
    INDEX_UPDATING("IndexUpdating", ExecutorServiceFactory.singleThread()),
    FILE_IO_HELPER("FileIOHelper"),
    LOG_WRITER("LOG_WRITER"),
    NATIVE_SECURITY("NativeSecurity"),
    METRICS_CSV_WRITE("MetricsCsvWrite"),
    METRICS_GRAPHITE_WRITE("MetricsGraphiteWrite"),
    DATABASE_RECONCILER("DatabaseReconciler"),
    DATABASE_ID_REPOSITORY("DatabaseIdRepository"),
    BUFFER_POOL_MAINTENANCE("BufferPoolMaintenance"),
    CYPHER_WORKER("CypherWorker", ExecutorServiceFactory.workStealing()),
    CYPHER_CACHE("CypherCache", ExecutorServiceFactory.workStealing()),
    DATA_COLLECTOR("DataCollector"),
    BOLT_NETWORK_IO("BoltNetworkIO", ExecutorServiceFactory.unschedulable()),
    BOLT_WORKER("BoltWorker", ExecutorServiceFactory.unschedulable()),
    RAFT_CLIENT("RaftClient"),
    RAFT_SERVER("RaftServer"),
    RAFT_LOG_PRUNING("RaftLogPruning"),
    RAFT_HANDLER("RaftBatchHandler"),
    RAFT_READER_POOL_PRUNER("RaftReaderPoolPruner"),
    RAFT_LOG_PREFETCH("RaftLogPrefetch"),
    RAFT_DRAINING_SERVICE("RaftDrainingService"),
    LEADER_TRANSFER_SERVICE("LeaderTransferService"),
    CORE_STATE_APPLIER("CoreStateApplier"),
    AKKA_HELPER("AkkaActorSystemRestarter"),
    DOWNLOAD_SNAPSHOT("DownloadSnapshot"),
    CATCHUP_CHANNEL_POOL("CatchupChannelPool"),
    CATCHUP_CLIENT("CatchupClient"),
    CATCHUP_PROCESS("CatchupProcess"),
    CATCHUP_SERVER("CatchupServer"),
    DATABASE_INFO_SERVICE("DatabaseInfoService"),
    STORE_COPY_CLIENT("StoreCopyClient"),
    THROUGHPUT_MONITOR("ThroughputMonitor"),
    PANIC_SERVICE("PanicService"),
    CLUSTER_STATUS_CHECK_SERVICE("ClusterStatusService"),
    TOPOLOGY_LOGGER("TopologyLogger"),
    TOPOLOGY_MAINTENANCE("TopologyMaintenance"),
    TOPOLOGY_GRAPH_WRITE_SUPPORT("TopologyGraphWriteSupport"),
    CONNECTIVITY_CHECKS("ConnectivityChecks"),
    SERVER_TRANSACTION_TIMEOUT("ServerTransactionTimeout"),
    PULL_UPDATES("PullUpdates"),
    APPLY_UPDATES("ApplyUpdates"),
    FABRIC_IDLE_DRIVER_MONITOR("FabricIdleDriverMonitor"),
    FABRIC_WORKER("FabricWorker"),
    AUTH_CACHE("AuthCache", ExecutorServiceFactory.workStealing()),
    TESTING("TestingGroup", ExecutorServiceFactory.callingThread());

    private final String name;
    private final ExecutorServiceFactory executorServiceFactory;
    private final Integer defaultParallelism;
    private final AtomicInteger threadCounter;

    private Group(String name, ExecutorServiceFactory executorServiceFactory, Integer defaultParallelism) {
        this.name = name;
        this.executorServiceFactory = executorServiceFactory;
        this.defaultParallelism = defaultParallelism;
        this.threadCounter = new AtomicInteger();
    }

    private Group(String name, ExecutorServiceFactory executorServiceFactory) {
        this(name, executorServiceFactory, null);
    }

    private Group(String name) {
        this(name, ExecutorServiceFactory.cached());
    }

    public String groupName() {
        return this.name;
    }

    public String threadName() {
        return "neo4j." + this.groupName() + "-" + this.threadCounter.incrementAndGet();
    }

    public ExecutorService buildExecutorService(SchedulerThreadFactory factory, int parallelism) {
        return this.executorServiceFactory.build(this, factory, parallelism);
    }

    public OptionalInt defaultParallelism() {
        return this.defaultParallelism == null ? OptionalInt.empty() : OptionalInt.of(this.defaultParallelism);
    }
}

